/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui;

import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.common.model.ISeverity;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.rcp.ui.ContributorColors;
import com.ibm.team.workitem.rcp.ui.Messages;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.queries.IShowsQuery;
import com.ibm.team.workitem.rcp.ui.internal.queries.Queries;
import com.ibm.team.workitem.rcp.ui.internal.wizards.NewWorkItemWizard;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class WorkItemUI {
    public static final String JAZZ_WORKITEM_TYPE = "jazz_workitem";
    private static ContributorColors fgContributorColors;

    public static ILabelProvider createWorkItemLabelProvider() {
        return new WorkItemLabelProvider();
    }

    public static ImageDescriptor getImageDescriptor(URL url, ImageDescriptor defaultDescriptor) {
        if (url != null) {
            try {
                URL localurl;
                if (!"file".equals(url.getProtocol()) && url.toString().contains("%20")) {
                    url = new URL(url.toString().replaceAll("%20", " "));
                }
                if ((localurl = JazzResources.createImageURL((URL)url)) == null) {
                    return defaultDescriptor;
                }
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)localurl);
                JazzResources.registerUrl((ImageDescriptor)descriptor, (URL)localurl);
                return descriptor;
            }
            catch (FileNotFoundException fileNotFoundException) {
                WorkItemRCPUIPlugin.getDefault().log(NLS.bind((String)Messages.WorkItemUI_URL_NOT_FOUND, (Object)url.toString(), (Object[])new Object[0]), null);
            }
            catch (IOException e) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.WorkItemUI_ERROR_CREATING_URL, e);
            }
        }
        return defaultDescriptor;
    }

    public static ImageDescriptor getImageDescriptor(URL url) {
        return WorkItemUI.getImageDescriptor(url, ImagePool.EMPTY);
    }

    public static ImageDescriptor getImageDescriptor(IWorkItemType type) {
        URL url = type != null ? type.getIconURL() : null;
        return WorkItemUI.getImageDescriptor(url);
    }

    public static URL createImageURL(IWorkItemType type) {
        return JazzResources.createURL((ImageDescriptor)WorkItemUI.getImageDescriptor(type));
    }

    public static ImageDescriptor getImageDescriptor(ISeverity severity) {
        URL url = severity != null ? severity.getIconURL() : null;
        return WorkItemUI.getImageDescriptor(url);
    }

    public static URL createImageURL(ISeverity severity) {
        return JazzResources.createURL((ImageDescriptor)WorkItemUI.getImageDescriptor(severity));
    }

    public static ImageDescriptor getImageDescriptor(IPriority priority) {
        URL url = priority != null ? priority.getIconURL() : null;
        return WorkItemUI.getImageDescriptor(url);
    }

    public static URL createImageURL(IPriority priority) {
        return JazzResources.createURL((ImageDescriptor)WorkItemUI.getImageDescriptor(priority));
    }

    @Deprecated
    public static ImageDescriptor getImageDescriptor(IContributorHandle contributor) {
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repos.length) {
            IContributor loggedInContributor = repos[i].loggedInContributor();
            if (loggedInContributor != null && contributor.sameItemId((IItemHandle)loggedInContributor)) {
                return ImagePool.WORKITEM_SELF;
            }
            ++i;
        }
        return ImagePool.WORKITEM_USER;
    }

    public static IEditorPart openEditor(IWorkbenchPage page, Object input) {
        URI uri;
        IWorkItemHandle handle = WorkItemRCPUIPlugin.getWorkItemHandle(input);
        if (handle != null) {
            IEditorInput editorInput = (IEditorInput)Platform.getAdapterManager().loadAdapter((Object)handle, IEditorInput.class.getName());
            if (editorInput != null) {
                try {
                    IWorkbench workbench = page.getWorkbenchWindow().getWorkbench();
                    IEditorRegistry editorRegistry = workbench.getEditorRegistry();
                    IEditorDescriptor defaultEditor = editorRegistry.getDefaultEditor(JAZZ_WORKITEM_TYPE);
                    String editorId = defaultEditor.getId();
                    boolean activate = OpenStrategy.activateOnOpen();
                    return IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)editorId, (boolean)activate);
                }
                catch (PartInitException e) {
                    WorkItemRCPUIPlugin.getDefault().log(Messages.WorkItemUI_CANNOT_OPEN_WORK_ITEM_EDITOR, e);
                }
            } else {
                WorkItemRCPUIPlugin.getDefault().log(Messages.WorkItemUI_COULD_NOT_CREATE_EDITOR_INPUT, null);
            }
        }
        if ((uri = WorkItemUI.createURI2(input)) != null) {
            StandardContextProvider provider = new StandardContextProvider(null);
            provider.setUIContext((Object)page);
            Hyperlinks.open((URI)uri, (ContextProvider)provider);
        }
        return null;
    }

    private static URI createURI2(Object input) {
        if (input instanceof URI) {
            return (URI)input;
        }
        if (input instanceof IReference) {
            return ClientUtils.createURI(null, (IReference)((IReference)input));
        }
        IAuditableHandle auditableHandle = WorkItemUI.getAuditableHandle(input);
        if (auditableHandle != null) {
            return URIService.createAuditableURI((ITeamRepository)((ITeamRepository)auditableHandle.getOrigin()), (IItemHandle)auditableHandle);
        }
        return null;
    }

    private static IAuditableHandle getAuditableHandle(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IAuditableHandle) {
            return (IAuditableHandle)object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)object;
            return (IAuditableHandle)a.getAdapter(IAuditableHandle.class);
        }
        IAdapterManager manager = Platform.getAdapterManager();
        return (IAuditableHandle)manager.getAdapter(object, IAuditableHandle.class);
    }

    public static boolean open(IWorkbenchPage page, Object input) {
        return WorkItemUI.openEditor(page, input) != null;
    }

    public static ContributorColors getContributorColors() {
        if (fgContributorColors == null) {
            fgContributorColors = new ContributorColors();
        }
        return fgContributorColors;
    }

    public static ITeamRepository selectTeamRepository(Shell parentShell) {
        ITeamRepository teamRepository = WorkItemRCPUIPlugin.selectTeamRepository(parentShell);
        if (teamRepository == null) {
            MessageDialog.openError((Shell)parentShell, (String)Messages.WorkItemUI_ERROR, (String)Messages.WorkItemUI_NOT_CONNECTED_TOANY_REPO);
            return null;
        }
        if (FoundationUIUtils.validateRepository((ITeamRepository)teamRepository, (boolean)true, null).getSeverity() == 0) {
            return teamRepository;
        }
        return null;
    }

    public static IProjectAreaHandle selectProjectArea(Shell parentShell) {
        return ProjectAreaPicker.showDialog(parentShell, false);
    }

    public static void showWorkItems(IWorkbenchWindow window, String title, IWorkItemHandle[] workItems) {
        WorkItemUI.showWorkItems(window, null, title, workItems);
    }

    public static void showWorkItems(IWorkbenchWindow window, IProjectAreaHandle projectArea, String title, IWorkItemHandle[] workItems) {
        try {
            IViewPart visiblePart = Queries.findWorkItemExplorer(window);
            if (visiblePart instanceof IShowsQuery) {
                ((IShowsQuery)visiblePart).showWorkItems(projectArea, title, workItems);
            }
        }
        catch (PartInitException e) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.WorkItemUI_CANNOT_OPEN_WORK_ITEM_EXPLORER, e);
        }
    }

    public static void openItemNotFoundDialog(final String typeName) {
        if (Display.getCurrent() == null) {
            FoundationUIJob job = new FoundationUIJob(NLS.bind((String)Messages.WorkItemUI_TYPE_NOT_FOUND_JOB_NAME, (Object)typeName, (Object[])new Object[0])){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    WorkItemUI.openItemNotFoundDialogInUI(typeName);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        } else {
            WorkItemUI.openItemNotFoundDialogInUI(typeName);
        }
    }

    private static void openItemNotFoundDialogInUI(String typeName) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null && workbench.getWorkbenchWindowCount() > 0) {
            window = workbench.getWorkbenchWindows()[0];
        }
        String message = NLS.bind((String)Messages.WorkItemUI_TYPE_NOT_FOUND_MESSAGE, (Object)typeName, (Object[])new Object[0]);
        MessageDialog.openInformation((Shell)(window != null ? window.getShell() : null), (String)NLS.bind((String)Messages.WorkItemUI_TYPE_NOT_FOUND_DIALOG_TITLE, (Object)typeName, (Object[])new Object[0]), (String)message);
    }

    public static void openPermissionDeniedDialog(final String typeName) {
        if (Display.getCurrent() == null) {
            FoundationUIJob job = new FoundationUIJob(NLS.bind((String)Messages.WorkItemUI_PERMISSION_DENIED_OPEN, (Object)typeName, (Object[])new Object[0])){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    WorkItemUI.openPermissionDeniedDialogInUI(typeName);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        } else {
            WorkItemUI.openPermissionDeniedDialog(typeName);
        }
    }

    private static void openPermissionDeniedDialogInUI(String typeName) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null && workbench.getWorkbenchWindowCount() > 0) {
            window = workbench.getWorkbenchWindows()[0];
        }
        String message = NLS.bind((String)Messages.WorkItemUI_PERMISSION_DENIED_OPEN, (Object)typeName, (Object[])new Object[0]);
        MessageDialog.openInformation((Shell)(window != null ? window.getShell() : null), (String)Messages.WorkItemUI_PERMISSION_DENIED, (String)message);
    }

    public static void createWorkItem(Shell shell, IProjectAreaHandle defaultProjectArea, WorkItemOperation initialization) {
        NewWorkItemWizard wizard = new NewWorkItemWizard(defaultProjectArea);
        wizard.setPostCreationOperation(initialization);
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        WizardDialog newDialog = new WizardDialog(shell, (IWizard)wizard);
        newDialog.open();
    }
}

