/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.SimilarityExpression;
import com.ibm.team.workitem.common.expression.WorkItemExpression;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.internal.util.EMFHelper;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.core.queries.Query;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.Messages;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.queries.IShowsQuery;
import com.ibm.team.workitem.rcp.ui.internal.queries.Queries;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class QueriesUI {
    public static void showQueryResults(final IWorkbenchWindow window, final Query query) {
        QueriesUI.runInUI(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IShowsQuery view = QueriesUI.findWorkItemExplorer(window);
                if (view != null) {
                    view.showQuery(query);
                }
            }
        });
    }

    public static void showQueryResults(final IWorkbenchWindow window, final IQueryDescriptorHandle handle) {
        QueriesUI.runInUI(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IShowsQuery view = QueriesUI.findWorkItemExplorer(window);
                if (view != null) {
                    view.showQuery(handle);
                }
            }
        });
    }

    public static void showQueryResults(final IWorkbenchWindow window, final ITeamRepository teamRepository, final String name, final Expression expression) {
        QueriesUI.runInUI(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IShowsQuery view = QueriesUI.findWorkItemExplorer(window);
                if (view != null) {
                    view.showExpression(teamRepository, name, expression);
                }
            }
        });
    }

    public static void showQueryResults(IWorkbenchWindow window, final IProjectAreaHandle projectArea, final String fulltextQuery) {
        final IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IAuditableClient.class);
        IExpressionRunnable runnable = new IExpressionRunnable(){

            public Expression createExpression(IProgressMonitor monitor) throws TeamRepositoryException {
                return QueryUtils.createFullTextExpression((IAuditableCommon)auditableClient, (IProjectAreaHandle)projectArea, (String)fulltextQuery, (IProgressMonitor)monitor);
            }
        };
        QueriesUI.showQueryResults(window, auditableClient.getTeamRepository(), fulltextQuery, runnable);
    }

    public static void showRelatedWorkItems(IWorkbenchWindow window, WorkItemWorkingCopy workingCopy) {
        ITeamRepository teamRepository = workingCopy.getTeamRepository();
        IWorkItemUIWorkingCopy uiCopy = (IWorkItemUIWorkingCopy)workingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        ((WorkItemUIWorkingCopy)uiCopy).synchronizeDocumentChanges();
        IWorkItem itemCopy = (IWorkItem)EMFHelper.copy((Object)workingCopy.getWorkItem());
        if (uiCopy.getNewComment().getLength() > 0) {
            IComment comment = itemCopy.getComments().createComment((IContributorHandle)teamRepository.loggedInContributor(), XMLString.createFromPlainText((String)uiCopy.getNewComment().get()));
            itemCopy.getComments().append(comment);
        }
        QueriesUI.showRelatedWorkItems(window, itemCopy, workingCopy.isDirty());
    }

    public static void showRelatedWorkItems(IWorkbenchWindow window, final IWorkItem workItem, final boolean isModifiedWorkItem) {
        String title = workItem.getId() > 0 ? NLS.bind((String)Messages.QueriesUI_POTENTIAL_DUPLICATES_OF, (Object)String.valueOf(workItem.getId()), (Object[])new Object[0]) : Messages.QueriesUI_POTENTIAL_DUPLICATES;
        final IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)workItem, IAuditableClient.class);
        IExpressionRunnable runnable = new IExpressionRunnable(){

            public Expression createExpression(IProgressMonitor monitor) throws TeamRepositoryException {
                Expression similarityExpression = this.createSimilarityExpression(workItem);
                Expression scoped = QueryUtils.scopeToProjectArea((IAuditableCommon)auditableClient, (Expression)similarityExpression, (IProjectAreaHandle)workItem.getProjectArea(), (IProgressMonitor)monitor);
                return QueryUtils.orderByScore((Expression)scoped);
            }

            private Expression createSimilarityExpression(IWorkItem workItem2) {
                if (isModifiedWorkItem || workItem2.isNewItem()) {
                    return SimilarityExpression.createSimilarityExpression((IWorkItem)workItem2);
                }
                return new WorkItemExpression((IWorkItemHandle)workItem2.getItemHandle());
            }
        };
        QueriesUI.showQueryResults(window, auditableClient.getTeamRepository(), title, runnable);
    }

    public static void showRelatedWorkItems(IWorkbenchWindow window, IWorkItem workItem) {
        QueriesUI.showRelatedWorkItems(window, workItem, workItem.isWorkingCopy());
    }

    public static void showRelatedWorkItems(IWorkbenchWindow window, final IProjectAreaHandle projectArea, String queryTitle, final String summary, final String description) {
        final IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IAuditableClient.class);
        IExpressionRunnable runnable = new IExpressionRunnable(){

            public Expression createExpression(IProgressMonitor monitor) throws TeamRepositoryException {
                SimilarityExpression similarityExpression = new SimilarityExpression(summary, description, null);
                Expression scoped = QueryUtils.scopeToProjectArea((IAuditableCommon)auditableClient, (Expression)similarityExpression, (IProjectAreaHandle)projectArea, (IProgressMonitor)monitor);
                return QueryUtils.orderByScore((Expression)scoped);
            }
        };
        QueriesUI.showQueryResults(window, auditableClient.getTeamRepository(), queryTitle, runnable);
    }

    private static void showQueryResults(final IWorkbenchWindow window, final ITeamRepository repository, final String title, final IExpressionRunnable runnable) {
        UIUpdaterJob job = new UIUpdaterJob(Messages.QueriesUI_QUICK_SEARCH){
            private Expression fExpression;

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    this.fExpression = runnable.createExpression(monitor);
                    return super.runInBackground(monitor);
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.workitem.rcp.ui", 4, Messages.QueriesUI_ERROR_CREATING_FULLTEXT_EXPRESSION, (Throwable)e);
                }
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (this.fExpression != null) {
                    QueriesUI.showQueryResults(window, repository, title, this.fExpression);
                }
                return super.runInUI(monitor);
            }
        };
        job.schedule();
    }

    public static IEditorPart editQuery(IWorkbenchPage page, IQueryDescriptorHandle handle) {
        try {
            IEditorInput editorInput = (IEditorInput)Platform.getAdapterManager().loadAdapter((Object)handle, IEditorInput.class.getName());
            if (editorInput != null) {
                return page.openEditor(editorInput, "com.ibm.team.workitem.queryeditor");
            }
        }
        catch (PartInitException e) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.QueriesUI_CANNOT_OPEN_QUERY_EDITOR, e);
        }
        return null;
    }

    private static IShowsQuery findWorkItemExplorer(IWorkbenchWindow window) {
        try {
            IViewPart view = Queries.findWorkItemExplorer(window);
            if (view instanceof IShowsQuery) {
                return (IShowsQuery)view;
            }
        }
        catch (PartInitException e) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.WorkItemUI_CANNOT_OPEN_WORK_ITEM_EXPLORER, e);
        }
        return null;
    }

    private static void runInUI(IRunnableWithProgress runnable) {
        WorkItemRCPUIPlugin.runInUI(Messages.QueriesUI_SHOW_QUERY, runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    private static interface IExpressionRunnable {
        public Expression createExpression(IProgressMonitor var1) throws TeamRepositoryException;
    }
}

