/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.common.LoginFailureException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.ILightWeightWorkItemCreator;
import com.ibm.team.workitem.rcp.ui.IValidationListener;
import com.ibm.team.workitem.rcp.ui.LightweightWorkItemCreationContext;
import com.ibm.team.workitem.rcp.ui.Messages;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class LightWeightWorkItemCreationDialog
extends SelectionStatusDialog {
    private ILightWeightWorkItemCreator fCreator;
    private LightweightWorkItemCreationContext fContext;
    private boolean fInitSucceeded = true;

    public LightWeightWorkItemCreationDialog(Shell shell, LightweightWorkItemCreationContext context) {
        super(shell);
        this.setStatusLineAboveButtons(true);
        this.setMessage(Messages.LightWeightWorkItemCreationDialog_FILL_IN_DETAILS);
        this.fCreator = (ILightWeightWorkItemCreator)Adapters.getAdapter((Object)context, ILightWeightWorkItemCreator.class);
        if (this.fCreator == null) {
            this.fInitSucceeded = false;
            return;
        }
        this.fContext = context;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IStatus status = LightWeightWorkItemCreationDialog.this.fCreator.init(LightWeightWorkItemCreationDialog.this.fContext, monitor);
                if (status.getSeverity() == 8) {
                    throw new InterruptedException();
                }
                if (status.getSeverity() == 4) {
                    throw new InvocationTargetException(status.getException());
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NotLoggedInException || cause instanceof LoginFailureException) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.LightWeightWorkItemCreationDialog_NOT_LOGGED_IN, (String)cause.getMessage());
            } else if (cause instanceof TeamRepositoryException) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.LightWeightWorkItemCreationDialog_INITIALIZATION_ERROR, (String)cause.getMessage());
            } else {
                WorkItemRCPUIPlugin.getDefault().log(Messages.LightWeightWorkItemCreationDialog_ERROR_INITIALIZING, cause);
            }
            this.fInitSucceeded = false;
        }
        catch (InterruptedException interruptedException) {
            this.fInitSucceeded = false;
        }
        this.fCreator.setValidationListener(new IValidationListener(){

            public void validationChanged(IStatus status) {
                if (status.isOK()) {
                    LightWeightWorkItemCreationDialog.this.updateStatus((IStatus)new Status(0, "com.ibm.team.workitem.rcp.ui", ""));
                } else {
                    LightWeightWorkItemCreationDialog.this.updateStatus(status);
                }
            }
        });
    }

    public IWorkItemHandle getCreatedWorkItem() {
        return this.fCreator.getCreatedWorkItem();
    }

    protected void configureShell(Shell shell) {
        shell.setText(Messages.LightWeightWorkItemCreationDialog_CREATE_WORKITEM);
        super.configureShell(shell);
    }

    public void create() {
        this.setShellStyle(80);
        super.create();
        this.getShell().setSize(this.getShell().computeSize(500, -1));
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.verticalSpacing = 15;
        c.setLayout((Layout)layout);
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = this.createMessageArea(c);
        GridData data = new GridData(16384, 128, false, false);
        label.setLayoutData((Object)data);
        Control content = this.fCreator.createContent(c);
        data = new GridData(4, 4, true, true);
        content.setLayoutData((Object)data);
        return c;
    }

    public int open() {
        if (!this.fInitSucceeded) {
            return 1;
        }
        return super.open();
    }

    protected void okPressed() {
        Status[] status = new Status[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress((IStatus[])status){
            private final /* synthetic */ IStatus[] val$status;
            {
                this.val$status = iStatusArray;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                this.val$status[0] = LightWeightWorkItemCreationDialog.this.fCreator.save(monitor);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            status[0] = Status.CANCEL_STATUS;
        }
        if (status[0] != null && status[0].getSeverity() != 8 && status[0].getSeverity() != 4) {
            super.okPressed();
        }
    }

    protected Control createButtonBar(Composite parent) {
        GridData gd = new GridData(768);
        Label sep = new Label(parent, 258);
        sep.setLayoutData((Object)gd);
        Control bar = super.createButtonBar(parent);
        return bar;
    }

    protected void computeResult() {
    }

    public Object[] getResult() {
        return new Object[]{this.fCreator.getCreatedWorkItem()};
    }
}

