/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui;

import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.UUID;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.RGB;

public final class ContributorColors {
    private static final int MAX_COLORS = 32;
    private static int fgReserved = 0;
    public static final Role CREATOR = new Role();
    public static final Role OWNER = new Role();
    private Map<UUID, RGB> fColors = new HashMap<UUID, RGB>();
    private int fCount = fgReserved;

    public RGB getRoleColor(Role role) {
        Assert.isLegal((role != null ? 1 : 0) != 0);
        if (role.fRGB == null) {
            role.fRGB = this.computeRGB(role.fIndex);
        }
        return role.fRGB;
    }

    public RGB getContributorColor(IContributorHandle contributor) {
        UUID itemId = contributor.getItemId();
        RGB rgb = this.fColors.get(itemId);
        if (rgb == null) {
            rgb = this.computeRGB((this.fCount - fgReserved) % (32 - fgReserved) + fgReserved);
            ++this.fCount;
            this.fColors.put(itemId, rgb);
        }
        return rgb;
    }

    private RGB computeRGB(int i) {
        float hue = this.computeHue(i);
        RGB rgb = new RGB(hue, 1.0f, 1.0f);
        return rgb;
    }

    private float computeHue(int i) {
        int base = 3;
        int l = i < base ? 0 : (int)Math.floor(Math.log(i / base) / Math.log(2.0));
        int m = (int)Math.pow(2.0, l) * base;
        int j = i < base ? i : i - m;
        float offset = i < base ? 0.0f : (float)((double)(180 / base) / Math.pow(2.0, l));
        float delta = i < base ? 120.0f : 2.0f * offset;
        float hue = (offset + (float)j * delta) % 360.0f;
        return hue;
    }

    public static final class Role {
        private int fIndex;
        private RGB fRGB = null;

        private Role() {
            int n = fgReserved;
            fgReserved = n + 1;
            this.fIndex = n;
        }
    }
}

