/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.ArtifactLink;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.client.internal.util.WorkItemEventResolver;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.ide.ui.internal.editor.DocumentModel;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopyManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemUIWorkingCopy
implements IWorkItemUIWorkingCopy {
    private WorkItemWorkingCopy fWorkingCopy;
    private DocumentModel fSummarySupport;
    private DocumentModel fNewCommentSupport;
    private int fDocumentChangeKind = 1;
    private List<DocumentModel> fDocumentModels = new ArrayList<DocumentModel>();
    private Map<String, DocumentModel> fAttributeModels = new HashMap<String, DocumentModel>();
    private InternalListener fInternalListener = new InternalListener();
    private UIWorkItemListener fUIListener = new UIWorkItemListener();
    private WorkItemEventResolver fEventResolver;
    private ResolvedWorkItem fResolvedWorkItem;
    private WorkItemUIWorkingCopyManager fManager;

    public WorkItemUIWorkingCopy(WorkItemWorkingCopy workingCopy) {
        this.fWorkingCopy = workingCopy;
        this.fEventResolver = new WorkItemEventResolver((IWorkItemListener)this.fUIListener, (IWorkItemHandle)this.fWorkingCopy.getWorkItem());
        this.fResolvedWorkItem = new ResolvedWorkItem(this.getWorkingCopy().getWorkItem());
        this.fUIListener.addListener(this.fResolvedWorkItem.getWorkItemListener());
        this.fManager = new WorkItemUIWorkingCopyManager(this);
        ITeamRepository teamRepository = workingCopy.getTeamRepository();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        workItemClient.getWorkItemWorkingCopyManager().addWorkItemListener((IWorkItemListener)this.fEventResolver);
    }

    public boolean isSummaryInUse() {
        return this.fSummarySupport != null;
    }

    @Override
    public IStyledDocument getSummary() {
        return this.getSummarySupport().getDocument();
    }

    public IAnnotationModel getSummaryAnnotationModel() {
        return this.getSummarySupport().getAnnotationModel();
    }

    public DocumentModel getSummarySupport() {
        if (this.fSummarySupport == null) {
            this.fSummarySupport = new DocumentModel(this.getWorkItem().getHTMLSummary());
            this.fSummarySupport.getDocument().addDocumentListener((IDocumentListener)this.fInternalListener);
            this.addDocumentModel(this.fSummarySupport);
        }
        return this.fSummarySupport;
    }

    private IAttribute getDescriptionAttribute() {
        return this.getResolvedWorkItem().findAttribute(WorkItemAttributes.DESCRIPTION);
    }

    public IStyledDocument getDescription() {
        Assert.isTrue((boolean)this.fResolvedWorkItem.isResolved());
        return this.getDocumentModel(this.getDescriptionAttribute()).getDocument();
    }

    Map<String, DocumentModel> getAttributeModels() {
        Assert.isTrue((boolean)this.fResolvedWorkItem.isResolved());
        return this.fAttributeModels;
    }

    public DocumentModel getDocumentModel(IAttribute attribute) {
        Assert.isTrue((boolean)this.fResolvedWorkItem.isResolved());
        if (this.fAttributeModels.get(attribute.getIdentifier()) == null) {
            DocumentModel model = new DocumentModel(XMLString.createFromXMLText((String)((String)this.getWorkItem().getValue(attribute))));
            model.getDocument().addDocumentListener((IDocumentListener)this.fInternalListener);
            this.addDocumentModel(model);
            this.fAttributeModels.put(attribute.getIdentifier(), model);
        }
        return this.fAttributeModels.get(attribute.getIdentifier());
    }

    public IComment[] getVisibleComments() {
        return this.fManager.getVisibleComments();
    }

    public IComment getIgnoredComment() {
        return this.fManager.getIgnoredComment();
    }

    public int getNumberOfComments() {
        return this.fManager.getVisibleComments().length;
    }

    public boolean isNewCommentInUse() {
        return this.fNewCommentSupport != null;
    }

    @Override
    public IStyledDocument getNewComment() {
        return this.getNewCommentSupport().getDocument();
    }

    public IAnnotationModel getNewCommentAnnotationModel() {
        return this.getNewCommentSupport().getAnnotationModel();
    }

    private DocumentModel getNewCommentSupport() {
        if (this.fNewCommentSupport == null) {
            this.fNewCommentSupport = new DocumentModel();
            this.fNewCommentSupport.getDocument().addDocumentListener((IDocumentListener)this.fInternalListener);
            this.addDocumentModel(this.fNewCommentSupport);
        }
        return this.fNewCommentSupport;
    }

    public void markOccurrences(String findString, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        if (findString.length() == 0) {
            this.removeOccurrences();
            return;
        }
        for (DocumentModel documentModel : this.fDocumentModels) {
            documentModel.markOccurrences(findString, caseSensitive, wholeWord, regExSearch);
        }
    }

    public void removeOccurrences() {
        for (DocumentModel documentModel : this.fDocumentModels) {
            documentModel.removeOccurrences();
        }
    }

    public void addDocumentModel(DocumentModel documentModel) {
        this.fDocumentModels.add(documentModel);
    }

    public void removeDocumentModel(DocumentModel documentModel) {
        this.fDocumentModels.remove(documentModel);
    }

    public List<DocumentModel> getDocumentModels() {
        return this.fDocumentModels;
    }

    public void changeDocument(Runnable runnable, int kind) {
        try {
            this.fDocumentChangeKind = kind;
            runnable.run();
        }
        finally {
            this.fDocumentChangeKind = 1;
        }
    }

    public void synchronizeDocumentChanges() {
        this.fManager.synchronizeDocumentChanges();
    }

    public ResolvedWorkItem getResolvedWorkItem() {
        Assert.isTrue((boolean)this.fResolvedWorkItem.isResolved());
        return this.fResolvedWorkItem;
    }

    public boolean isResolvedWorkItemSet() {
        return this.fResolvedWorkItem.isResolved();
    }

    public UIWorkItemListener getUIWorkItemListener() {
        return this.fUIListener;
    }

    public void resolve(IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.fResolvedWorkItem.isResolved()) {
            this.fResolvedWorkItem.resolve(monitor);
        }
    }

    public void dispose() {
        if (this.fSummarySupport != null) {
            this.removeDocumentModel(this.fSummarySupport);
            this.fSummarySupport.getDocument().removeDocumentListener((IDocumentListener)this.fInternalListener);
            this.fSummarySupport = null;
        }
        if (this.fAttributeModels != null) {
            for (DocumentModel model : this.fAttributeModels.values()) {
                if (!(model instanceof DocumentModel)) continue;
                model.getDocument().removeDocumentListener((IDocumentListener)this.fInternalListener);
            }
            this.fAttributeModels = null;
        }
        if (this.fNewCommentSupport != null) {
            this.removeDocumentModel(this.fNewCommentSupport);
            this.fNewCommentSupport.getDocument().removeDocumentListener((IDocumentListener)this.fInternalListener);
            this.fNewCommentSupport = null;
        }
        if (this.fEventResolver != null) {
            ITeamRepository teamRepository = this.fWorkingCopy.getTeamRepository();
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            workItemClient.getWorkItemWorkingCopyManager().removeWorkItemListener((IWorkItemListener)this.fEventResolver);
            this.fEventResolver = null;
        }
        if (this.fResolvedWorkItem != null && this.fUIListener != null) {
            this.fUIListener.removeListener(this.fResolvedWorkItem.getWorkItemListener());
            this.fResolvedWorkItem = null;
            this.fUIListener = null;
        }
        this.fWorkingCopy = null;
    }

    @Override
    public WorkItemWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    private IWorkItem getWorkItem() {
        return this.getWorkingCopy().getWorkItem();
    }

    public Collection<ArtifactLink> getArtifactLinks() {
        return ((WorkItemWorkingCopyImpl)this.fWorkingCopy).getArtifactLinks();
    }

    private class InternalListener
    implements IDocumentListener {
        private InternalListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (!(WorkItemUIWorkingCopy.this.getWorkingCopy().isDirty() || WorkItemUIWorkingCopy.this.fDocumentChangeKind != 1 || event.getDocument() == WorkItemUIWorkingCopy.this.getNewComment() && WorkItemUIWorkingCopy.this.getNewComment().getLength() == 0)) {
                ((WorkItemWorkingCopyImpl)WorkItemUIWorkingCopy.this.getWorkingCopy()).setDirty(true);
            }
        }
    }
}

