/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedControl;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DecoratedText
extends DecoratedControl {
    protected Text fText;
    private Control fTextContainer;
    private ITextSelection fSelection = new InternalSelection();
    private Point fOldSelection = null;

    public DecoratedText(Composite parent, int style) {
        super(parent, style, 0);
    }

    public DecoratedText(Composite parent, int style, int options) {
        super(parent, style, options);
    }

    public DecoratedText(int options) {
        super(options);
    }

    public Object getValue() {
        return this.getText().getText();
    }

    public void setValue(String value) {
        this.getText().setText(value);
    }

    protected boolean isSet() {
        return this.getText().getText().length() > 0;
    }

    public Text getText() {
        return this.fText;
    }

    protected Control getDecoratedControl() {
        return this.fTextContainer;
    }

    protected Control createControl(Composite parent, int style) {
        this.fTextContainer = this.createText(parent, style);
        this.fTextContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Listener selectionListener = new Listener(){

            public void handleEvent(Event event) {
                DecoratedText.this.handleSelectionEvent(event);
            }
        };
        this.fText.addListener(1, selectionListener);
        this.fText.addListener(2, selectionListener);
        this.fText.addListener(3, selectionListener);
        this.fText.addListener(4, selectionListener);
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DecoratedText.this.handleModifyEvent(e);
            }
        });
        return this.fTextContainer;
    }

    protected Control createText(Composite parent, int style) {
        this.fText = new Text(parent, style);
        boolean multi = (style & 2) != 0;
        TeamFormLayouts.setLayoutData((Control)this.fText, (ITeamFormData)(multi ? ITeamFormData.MULTI_LINE_TEXT : ITeamFormData.SINGLE_LINE_TEXT));
        return this.fText;
    }

    private void handleSelectionEvent(Event event) {
        Point newSelection = this.fText.getSelection();
        if (!newSelection.equals((Object)this.fOldSelection)) {
            boolean doFire = this.fOldSelection != null && this.fOldSelection.x != this.fOldSelection.y || newSelection.x != newSelection.y;
            this.fOldSelection = newSelection;
            if (doFire) {
                this.fireSelectionChanged();
            }
        }
    }

    private void handleModifyEvent(ModifyEvent e) {
        this.updateRequiredDecoration();
    }

    public ISelection getSelection() {
        return this.fSelection;
    }

    public void setSelection(ISelection selection) {
        Assert.isTrue((boolean)(selection instanceof ITextSelection));
        ITextSelection textSelection = (ITextSelection)selection;
        int start = textSelection.getOffset();
        Assert.isTrue((start >= 0 && start <= this.getText().getText().length() ? 1 : 0) != 0);
        int end = start + textSelection.getLength();
        Assert.isTrue((end >= 0 && end <= this.getText().getText().length() ? 1 : 0) != 0);
        Assert.isTrue((start <= end ? 1 : 0) != 0);
        this.getText().setSelection(start, end);
    }

    private class InternalSelection
    implements ITextSelection {
        private InternalSelection() {
        }

        public int getOffset() {
            return DecoratedText.this.fText.getSelection().x;
        }

        public int getLength() {
            if (DecoratedText.this.fText.isDisposed()) {
                return 0;
            }
            return DecoratedText.this.fText.getSelectionCount();
        }

        public int getStartLine() {
            return -1;
        }

        public int getEndLine() {
            return -1;
        }

        public String getText() {
            return DecoratedText.this.fText.getSelectionText();
        }

        public boolean isEmpty() {
            return this.getLength() == 0;
        }
    }
}

