/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedControl;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedRadioGroupUpdaterJob;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages2;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DecoratedRadioGroup
extends DecoratedControl {
    private static final int DEFAULT_OPTION = 0;
    SelectionAdapter fSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DecoratedRadioGroup.this.handleSelectionEvent(e);
        }
    };
    private Object[] fValueSet = new Object[0];
    private Object fValue;
    private Object fNullValue;
    private Composite fRadioContainer;
    private Comparator fComparator;
    private IElementComparer fElementComparer;
    private ILabelProvider fLabelProvider;

    public DecoratedRadioGroup(Composite parent, int style, int options) {
        super(parent, style, options, 16512, 16512);
    }

    public DecoratedRadioGroup(Composite parent, int style) {
        this(parent, style, 0);
    }

    protected Control createControl(Composite parent, int style) {
        Composite container;
        if ((this.getOptions() & 4) != 0) {
            container = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            container.setLayout((Layout)layout);
        } else {
            container = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            container.setLayout((Layout)layout);
        }
        TeamFormLayouts.setLayoutData((Control)container, (ITeamFormData)ITeamFormData.RADIO);
        this.fRadioContainer = container;
        return container;
    }

    protected boolean isSet() {
        return !this.equals(this.fValue, this.fNullValue);
    }

    public Control getDecoratedControl() {
        return this.fRadioContainer;
    }

    public ISelection getSelection() {
        if (this.fValue == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection(this.fValue);
    }

    public void setSelection(ISelection selection) {
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Assert.isTrue((structuredSelection.size() <= 1 ? 1 : 0) != 0);
        Object element = ((IStructuredSelection)selection).getFirstElement();
        this.setValue(element);
    }

    public Object[] getValueSet() {
        return this.fValueSet;
    }

    public void setValueSet(Object[] valueSet) {
        Assert.isNotNull((Object)valueSet);
        this.fValueSet = valueSet;
        if (this.fComparator != null) {
            Object[] sortedValues = new Object[valueSet.length];
            System.arraycopy(valueSet, 0, sortedValues, 0, valueSet.length);
            Arrays.sort(sortedValues, this.fComparator);
            this.fValueSet = sortedValues;
        }
        this.updateItems();
    }

    public Object getValue() {
        return this.fValue;
    }

    public void setValue(Object value) {
        this.fValue = value;
        this.updateItem();
        this.updateRequiredDecoration();
    }

    public void setNullValue(Object nullValue) {
        this.fNullValue = nullValue;
        this.updateRequiredDecoration();
    }

    public void setElementComparer(IElementComparer elementComparer) {
        this.fElementComparer = elementComparer;
        this.updateRequiredDecoration();
    }

    public Control getRadioGroup() {
        return this.fRadioContainer;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
    }

    public void setSorter(Comparator comparator) {
        this.fComparator = comparator;
    }

    private int indexOf(Object[] values, Object value) {
        int i = 0;
        while (i < values.length) {
            if (this.equals(values[i], value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean equals(Object left, Object right) {
        if (this.fElementComparer != null) {
            return this.fElementComparer.equals(left, right);
        }
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }

    private String getText(Object element) {
        if (this.fLabelProvider == null) {
            if (element == null) {
                return "";
            }
            return element.toString();
        }
        String text = this.fLabelProvider.getText(element);
        if (text == null) {
            return "";
        }
        return text;
    }

    private Image getImage(Object element) {
        return this.fLabelProvider != null ? this.fLabelProvider.getImage(element) : null;
    }

    private void updateItems() {
        if (this.fRadioContainer.isDisposed()) {
            return;
        }
        Control[] kids = this.fRadioContainer.getChildren();
        int i = 0;
        while (i < kids.length) {
            kids[i].dispose();
            ++i;
        }
        if (this.fValueSet == null || this.fValueSet.length == 0) {
            if (this.fValue == null) {
                Label l = new Label(this.fRadioContainer, 0x1000000);
                l.setText(Messages2.DecoratedRadioGroup_NO_INFORMATION);
                l.setForeground(l.getDisplay().getSystemColor(16));
                l.setBackground(null);
                l.setLayoutData((Object)new GridData(16384, 128, false, false));
            } else {
                Button button = new Button(this.fRadioContainer, 16);
                button.setEnabled(false);
                button.addSelectionListener((SelectionListener)this.fSelectionAdapter);
                button.setText(this.getText(this.fValue));
                button.setSelection(true);
                button.setData(this.fValue);
            }
        } else if (this.fValueSet.length > 0 && DecoratedRadioGroupUpdaterJob.RETRIEVEENTRY.equals(this.fValueSet[0])) {
            Label l = new Label(this.fRadioContainer, 0x1000000);
            l.setText(DecoratedRadioGroupUpdaterJob.RETRIEVEENTRY);
            l.setForeground(l.getDisplay().getSystemColor(16));
            l.setBackground(null);
            l.setLayoutData((Object)new GridData(16384, 128, false, false));
        } else {
            boolean hasAtleastOneImage = false;
            Image firstButtonImage = null;
            Image emptyImage = this.getImage(ImagePool.EMPTY);
            Button button1 = null;
            Button orphanButton = null;
            if (this.fValue != null && this.indexOf(this.fValueSet, this.fValue) == -1) {
                orphanButton = new Button(this.fRadioContainer, 16);
                orphanButton.addSelectionListener((SelectionListener)this.fSelectionAdapter);
                orphanButton.setText(this.getText(this.fValue));
                orphanButton.setData(this.fValue);
                orphanButton.setSelection(true);
            }
            int i2 = 0;
            while (i2 < this.fValueSet.length) {
                Button button = new Button(this.fRadioContainer, 16);
                button.addSelectionListener((SelectionListener)this.fSelectionAdapter);
                button.setText(this.getText(this.fValueSet[i2]));
                button.setData(this.fValueSet[i2]);
                Image image = this.getImage(this.fValueSet[i2]);
                if (i2 == 0) {
                    firstButtonImage = image;
                    button1 = button;
                }
                if (!hasAtleastOneImage && image != null && !image.equals((Object)emptyImage)) {
                    hasAtleastOneImage = true;
                }
                if (hasAtleastOneImage) {
                    button.setImage(image);
                }
                button.setLayoutData((Object)new GridData(16384, 128, false, false));
                if (this.getText(this.fValueSet[i2]).equals(this.getText(this.fValue))) {
                    button.setSelection(true);
                }
                ++i2;
            }
            if (hasAtleastOneImage && firstButtonImage != null && button1 != null) {
                button1.setImage(firstButtonImage);
                if (orphanButton != null) {
                    orphanButton.setImage(emptyImage);
                }
            }
        }
        this.fRadioContainer.layout(true);
    }

    private void updateItem() {
        if (this.fRadioContainer.isDisposed() || this.fValueSet == null || this.fValueSet.length > 0 && DecoratedRadioGroupUpdaterJob.RETRIEVEENTRY.equals(this.fValueSet[0])) {
            return;
        }
        Control[] kids = this.fRadioContainer.getChildren();
        int i = 0;
        while (i < kids.length) {
            if (kids[i] instanceof Button) {
                Button button = (Button)kids[i];
                if (button.getSelection() && !this.equals(button.getData(), this.fValue)) {
                    if (this.indexOf(this.fValueSet, button.getData()) == -1) {
                        button.setEnabled(false);
                    }
                    button.setSelection(false);
                } else if (this.equals(button.getData(), this.fValue) && !button.getSelection()) {
                    button.setSelection(true);
                }
            }
            ++i;
        }
    }

    private void handleSelectionEvent(SelectionEvent e) {
        Button source = null;
        if (e.widget instanceof Button) {
            source = (Button)e.widget;
            if (!source.getSelection()) {
                if (this.indexOf(this.fValueSet, source.getData()) == -1) {
                    source.setEnabled(false);
                }
                return;
            }
            if (this.equals(source.getData(), this.fValue)) {
                return;
            }
            if (this.indexOf(this.fValueSet, source.getData()) != -1) {
                this.fValue = source.getData();
            }
        }
        this.updateRequiredDecoration();
        this.fireSelectionChanged();
    }
}

