/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedControl;
import com.ibm.team.workitem.ide.ui.internal.editor.LabelBasedProposalProvider;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.FieldAssistColors;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DecoratedList
extends DecoratedControl
implements ISelectionProvider {
    public static final int DEFAULT_OPTION = 0;
    public static final String DATA_KEY = "_value";
    public static final String RETRIEVEENTRY = Messages2.DecoratedRadioGroupUpdaterJob_RETRIEVING;
    protected ArrayList fValue = new ArrayList();
    protected ArrayList fEnumValue;
    protected ArrayList fValueSet = new ArrayList();
    protected ArrayList fValueSetExtended = new ArrayList();
    private org.eclipse.swt.widgets.List fList;
    protected ILabelProvider fLabelProvider;
    protected IElementComparer fElementComparer;
    protected Comparator fComparator;
    protected ResourceManager fResourceManager;
    protected LabelBasedProposalProvider fFieldAssist;
    protected Object fNullValue;
    protected Color fMissingRequiredBackground;
    protected boolean fRetrieving = false;

    public DecoratedList(Composite parent, int style) {
        this(parent, style, 0, null);
    }

    public DecoratedList(Composite parent, int style, int options, ResourceManager mgr) {
        super(parent, style, options, 16512, 16512);
        this.fEnumValue = new ArrayList();
        this.fResourceManager = mgr;
    }

    public Object[] getValueSet() {
        return this.fValueSet.toArray();
    }

    public Object[] getValue() {
        return this.fValue.toArray();
    }

    public void setValue(Object value) {
        Object[] values = this.getText(value);
        this.setValues(values);
    }

    public void setValues(Object[] values) {
        this.fValue.clear();
        if (values == null || values.length == 0) {
            this.fList.deselectAll();
            return;
        }
        int[] selectedIndices = new int[values.length];
        int selectedCount = 0;
        int j = 0;
        while (values != null && j < values.length) {
            int i = 0;
            while (i < this.fValueSet.size()) {
                ILiteral lit = null;
                if (this.fValueSet.get(i) instanceof ILiteral) {
                    lit = (ILiteral)this.fValueSet.get(i);
                    if (values[j].equals(lit.getIdentifier2().getStringIdentifier())) {
                        this.fValue.add(values[j]);
                        selectedIndices[selectedCount++] = i;
                        break;
                    }
                } else if (this.fValueSet.get(i) instanceof String && this.fValueSet.get(i).equals(values[j])) {
                    this.fValue.add(values[j]);
                    selectedIndices[selectedCount++] = i;
                    break;
                }
                ++i;
            }
            if (i == this.fValueSet.size()) {
                this.fValue.add(values[j]);
                selectedIndices[selectedCount++] = i;
            }
            ++j;
        }
        if (selectedCount > 0) {
            int[] newSelectedIndices;
            if (selectedCount < this.fValue.size()) {
                newSelectedIndices = new int[selectedCount];
                int j2 = 0;
                while (j2 < selectedCount) {
                    newSelectedIndices[j2] = selectedIndices[j2];
                    ++j2;
                }
            } else {
                newSelectedIndices = selectedIndices;
            }
            this.fList.setSelection(newSelectedIndices);
        }
        int i = 0;
        while (i < this.fValueSetExtended.size()) {
            if (!this.fValue.contains(this.fValueSetExtended.get(i))) {
                this.fList.remove((String)this.fValueSetExtended.get(i));
                this.fValueSetExtended.remove(i);
            }
            ++i;
        }
        this.updateRequiredDecoration();
    }

    public void setValueSet(Object[] valueSet) {
        Assert.isNotNull((Object)valueSet);
        this.fValueSet.clear();
        this.fValueSetExtended.clear();
        int setsIdx = 0;
        while (setsIdx < valueSet.length) {
            this.fValueSet.add(valueSet[setsIdx]);
            ++setsIdx;
        }
        if (this.isRetrieving()) {
            this.fList.removeAll();
            this.fList.add((String)valueSet[0]);
            return;
        }
        if (this.fComparator != null) {
            Object[] sortedValues = new Object[valueSet.length];
            System.arraycopy(valueSet, 0, sortedValues, 0, valueSet.length);
            Arrays.sort(sortedValues, this.fComparator);
            this.fValueSet.clear();
            int setsIdx2 = 0;
            while (setsIdx2 < sortedValues.length) {
                this.fValueSet.add(sortedValues[setsIdx2]);
                ++setsIdx2;
            }
        }
        this.fList.removeAll();
        int i = 0;
        while (i < this.fValueSet.size()) {
            ILiteral lit = null;
            if (this.fValueSet.get(i) instanceof ILiteral) {
                lit = (ILiteral)this.fValueSet.get(i);
                this.fList.add(lit.getName());
            } else {
                this.fList.add((String)this.fValueSet.get(i));
            }
            ++i;
        }
        int[] selectedIndices = new int[this.fValue.size()];
        int selectedCount = 0;
        int j = 0;
        while (this.fValue != null && j < this.fValue.size()) {
            int i2 = 0;
            while (i2 < this.fValueSet.size()) {
                ILiteral lit = null;
                if (this.fValueSet.get(i2) instanceof ILiteral) {
                    lit = (ILiteral)this.fValueSet.get(i2);
                }
                if (lit != null && this.fValue.get(j).equals(lit.getIdentifier2().getStringIdentifier()) || this.fValue.get(j).equals(this.fValueSet.get(i2))) {
                    selectedIndices[selectedCount++] = i2;
                    break;
                }
                ++i2;
            }
            if (i2 == this.fValueSet.size()) {
                this.fList.add((String)this.fValue.get(j));
                selectedIndices[selectedCount++] = this.fList.getItemCount() - 1;
                this.fValueSetExtended.add(this.fValue.get(j));
            }
            ++j;
        }
        if (selectedCount > 0) {
            int[] newSelectedIndices;
            if (selectedCount < this.fValue.size()) {
                newSelectedIndices = new int[selectedCount];
                int k = 0;
                while (k < selectedCount) {
                    newSelectedIndices[k] = selectedIndices[k];
                    ++k;
                }
            } else {
                newSelectedIndices = selectedIndices;
            }
            this.fList.setSelection(newSelectedIndices);
        }
    }

    public void setNullValue(Object nullValue) {
        this.fNullValue = nullValue;
        this.updateRequiredDecoration();
    }

    public void setElementComparer(IElementComparer elementComparer) {
        this.fElementComparer = elementComparer;
        this.updateRequiredDecoration();
    }

    protected void updateRequiredDecoration() {
        super.updateRequiredDecoration();
        if (this.isRequired() && !this.isSet()) {
            if (this.fMissingRequiredBackground == null) {
                this.fMissingRequiredBackground = FieldAssistColors.getRequiredFieldBackgroundColor((Control)this.getDecoratedControl());
            }
            this.getDecoratedControl().setBackground(this.fMissingRequiredBackground);
        } else {
            this.getDecoratedControl().setBackground(null);
        }
    }

    protected boolean isSet() {
        return !this.equals(this.fValue, this.fNullValue);
    }

    protected int indexOf(Object[] values, Object value) {
        int i = 0;
        while (i < values.length) {
            if (this.equals(values[i], value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean equals(Object left, Object right) {
        if (this.fElementComparer != null) {
            return this.fElementComparer.equals(left, right);
        }
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }

    public Control getDecoratedControl() {
        return this.fList;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
        this.getFieldAssist().setLabelProvider(labelProvider);
    }

    public void setSorter(Comparator comparator) {
        this.fComparator = comparator;
    }

    protected Control createControl(Composite parent, int style) {
        Composite container = new Composite(parent, 0);
        TeamFormLayouts.setLayoutData((Control)container, (ITeamFormData)ITeamFormData.BORDERED_LIST);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.fList = new org.eclipse.swt.widgets.List(container, style);
        this.fList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DecoratedList.this.handleSelectionEvent(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData gridData = new GridData(4, 0x1000000, true, true);
        this.fList.setLayoutData((Object)gridData);
        return container;
    }

    public void setVisibleLines(int lines) {
        if (this.fList != null) {
            ((GridData)this.fList.getLayoutData()).heightHint = this.fList.getItemHeight() * lines;
        }
    }

    protected void handleSelectionEvent(SelectionEvent e) {
        int[] indexArr = this.fList.getSelectionIndices();
        if (indexArr.length > 0) {
            ILiteral lit = null;
            this.fValue = new ArrayList(indexArr.length);
            int i = 0;
            while (i < indexArr.length) {
                if (indexArr[i] < this.fValueSet.size() && this.fValueSet.get(indexArr[i]) instanceof ILiteral) {
                    lit = (ILiteral)this.fValueSet.get(indexArr[i]);
                    this.fValue.add(lit.getIdentifier2().getStringIdentifier());
                } else {
                    this.fValue.add(this.fList.getSelection()[i]);
                }
                ++i;
            }
        } else {
            this.fValue = new ArrayList();
        }
        int i = 0;
        while (i < this.fList.getItems().length) {
            if (!this.fList.isSelected(i)) {
                String item = this.fList.getItems()[i];
                int j = 0;
                while (j < this.fValueSetExtended.size()) {
                    String valueSet;
                    if (this.fValueSetExtended.get(j) instanceof ILiteral) {
                        ILiteral lit = (ILiteral)this.fValueSetExtended.get(j);
                        valueSet = lit.getIdentifier2().getStringIdentifier();
                    } else {
                        valueSet = (String)this.fValueSetExtended.get(j);
                    }
                    if (item.equals(valueSet)) {
                        this.fList.remove(i);
                        this.fValueSetExtended.remove(j);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.updateRequiredDecoration();
        this.fireSelectionChanged();
    }

    protected String[] getText(Object element) {
        String[] result = new String[]{};
        if (this.fLabelProvider == null) {
            if (element == null) {
                return result;
            }
            return DecoratedList.splitValues(element.toString());
        }
        String text = this.fLabelProvider.getText(element);
        if (text == null) {
            return new String[0];
        }
        return DecoratedList.splitValues(text);
    }

    public static String[] splitValues(String str) {
        StringTokenizer st = new StringTokenizer(str, ",");
        if (st.countTokens() == 0) {
            return new String[0];
        }
        String[] tokens = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            tokens[i] = st.nextToken();
            ++i;
        }
        return tokens;
    }

    protected Image getImage(Object element) {
        return this.fLabelProvider != null ? this.fLabelProvider.getImage(element) : null;
    }

    public ISelection getSelection() {
        if (this.fValue == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((List)this.fValue);
    }

    public void setSelection(ISelection selection) {
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Assert.isTrue((structuredSelection.size() <= 1 ? 1 : 0) != 0);
        Object element = ((IStructuredSelection)selection).getFirstElement();
        this.setValue(element);
    }

    protected boolean isFieldAssistEnabled() {
        return (this.getOptions() & 2) != 0;
    }

    protected void setClosestValue(String text, int cursorPosition) {
        if (!this.isFieldAssistEnabled()) {
            return;
        }
        Object[] value = this.getFieldAssist().getValue(text);
        this.setValue(value == null ? this.getValue() : value);
        int position = cursorPosition == -1 ? this.fList.getSelectionIndex() : cursorPosition;
        this.fList.setSelection(position);
    }

    protected LabelBasedProposalProvider getFieldAssist() {
        if (this.fFieldAssist == null) {
            this.fFieldAssist = new LabelBasedProposalProvider();
        }
        return this.fFieldAssist;
    }

    public static String joinValues(Object[] tokens) {
        int size = tokens.length == 0 ? 24 : tokens.length * 24;
        StringBuffer str = new StringBuffer(size);
        int i = 0;
        while (i < tokens.length) {
            str.append(tokens[i]);
            if (i < tokens.length - 1) {
                str.append(',');
            }
            ++i;
        }
        return str.toString();
    }

    public void setRetrieving(boolean retrieving) {
        if (retrieving && !this.fRetrieving) {
            this.fRetrieving = retrieving;
            this.setValueSet(new Object[]{RETRIEVEENTRY});
        }
        this.fRetrieving = retrieving;
    }

    public boolean isRetrieving() {
        return this.fRetrieving;
    }
}

