/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.ActiveControlTracker;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.HandlerUpdater;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.SelectAllHandler;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedText;
import com.ibm.team.workitem.ide.ui.internal.editor.TextClipboardAction;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.services.IServiceLocator;

public class DecoratedFormsText
extends DecoratedText {
    private static final int BORDER_MARGIN_WIDTH = 1;
    private static final int BORDER_MARGIN_HEIGHT = 2;
    private static final ITeamFormData SINGLE_LINE = ITeamFormData.SINGLE_LINE_TEXT.addOffset(1, 2);
    private static final ITeamFormData MULTI_LINE = ITeamFormData.MULTI_LINE_TEXT.addOffset(1, 2);
    private ITeamFormPartSite fSite;
    private Composite fBorder;
    private int fBackgroundStyle;
    private Label fImageLabel;
    private ILabelProvider fLabelProvider;
    private Object fValue;

    public DecoratedFormsText(Composite parent, ITeamFormPartSite site, int style, int options, int backgroundStyle) {
        super(options);
        this.fSite = site;
        this.fBackgroundStyle = backgroundStyle;
        this.createContent(parent, style);
    }

    protected Control createText(Composite parent, int style) {
        GridData data;
        GridLayout layout;
        ITeamFormData layoutData;
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.fSite.getToolkit();
        boolean isMultiLine = (style & 2) != 0;
        boolean isDecorated = (this.getOptions() & 4) == 0;
        boolean hasImage = (this.getOptions() & 1) != 0;
        Composite decoration = toolkit.createComposite(parent, 0, this.fBackgroundStyle);
        ITeamFormData iTeamFormData = layoutData = isMultiLine ? MULTI_LINE : SINGLE_LINE;
        if (isDecorated) {
            layoutData = layoutData.addOffset(7, 0);
        }
        if (hasImage) {
            layoutData = layoutData.addOffset(16, 0);
        }
        TeamFormLayouts.setLayoutData((Control)decoration, (ITeamFormData)layoutData);
        if (hasImage) {
            layout = new GridLayout(2, false);
            if (isDecorated) {
                layout.horizontalSpacing = 7;
            }
        } else {
            layout = new GridLayout();
            if (isDecorated) {
                layout.marginLeft = 7;
            }
        }
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        decoration.setLayout((Layout)layout);
        if (hasImage) {
            this.fImageLabel = toolkit.createLabel(decoration, null, 0, this.fBackgroundStyle);
            data = new GridData(131072, 0x1000000, false, false);
            data.widthHint = 16;
            data.heightHint = 16;
            this.fImageLabel.setLayoutData((Object)data);
        }
        this.fBorder = toolkit.createComposite(decoration, 0, this.fBackgroundStyle);
        this.fBorder.setLayoutData((Object)new GridData(4, isMultiLine ? 4 : 128, (style & 8) == 0, isMultiLine));
        layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 1;
        this.fBorder.setLayout((Layout)layout);
        if ((style & 8) == 0) {
            toolkit.paintBordersFor(this.fBorder);
        }
        this.fText = toolkit.createText(this.fBorder, "", style);
        data = new GridData(4, isMultiLine ? 4 : 128, true, isMultiLine);
        this.fText.setLayoutData((Object)data);
        this.fSite.registerSelectionProvider((ISelectionProvider)this, (Control)this.fText);
        IWorkbenchPart part = (IWorkbenchPart)this.fSite.getAdapter(IWorkbenchPart.class);
        if (part != null && part.getSite().getSelectionProvider() != null) {
            new SelectionUpdater(this, part.getSite().getSelectionProvider());
        }
        this.createClipboardHandlers();
        return decoration;
    }

    private void createClipboardHandlers() {
        IServiceLocator serviceLocator = (IServiceLocator)this.fSite.getAdapter(IServiceLocator.class);
        ActiveControlTracker activeControlTracker = (ActiveControlTracker)this.fSite.getAdapter(ActiveControlTracker.class);
        if (serviceLocator != null && activeControlTracker != null) {
            HandlerUpdater handlerUpdater = new HandlerUpdater(serviceLocator, activeControlTracker);
            TextClipboardAction.installCut(this.getText(), handlerUpdater);
            TextClipboardAction.installCopy(this.getText(), handlerUpdater);
            TextClipboardAction.installPaste(this.getText(), handlerUpdater);
            SelectAllHandler.install((Text)this.getText(), (HandlerUpdater)handlerUpdater);
            handlerUpdater.install((ISelectionProvider)this, (Control)this.getText(), true);
        }
    }

    public void setValue(Object value) {
        this.fValue = value;
        super.setValue(this.getText(value));
        if (this.fImageLabel != null) {
            this.fImageLabel.setImage(this.getImage(value));
        }
        this.fText.getParent().getParent().layout(new Control[]{this.fText});
    }

    public Object getValue() {
        return this.fValue;
    }

    private Image getImage(Object element) {
        return this.fLabelProvider != null ? this.fLabelProvider.getImage(element) : null;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
    }

    private String getText(Object element) {
        if (this.fLabelProvider == null) {
            if (element == null) {
                return "";
            }
            return element.toString();
        }
        String text = this.fLabelProvider.getText(element);
        if (text == null) {
            return "";
        }
        return text;
    }

    public void setHeightHint(int heightHint) {
        GridData data = (GridData)this.fText.getLayoutData();
        if (data == null) {
            return;
        }
        data.heightHint = heightHint;
    }

    protected Control getDecoratedControl() {
        return this.fBorder;
    }

    public Control getImageControl() {
        return this.fImageLabel;
    }

    private static class SelectionUpdater
    implements ISelectionChangedListener,
    DisposeListener {
        private DecoratedText fText;
        private ISelectionProvider fSelectionProvider;

        public SelectionUpdater(DecoratedText text, ISelectionProvider selectionProvider) {
            this.fText = text;
            this.fText.getText().addDisposeListener((DisposeListener)this);
            this.fSelectionProvider = selectionProvider;
            this.fSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ITextSelection selection = (ITextSelection)this.fText.getSelection();
            if (selection.getLength() > 0 && this.fText != event.getSource() && event.getSelection() instanceof ITextSelection && ((ITextSelection)event.getSelection()).getLength() > 0) {
                this.fText.setSelection((ISelection)new TextSelection(selection.getOffset(), 0));
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.fSelectionProvider = null;
        }
    }
}

