/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.ValueSetProvider;
import com.ibm.team.workitem.common.internal.ValueSetProviderRegistry;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages2;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class DecoratedComboUpdaterJob
extends UIUpdaterJob {
    public static final long DELAY = 500L;
    public static final String RETRIEVEENTRY = Messages2.DecoratedComboUpdaterJob_RETRIEVING;
    protected String fProperty;
    private DecoratedCombo fDecoratedCombo;
    protected Object fNullValue;
    protected Object[] fValueSet;
    private ValueSetProvider fValueSetProvider;

    public DecoratedComboUpdaterJob(String name, DecoratedCombo decoratedCombo, String property, String valueSetProviderId) {
        super(name);
        this.fDecoratedCombo = decoratedCombo;
        this.fProperty = property;
        this.fValueSetProvider = ValueSetProviderRegistry.getValueSetProvider((String)valueSetProviderId);
        if (this.fValueSetProvider == null) {
            this.fValueSetProvider = ValueSetProviderRegistry.getFallBackValueSetProvider();
        }
    }

    public IStatus runInBackground(IProgressMonitor monitor) {
        try {
            WorkItemWorkingCopy workingCopy = this.getWorkingCopy();
            if (workingCopy != null) {
                ITeamRepository teamRepository = workingCopy.getTeamRepository();
                IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                IWorkItem workItem = workingCopy.getWorkItem();
                IAttribute attribute = workItemClient.findAttribute(workItem.getProjectArea(), this.fProperty, monitor);
                this.fNullValue = this.fValueSetProvider.getNullValue(attribute, workItem, (IWorkItemCommon)workItemClient, monitor);
                this.fValueSet = this.fValueSetProvider.getValueSet(attribute, workItem, (IWorkItemCommon)workItemClient, monitor).toArray();
            } else {
                this.fNullValue = null;
                this.fValueSet = new Object[0];
            }
        }
        catch (TeamRepositoryException x) {
            return new Status(4, "com.ibm.team.workitem.rcp.ui", 4, Messages2.DecoratedComboUpdaterJob_EXCEPTION_UPDATING_VALUESET, (Throwable)x);
        }
        return super.runInBackground(monitor);
    }

    private void setRetrieving() {
        this.fDecoratedCombo.setValueSet(new Object[]{RETRIEVEENTRY});
    }

    public IStatus runInUI(IProgressMonitor monitor) {
        if (this.fDecoratedCombo.getCombo().isDisposed()) {
            return Status.CANCEL_STATUS;
        }
        this.fDecoratedCombo.setNullValue(this.fNullValue);
        this.fDecoratedCombo.setValueSet(this.fValueSet);
        return super.runInUI(monitor);
    }

    public void scheduleJob() {
        this.setRetrieving();
        this.schedule();
    }

    public void scheduleDefered() {
        this.setRetrieving();
        this.schedule(500L);
    }

    protected abstract WorkItemWorkingCopy getWorkingCopy();
}

