/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.ui.editor.TeamFormToolkit;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedList;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DecoratedCheckedList
extends DecoratedList
implements ISelectionProvider {
    public static final String TEMP_KEY = "_temp";
    public static final String TRUE_VAL = "true";
    private List<Widget> fCheckboxList = new ArrayList<Widget>();
    private Composite fComposite;

    public DecoratedCheckedList(TeamFormToolkit toolkit, Composite parent, int style) {
        this(toolkit, parent, style, 0, null);
    }

    public DecoratedCheckedList(TeamFormToolkit toolkit, Composite parent, int style, int options, ResourceManager mgr) {
        super(parent, style, options, mgr);
    }

    public void setValues(Object[] values) {
        this.fValue.clear();
        int i = 0;
        while (i < values.length) {
            this.fValue.add(values[i]);
            ++i;
        }
        ListIterator<Widget> listIterator = this.fCheckboxList.listIterator();
        while (listIterator.hasNext()) {
            String val;
            Widget widget = listIterator.next();
            if (!(widget instanceof Button)) continue;
            Button button = (Button)widget;
            Object data = button.getData("_value");
            if (data instanceof ILiteral) {
                ILiteral lit = (ILiteral)data;
                val = lit.getIdentifier2().getStringIdentifier();
            } else {
                val = (String)data;
            }
            boolean selected = false;
            int i2 = 0;
            while (i2 < values.length) {
                if (values[i2].equals(val)) {
                    selected = true;
                    break;
                }
                ++i2;
            }
            String tmpKey = (String)button.getData(TEMP_KEY);
            if (!selected && tmpKey != null && tmpKey.equals(TRUE_VAL)) {
                widget.dispose();
                listIterator.remove();
                this.fComposite.layout(true);
                this.fComposite.redraw();
                continue;
            }
            button.setSelection(selected);
        }
        this.updateRequiredDecoration();
    }

    public void setValueSet(Object[] valueSet) {
        Assert.isNotNull((Object)valueSet);
        if (valueSet.length == this.fValueSet.size()) {
            boolean same = false;
            int i = 0;
            while (i < valueSet.length) {
                same = valueSet[i].equals(this.fValueSet.get(i));
                if (!same) break;
                ++i;
            }
            if (same) {
                return;
            }
        }
        this.fValueSet.clear();
        int setsIdx = 0;
        while (setsIdx < valueSet.length) {
            this.fValueSet.add(valueSet[setsIdx]);
            ++setsIdx;
        }
        if (this.isRetrieving()) {
            this.disposeChecklists();
            Text txt = new Text(this.fComposite, 8);
            txt.setText((String)valueSet[0]);
            this.fCheckboxList.add((Widget)txt);
            return;
        }
        if (this.fComparator != null) {
            Object[] sortedValues = new Object[valueSet.length];
            System.arraycopy(valueSet, 0, sortedValues, 0, valueSet.length);
            Arrays.sort(sortedValues, this.fComparator);
            this.fValueSet.clear();
            int setsIdx2 = 0;
            while (setsIdx2 < sortedValues.length) {
                this.fValueSet.add(sortedValues[setsIdx2]);
                ++setsIdx2;
            }
        }
        this.disposeChecklists();
        int i = 0;
        while (i < this.fValueSet.size()) {
            String value;
            String name;
            ImageDescriptor imageDescriptor = null;
            Button button = this.createCheckbox();
            ILiteral lit = null;
            if (this.fValueSet.get(i) instanceof ILiteral) {
                lit = (ILiteral)this.fValueSet.get(i);
                name = lit.getName();
                value = lit.getIdentifier2().getStringIdentifier();
                imageDescriptor = WorkItemUI.getImageDescriptor(lit.getIconURL());
                if (imageDescriptor != null) {
                    button.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)imageDescriptor));
                }
            } else {
                value = name = (String)this.fValueSet.get(i);
            }
            for (Object val : this.fValue) {
                if (!val.equals(value)) continue;
                button.setSelection(true);
                break;
            }
            button.setData("_value", this.fValueSet.get(i));
            button.setText(name);
            this.fCheckboxList.add((Widget)button);
            ++i;
        }
        i = 0;
        while (i < this.fValue.size()) {
            boolean found = false;
            int j = 0;
            while (j < this.fValueSet.size()) {
                String value = null;
                ILiteral lit = null;
                if (this.fValueSet.get(j) instanceof ILiteral) {
                    lit = (ILiteral)this.fValueSet.get(j);
                    value = lit.getIdentifier2().getStringIdentifier();
                } else {
                    value = (String)this.fValueSet.get(j);
                }
                if (value.equals(this.fValue.get(i))) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                Button button = this.createCheckbox();
                button.setText((String)this.fValue.get(i));
                button.setSelection(true);
                button.setData(TEMP_KEY, (Object)TRUE_VAL);
                button.setData("_value", this.fValue.get(i));
                this.fCheckboxList.add((Widget)button);
            }
            ++i;
        }
        this.fComposite.layout(true);
        this.fComposite.redraw();
    }

    protected Button createCheckbox() {
        Button button = new Button(this.fComposite, 32);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof Button) {
                    Button button = (Button)e.widget;
                    Object data = button.getData("_value");
                    Object selection = data != null ? (data instanceof ILiteral ? ((ILiteral)data).getIdentifier2().getStringIdentifier() : data) : button.getData();
                    if (button.getSelection()) {
                        DecoratedCheckedList.this.addSelection(selection);
                    } else {
                        DecoratedCheckedList.this.removeSelection(selection);
                        if (button.getData(DecoratedCheckedList.TEMP_KEY) != null && button.getData(DecoratedCheckedList.TEMP_KEY).equals(DecoratedCheckedList.TRUE_VAL)) {
                            button.dispose();
                            DecoratedCheckedList.this.fCheckboxList.remove(button);
                            DecoratedCheckedList.this.fComposite.layout(true);
                            DecoratedCheckedList.this.fComposite.redraw();
                        }
                    }
                }
            }
        });
        return button;
    }

    protected void disposeChecklists() {
        int j = 0;
        while (j < this.fCheckboxList.size()) {
            Widget widget = this.fCheckboxList.get(j);
            widget.dispose();
            ++j;
        }
        this.fCheckboxList.clear();
    }

    protected void addSelection(Object selection) {
        this.fValue.add(selection);
        this.updateRequiredDecoration();
        this.fireSelectionChanged();
    }

    protected void removeSelection(Object selection) {
        this.fValue.remove(selection);
        this.updateRequiredDecoration();
        this.fireSelectionChanged();
    }

    public Control getDecoratedControl() {
        return this.fComposite;
    }

    protected Control createControl(Composite parent, int style) {
        this.fComposite = new Composite(parent, 0);
        TeamFormLayouts.setLayoutData((Control)this.fComposite, (ITeamFormData)ITeamFormData.CHECKBOX);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fComposite.setLayout((Layout)layout);
        return this.fComposite;
    }

    protected void handleSelectionEvent(SelectionEvent e) {
        this.updateRequiredDecoration();
        this.fireSelectionChanged();
    }

    protected void setClosestValue(String text, int cursorPosition) {
        if (!this.isFieldAssistEnabled()) {
            return;
        }
        Object[] value = this.getFieldAssist().getValue(text);
        this.setValue(value == null ? this.getValue() : value);
    }
}

