/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.internal.text.NonEmptyPositionUpdater;
import com.ibm.team.foundation.rcp.core.readstate.IReadStateManager;
import com.ibm.team.foundation.rcp.core.text.ReferencePosition;
import com.ibm.team.foundation.rcp.core.text.StylePosition;
import com.ibm.team.foundation.rcp.core.text.StyledDocument;
import com.ibm.team.foundation.rcp.core.text.TextConverter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.common.internal.model.Comment;
import com.ibm.team.workitem.common.model.CommentsChangeDetails;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages2;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentsDocument
extends StyledDocument {
    private static final String COMMENT_RANGES = "__comment_ranges";
    private static final String UNRESOLVED_AUTHOR = Messages2.CommentsDocument_UNRESOLVED_AUTHOR;
    private static final String NO_COMMENTS = Messages2.CommentsDocument_NO_COMMENTS;
    private static DateFormat fgDateFormatter = DateFormat.getDateInstance(2);
    private static DateFormat fgTimeFormatter = DateFormat.getTimeInstance(3);
    private static final int DATE_STYLE = 0;
    private static final int NEW_DATE_STYLE = 1;
    private static final int CREATOR_STYLE = 0;
    private static final int NEW_CREATOR_STYLE = 1;
    private WorkItemUIWorkingCopy fUIWorkingCopy;
    private Date fLastRead;
    private ListenerList fListeners = new ListenerList();
    private Set<UUID> fDisplayedComments;

    public CommentsDocument(WorkItemUIWorkingCopy uiWorkingCopy) {
        this.fUIWorkingCopy = uiWorkingCopy;
        this.addPositionCategory(COMMENT_RANGES);
        this.addPositionUpdater((IPositionUpdater)new NonEmptyPositionUpdater(COMMENT_RANGES));
        this.fLastRead = this.findLastRead(uiWorkingCopy.getWorkingCopy());
        this.initializeContent();
    }

    private Date findLastRead(WorkItemWorkingCopy workingCopy) {
        Date lastRead = IReadStateManager.DEFAULT.getStoredTime((IItemHandle)workingCopy.getWorkItem());
        IContributor user = workingCopy.getTeamRepository().loggedInContributor();
        if (user != null) {
            IComment[] comments;
            IComment[] iCommentArray = comments = workingCopy.getWorkItem().getComments().getContents();
            int n = comments.length;
            int n2 = 0;
            while (n2 < n) {
                IComment comment = iCommentArray[n2];
                if (user.sameItemId((IItemHandle)comment.getCreator()) && comment.getCreationDate() != null && (lastRead == null || comment.getCreationDate().after(lastRead))) {
                    lastRead = comment.getCreationDate();
                }
                ++n2;
            }
        }
        return lastRead;
    }

    private void initializeContent() {
        this.fDisplayedComments = new HashSet<UUID>();
        IComment[] comments = this.fUIWorkingCopy.getVisibleComments();
        if (comments.length > 0) {
            this.set("");
            int i = 0;
            while (i < comments.length) {
                this.createCommentEntry(comments[i], i);
                ++i;
            }
        } else {
            try {
                this.set(NO_COMMENTS);
                this.setStylePosition(new StylePosition(0, this.getLength(), this.getGrayscaleRGBArray(), null, 2));
            }
            catch (BadLocationException x) {
                WorkItemRCPUIPlugin.getDefault().log(Messages2.CommentsDocument_EXCEPTION_ADDING_POSITION, x);
            }
        }
    }

    private void createCommentEntry(final IComment comment, int index) {
        String name;
        IContributor creator;
        if (((Comment)comment).getInternalId() != null) {
            if (this.fDisplayedComments.contains(((Comment)comment).getInternalId())) {
                return;
            }
            this.fDisplayedComments.add(((Comment)comment).getInternalId());
        }
        int realIndex = -1;
        int i = 0;
        IComment[] iCommentArray = this.fUIWorkingCopy.getVisibleComments();
        int n = iCommentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComment c = iCommentArray[n2];
            if (c == comment) {
                realIndex = i;
            }
            ++i;
            ++n2;
        }
        if (this.get().equals(NO_COMMENTS)) {
            this.set("");
        }
        if ((creator = this.getCreator(comment)) != null) {
            name = creator.getName();
            name = String.valueOf(name) + (creator.isArchived() ? Messages2.CommentsDocument_ARCHIVED_DECORATION : "");
        } else {
            name = UNRESOLVED_AUTHOR;
        }
        StringBuffer buffer = new StringBuffer();
        Position[] projectionRanges = this.getProjectionRanges();
        if (index > 0 && index == projectionRanges.length) {
            try {
                int tmp = projectionRanges[index - 1].getOffset() + projectionRanges[index - 1].getLength();
                if (tmp > 0) {
                    this.replace(tmp - 1, 0, "\n");
                }
            }
            catch (BadLocationException x) {
                WorkItemRCPUIPlugin.getDefault().log(Messages2.CommentsDocument_ERROR_CREATING_COMMENT_ENTRY, x);
            }
        }
        final int offset = index > 0 ? projectionRanges[index - 1].getOffset() + projectionRanges[index - 1].getLength() : 0;
        buffer.append(String.valueOf(realIndex + 1) + ". ");
        int positionOffset = offset + buffer.length();
        buffer.append(name);
        boolean isUnread = this.isUnreadComment(comment);
        StylePosition creatorStyle = new StylePosition(positionOffset, offset + buffer.length() - positionOffset, this.getDarkGrayscaleRGBArray(), null, isUnread ? 1 : 0);
        ReferencePosition creatorReference = new ReferencePosition(positionOffset, offset + buffer.length() - positionOffset, URIService.createAuditableURI((ITeamRepository)this.fUIWorkingCopy.getWorkingCopy().getTeamRepository(), (IItemHandle)comment.getCreator()), false);
        buffer.append(", ");
        positionOffset = offset + buffer.length();
        Timestamp creationDate = comment.getCreationDate();
        if (creationDate != null) {
            buffer.append(fgDateFormatter.format(creationDate));
            buffer.append(", ");
            buffer.append(fgTimeFormatter.format(creationDate));
        } else {
            buffer.append("-");
        }
        StylePosition dateStyle = new StylePosition(positionOffset, offset + buffer.length() - positionOffset, this.getDarkGrayscaleRGBArray(), null, isUnread ? 1 : 0);
        buffer.append("\n");
        positionOffset = offset + buffer.length();
        TextConverter.FeaturedText featuredText = TextConverter.fromHTML2FeaturedText((XMLString)this.trim(comment.getHTMLContent()), (int)positionOffset);
        StylePosition emptyStyle = null;
        if (featuredText.getText().length() > 0) {
            buffer.append(featuredText.getText());
        } else {
            buffer.append(Messages2.CommentsDocument_INTENTIONALLY_LEFT_EMPTY);
            emptyStyle = new StylePosition(positionOffset, offset + buffer.length() - positionOffset, this.getGrayscaleRGBArray(), null, 2);
        }
        buffer.append("\n");
        if (index < projectionRanges.length) {
            buffer.append("\n");
        }
        ArrayList<StylePosition> stylePositions = new ArrayList<StylePosition>();
        stylePositions.add(dateStyle);
        stylePositions.add(creatorStyle);
        if (emptyStyle != null) {
            stylePositions.add(emptyStyle);
        }
        stylePositions.addAll(Arrays.asList(featuredText.getStylePositions()));
        ArrayList<ReferencePosition> referencePositions = new ArrayList<ReferencePosition>();
        referencePositions.add(creatorReference);
        referencePositions.addAll(Arrays.asList(featuredText.getReferencePositions()));
        final TextConverter.FeaturedText finalFeaturedText = new TextConverter.FeaturedText(buffer.toString(), stylePositions.toArray(new StylePosition[stylePositions.size()]), referencePositions.toArray(new ReferencePosition[referencePositions.size()]));
        IDocumentListener listener = null;
        try {
            listener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    try {
                        CommentsDocument.this.removePrenotifiedDocumentListener(this);
                        CommentsDocument.this.addProjectionRange(offset, finalFeaturedText.getText().length(), comment);
                    }
                    catch (BadLocationException x) {
                        throw new RuntimeException(x);
                    }
                }
            };
            this.addPrenotifiedDocumentListener(listener);
            try {
                this.replace(offset, 0, finalFeaturedText);
            }
            catch (BadLocationException x) {
                throw new RuntimeException(x);
            }
        }
        catch (Throwable throwable) {
            if (listener != null) {
                this.removePrenotifiedDocumentListener(listener);
            }
            throw throwable;
        }
        if (listener != null) {
            this.removePrenotifiedDocumentListener(listener);
        }
    }

    private int[] getDarkGrayscaleRGBArray() {
        return this.getRGBArray(17);
    }

    private int[] getGrayscaleRGBArray() {
        return this.getRGBArray(18);
    }

    private int[] getRGBArray(int constant) {
        RGB shadow = PlatformUI.getWorkbench().getDisplay().getSystemColor(constant).getRGB();
        return new int[]{shadow.red, shadow.green, shadow.blue};
    }

    private IContributor getCreator(IComment comment) {
        IContributor creator = this.fUIWorkingCopy.getResolvedWorkItem().getResolvedCommenter(comment.getCreator());
        if (creator != null) {
            return creator;
        }
        return (IContributor)this.getAuditableClient().findCachedAuditable((IAuditableHandle)comment.getCreator(), ItemProfile.CONTRIBUTOR_DEFAULT);
    }

    private XMLString trim(XMLString content) {
        StyledDocument document = new StyledDocument(content);
        try {
            int i = 0;
            while (i < document.getLength() && Character.isWhitespace(document.getChar(i))) {
                ++i;
            }
            document.replace(0, i, "");
            i = document.getLength();
            while (i > 0 && Character.isWhitespace(document.getChar(i - 1))) {
                --i;
            }
            document.replace(i, document.getLength() - i, "");
        }
        catch (BadLocationException x) {
            WorkItemRCPUIPlugin.getDefault().log(Messages2.CommentsDocument_UNEXPECTED_EXCEPTION, x);
        }
        return document.getHTML();
    }

    private void updateStyles(Timestamp timestamp) {
        Position[] projectionRanges;
        this.fLastRead = timestamp != null ? timestamp : new Date(Long.MAX_VALUE);
        Position[] positionArray = projectionRanges = this.getProjectionRanges();
        int n = projectionRanges.length;
        int n2 = 0;
        while (n2 < n) {
            Position pos = positionArray[n2];
            try {
                int offset = pos.getOffset();
                int length = this.getLineInformation(this.getLineOfOffset(offset)).getLength();
                String text = this.get(offset, length);
                StylePosition[] oldStyles = this.getStylePositions(offset, length);
                StylePosition[] newStyles = new StylePosition[oldStyles.length];
                int i = 0;
                boolean changed = false;
                StylePosition[] stylePositionArray = oldStyles;
                int n3 = oldStyles.length;
                int n4 = 0;
                while (n4 < n3) {
                    StylePosition oldStyle = stylePositionArray[n4];
                    int style = oldStyle.getStyle();
                    if (oldStyle.isBold()) {
                        changed = true;
                        style = oldStyle.getStyle() ^ 1;
                    }
                    newStyles[i] = new StylePosition(oldStyle.getOffset(), oldStyle.getLength(), oldStyle.getForeground(), oldStyle.getBackground(), style);
                    ++i;
                    ++n4;
                }
                if (changed) {
                    ReferencePosition[] references = this.getReferencePositions(offset, length, false);
                    ReferencePosition[] newRefs = new ReferencePosition[references.length];
                    int j = 0;
                    ReferencePosition[] referencePositionArray = references;
                    int n5 = references.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ReferencePosition rp = referencePositionArray[n6];
                        newRefs[j] = new ReferencePosition(rp.getOffset(), rp.getLength(), rp.getReference(), rp.isTemporary());
                        ++j;
                        ++n6;
                    }
                    this.replace(offset, length, new TextConverter.FeaturedText(text, newStyles, newRefs));
                }
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
    }

    public void handleCommentsChanged(CommentsChangeDetails changeDetails, final int kind) {
        CommentsChangeDetails details;
        if (changeDetails != null && changeDetails.getComment() == this.fUIWorkingCopy.getIgnoredComment()) {
            return;
        }
        if (changeDetails != null) {
            int index = changeDetails.getIndex();
            if (this.fUIWorkingCopy.getIgnoredComment() != null && Arrays.asList(this.fUIWorkingCopy.getWorkingCopy().getWorkItem().getComments().getContents()).indexOf(this.fUIWorkingCopy.getIgnoredComment()) < index) {
                --index;
            }
            details = new CommentsChangeDetails(changeDetails.getComment(), changeDetails.getCreator(), index, changeDetails.isAddition());
        } else {
            details = null;
        }
        WorkItemRCPUIPlugin.runInUI(Messages2.CommentsDocument_UPDATING_COMMENTS, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                CommentsDocument.this.internalHandleCommentChanged(details, kind);
            }
        }, null);
    }

    private void internalHandleCommentChanged(CommentsChangeDetails changeDetails, int kind) {
        if (changeDetails != null && changeDetails.isAddition()) {
            try {
                this.createCommentEntry(changeDetails.getComment(), changeDetails.getIndex());
                if (kind == 1) {
                    this.updateStyles(changeDetails.getComment().getCreationDate());
                }
                this.fireCommentsChange(changeDetails, kind);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.initializeContent();
                this.fireCommentsChange(null, kind);
            }
        } else {
            this.initializeContent();
            this.fireCommentsChange(null, kind);
        }
    }

    private void addProjectionRange(int offset, int length, IComment comment) throws BadLocationException {
        try {
            CommentPosition position = new CommentPosition(offset, length, comment);
            this.addPosition(COMMENT_RANGES, position);
        }
        catch (BadPositionCategoryException x) {
            throw new RuntimeException(x);
        }
    }

    public Position[] getProjectionRanges() {
        try {
            return this.getPositions(COMMENT_RANGES);
        }
        catch (BadPositionCategoryException x) {
            throw new RuntimeException(x);
        }
    }

    public Position getProjectionRange(IComment comment) {
        int index = Arrays.asList(this.fUIWorkingCopy.getVisibleComments()).indexOf(comment);
        if (index == -1) {
            return null;
        }
        return this.getProjectionRanges()[index];
    }

    public List<IComment> getComments(int offset, int length) {
        Position[] ranges;
        ArrayList<IComment> comments = new ArrayList<IComment>();
        Position[] positionArray = ranges = this.getProjectionRanges();
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            Position range = positionArray[n2];
            if (range.overlapsWith(offset, length)) {
                comments.add(((CommentPosition)range).getComment());
            }
            ++n2;
        }
        return comments;
    }

    public void addCommentListener(IWorkItemListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeCommentListener(IWorkItemListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public boolean isUnreadComment(IComment comment) {
        IContributor user = this.fUIWorkingCopy.getWorkingCopy().getTeamRepository().loggedInContributor();
        if (user != null && user.sameItemId((IItemHandle)comment.getCreator())) {
            return false;
        }
        return comment.getCreationDate() == null || this.fLastRead == null || comment.getCreationDate().after(this.fLastRead);
    }

    public void emptyComment(IComment comment) {
        ((Comment)comment).setContent("");
        if (!this.fUIWorkingCopy.getWorkingCopy().isDirty()) {
            ((WorkItemWorkingCopyImpl)this.fUIWorkingCopy.getWorkingCopy()).setDirty(true);
        }
        this.initializeContent();
        this.fireCommentsChange(null, 1);
    }

    private void fireCommentsChange(CommentsChangeDetails changeDetails, int kind) {
        final WorkItemChangeEvent event = new WorkItemChangeEvent(this.fUIWorkingCopy.getWorkingCopy().getWorkItem());
        event.addAttributeDetails(IWorkItem.COMMENTS_PROPERTY, new String[0], (IAdaptable)changeDetails, kind);
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IWorkItemListener listener = (IWorkItemListener)listeners[i];
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    listener.workItemAttributeChanged(event);
                }

                public void handleException(Throwable exception) {
                    CommentsDocument.this.fListeners.remove((Object)listener);
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
            ++i;
        }
    }

    private IAuditableClient getAuditableClient() {
        return (IAuditableClient)this.fUIWorkingCopy.getWorkingCopy().getTeamRepository().getClientLibrary(IAuditableClient.class);
    }

    private static class CommentPosition
    extends Position {
        private IComment fComment;

        public CommentPosition(int offset, int length, IComment comment) {
            super(offset, length);
            this.fComment = comment;
        }

        public CommentPosition(int offset, IComment comment) {
            super(offset);
            this.fComment = comment;
        }

        public IComment getComment() {
            return this.fComment;
        }
    }
}

