/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.wizards;

import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.ExtractWorkItemOperation;
import com.ibm.team.workitem.ide.ui.internal.wizards.Messages;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import com.ibm.team.workitem.rcp.ui.internal.wizards.INewWorkItemWizardContext;
import com.ibm.team.workitem.rcp.ui.internal.wizards.LinkTypePage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.SelectProjectAreaWizardPage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.SelectWorkItemTypeWizardPage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractWorkItemWizard
extends Wizard
implements INewWorkItemWizardContext {
    private static final String DIALOG_SETTINGS_KEY = "extractWorkItem";
    private static final String LINK_TYPE_KEY = "linkType";
    private static final String END_POINT_KEY = "endPoint";
    private static final String WORK_ITEM_TYPE_KEY = "workItemType";
    private IDialogSettings fDialogSettings;
    private IProjectAreaHandle fProjectArea;
    private IWorkItemType fType;
    private String fTypeId;
    private ExtractWorkItemOperation fOperation;
    private LinkTypePage fLinkTypePage;

    public ExtractWorkItemWizard(IProjectAreaHandle projectArea, ExtractWorkItemOperation operation) {
        this.fProjectArea = projectArea;
        this.fOperation = operation;
        this.setWindowTitle(Messages.ExtractWorkItemWizard_EXTRACT_WORKITEM_WINDOW_TITLE);
        this.setNeedsProgressMonitor(true);
    }

    public IProjectAreaHandle getProjectArea() {
        return this.fProjectArea;
    }

    public void setProjectArea(IProjectAreaHandle projectArea) {
        this.fProjectArea = projectArea;
    }

    public List<IProjectAreaHandle> getAvailableProjectAreas() {
        ArrayList<IProjectAreaHandle> areas = new ArrayList<IProjectAreaHandle>(ProjectAreaPicker.getAllConnectedProjectAreas((boolean)true));
        Iterator iter = areas.iterator();
        while (iter.hasNext()) {
            if (((IProjectAreaHandle)iter.next()).getOrigin() == this.fProjectArea.getOrigin()) continue;
            iter.remove();
        }
        return areas;
    }

    public IWorkItemType getType() {
        return this.fType;
    }

    public String getTypeId() {
        return this.fTypeId;
    }

    public void setType(IWorkItemType type) {
        this.fType = type;
        if (type != null) {
            this.fTypeId = type.getIdentifier();
        }
    }

    public IWizardPage getStartingPage() {
        return this.fLinkTypePage;
    }

    public void addPages() {
        this.addPage((IWizardPage)new SelectProjectAreaWizardPage((INewWorkItemWizardContext)this));
        this.fLinkTypePage = new LinkTypePage(false, new IEndPointDescriptor[]{WorkItemEndPoints.DUPLICATE_OF_WORK_ITEM, WorkItemEndPoints.DUPLICATE_WORK_ITEM});
        this.addPage((IWizardPage)this.fLinkTypePage);
        this.addPage((IWizardPage)new SelectWorkItemTypeWizardPage((INewWorkItemWizardContext)this));
        this.loadSettings();
    }

    public boolean performFinish() {
        ILinkType linkType;
        IEndPointDescriptor endPoint = this.fLinkTypePage.getEndPoint();
        IEndPointDescriptor opposite = endPoint == (linkType = endPoint.getLinkType()).getTargetEndPointDescriptor() ? linkType.getSourceEndPointDescriptor() : linkType.getTargetEndPointDescriptor();
        this.fOperation.setEndPoint(opposite);
        this.fOperation.runInJob(this.fType);
        this.storeSettings();
        return true;
    }

    private void loadSettings() {
        this.fDialogSettings = WorkItemIDEUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (this.fDialogSettings != null) {
            String linkTypeId;
            if (this.fDialogSettings.get(LINK_TYPE_KEY) != null && ILinkTypeRegistry.INSTANCE.isRegistered(linkTypeId = this.fDialogSettings.get(LINK_TYPE_KEY))) {
                ILinkType linkType = ILinkTypeRegistry.INSTANCE.getLinkType(linkTypeId);
                boolean isTarget = this.fDialogSettings.get(END_POINT_KEY) != null ? this.fDialogSettings.getBoolean(END_POINT_KEY) : true;
                this.fLinkTypePage.setEndPoint(isTarget ? linkType.getTargetEndPointDescriptor() : linkType.getSourceEndPointDescriptor());
            }
            this.fTypeId = this.fDialogSettings.get(WORK_ITEM_TYPE_KEY);
        }
    }

    private void storeSettings() {
        IEndPointDescriptor endPoint;
        if (this.fDialogSettings == null) {
            this.fDialogSettings = WorkItemIDEUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        this.fDialogSettings.put(LINK_TYPE_KEY, (endPoint = this.fLinkTypePage.getEndPoint()) != null ? endPoint.getLinkType().getLinkTypeId() : null);
        this.fDialogSettings.put(END_POINT_KEY, (endPoint != null ? Boolean.valueOf(endPoint == endPoint.getLinkType().getTargetEndPointDescriptor()) : null).booleanValue());
        this.fDialogSettings.put(WORK_ITEM_TYPE_KEY, this.fTypeId);
    }
}

