/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem;

import com.ibm.icu.text.Collator;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IInputProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IValueConverter;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;

public class WorkflowProviders {
    public static ITreeContentProvider createContentProvider() {
        return new WorkflowContentProvider();
    }

    public static ILabelProvider createLabelProvider() {
        return new WorkflowLabelProvider();
    }

    public static IInputProvider createStateInputProvider() {
        return new WorkflowInputProvider(IState.class);
    }

    public static IInputProvider createResolutionInputProvider() {
        return new WorkflowInputProvider(IResolution.class);
    }

    public static IValueConverter createResolutionConverter() {
        return new WorkflowConverter<IResolution>(IResolution.class);
    }

    public static IValueConverter createStateConverter() {
        return new WorkflowConverter<IState>(IState.class);
    }

    public static IElementComparer createElementComparer() {
        return new WorkflowElementComparer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UIResolution
    extends UIWorkflowItem<IResolution> {
        public UIResolution(UIWorkflowInfo parent, Identifier<IResolution> identifier) {
            super(parent, identifier);
        }

        @Override
        protected URL getIconURL(IWorkflowInfo workflowInfo) {
            return workflowInfo.getResolutionIconName(this.getIdentifier());
        }

        @Override
        protected String getName(IWorkflowInfo workflowInfo) {
            return workflowInfo.getResolutionName(this.getIdentifier());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UIState
    extends UIWorkflowItem<IState> {
        public UIState(UIWorkflowInfo parent, Identifier<IState> identifier) {
            super(parent, identifier);
        }

        @Override
        protected URL getIconURL(IWorkflowInfo workflowInfo) {
            return workflowInfo.getStateIconName(this.getIdentifier());
        }

        @Override
        protected String getName(IWorkflowInfo workflowInfo) {
            return workflowInfo.getStateName(this.getIdentifier());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UIWorkflowInfo {
        private final Class<?> fClazz;
        private final IWorkflowInfo fWorkflowInfo;
        private List<UIWorkflowItem<?>> fChildren;

        public UIWorkflowInfo(IWorkflowInfo workflow, Class<?> clazz) {
            Assert.isNotNull((Object)workflow);
            Assert.isNotNull(clazz);
            this.fWorkflowInfo = workflow;
            this.fClazz = clazz;
        }

        public IWorkflowInfo getWorkflowInfo() {
            return this.fWorkflowInfo;
        }

        public String getName() {
            return this.fWorkflowInfo.getName();
        }

        public List<UIWorkflowItem<?>> getChildren() {
            if (this.fChildren == null) {
                ArrayList children = new ArrayList();
                this.collectChildren(children);
                this.fChildren = children;
            }
            return this.fChildren;
        }

        private void collectChildren(List<UIWorkflowItem<?>> children) {
            block3: {
                Identifier[] resolutions;
                block2: {
                    Identifier[] states;
                    if (!IState.class.equals(this.fClazz)) break block2;
                    Identifier[] identifierArray = states = this.fWorkflowInfo.getAllStateIds();
                    int n = states.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Identifier identifier = identifierArray[n2];
                        children.add(new UIState(this, (Identifier<IState>)identifier));
                        ++n2;
                    }
                    break block3;
                }
                if (!IResolution.class.equals(this.fClazz)) break block3;
                Identifier[] identifierArray = resolutions = this.fWorkflowInfo.getAllResolutionIds();
                int n = resolutions.length;
                int n3 = 0;
                while (n3 < n) {
                    Identifier identifier = identifierArray[n3];
                    children.add(new UIResolution(this, (Identifier<IResolution>)identifier));
                    ++n3;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class UIWorkflowItem<T> {
        private final UIWorkflowInfo fParent;
        private final Identifier<T> fIdentifier;

        public UIWorkflowItem(UIWorkflowInfo parent, Identifier<T> identifier) {
            this.fParent = parent;
            this.fIdentifier = identifier;
        }

        public UIWorkflowInfo getParent() {
            return this.fParent;
        }

        public String getName() {
            IWorkflowInfo workflowInfo = this.fParent.getWorkflowInfo();
            String name = this.getName(workflowInfo);
            if (name == null) {
                return this.fIdentifier.getStringIdentifier();
            }
            return name;
        }

        public URL getIconURL() {
            IWorkflowInfo workflowInfo = this.fParent.getWorkflowInfo();
            return this.getIconURL(workflowInfo);
        }

        public Identifier<T> getIdentifier() {
            return this.fIdentifier;
        }

        protected abstract String getName(IWorkflowInfo var1);

        protected abstract URL getIconURL(IWorkflowInfo var1);
    }

    private static class WorkflowContentProvider
    implements ITreeContentProvider {
        private WorkflowContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof UIWorkflowInfo) {
                UIWorkflowInfo workflowInfo = (UIWorkflowInfo)parentElement;
                return workflowInfo.getChildren().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof UIWorkflowItem) {
                UIWorkflowItem workflowItem = (UIWorkflowItem)element;
                return workflowItem.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof UIWorkflowInfo) {
                UIWorkflowInfo workflowInfo = (UIWorkflowInfo)element;
                return workflowInfo.getChildren().size() > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            List workflowInfos = (List)inputElement;
            return workflowInfos.toArray();
        }

        public void dispose() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkflowConverter<T>
    implements IValueConverter {
        private Class<T> fClass;

        public WorkflowConverter(Class<T> clazz) {
            this.fClass = clazz;
        }

        @Override
        public Object convertFrom(Object object) {
            if (object instanceof UIWorkflowInfo) {
                return null;
            }
            if (object instanceof UIWorkflowItem) {
                return ((UIWorkflowItem)object).getIdentifier().getStringIdentifier();
            }
            return object;
        }

        @Override
        public Object convertTo(Object object) {
            if (object instanceof String) {
                return Identifier.create(this.fClass, (String)object.toString());
            }
            return object;
        }
    }

    private static class WorkflowElementComparer
    implements IElementComparer {
        private WorkflowElementComparer() {
        }

        public boolean equals(Object a, Object b) {
            if (a instanceof UIWorkflowItem) {
                a = ((UIWorkflowItem)a).getIdentifier();
            }
            if (b instanceof UIWorkflowItem) {
                b = ((UIWorkflowItem)b).getIdentifier();
            }
            return a.equals(b);
        }

        public int hashCode(Object element) {
            if (element instanceof UIWorkflowItem) {
                element = ((UIWorkflowItem)element).getIdentifier();
            }
            return element.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkflowInputProvider
    implements IInputProvider {
        private final Class<?> fClazz;

        public WorkflowInputProvider(Class<?> clazz) {
            Assert.isNotNull(clazz);
            this.fClazz = clazz;
        }

        @Override
        public Object createInput(IProjectAreaHandle projectArea, Collection<Object> values, IProgressMonitor monitor) throws TeamRepositoryException {
            IWorkItemClient workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IWorkItemClient.class);
            HashSet<String> typeCategories = new HashSet<String>();
            List workItemTypes = workItemClient.findWorkItemTypes(projectArea, monitor);
            for (IWorkItemType workItemType : workItemTypes) {
                typeCategories.add(workItemType.getCategory());
            }
            ArrayList<UIWorkflowInfo> workflowInfos = new ArrayList<UIWorkflowInfo>();
            WorkflowManager workflowManager = (WorkflowManager)workItemClient.getWorkflowManager();
            HashSet<String> workflowIds = new HashSet<String>();
            for (String typeCategory : typeCategories) {
                String newWorkflowId = workflowManager.getWorkflowIdForCategory(projectArea, typeCategory, false, monitor);
                workflowIds.add(newWorkflowId);
            }
            for (String workflowId : workflowIds) {
                UIWorkflowInfo info;
                IWorkflowInfo workflow;
                if (workflowId == null || (workflow = workflowManager.getWorkflowInfo(projectArea, workflowId, true, monitor)) == null || (info = new UIWorkflowInfo(workflow, this.fClazz)).getChildren().isEmpty()) continue;
                workflowInfos.add(info);
            }
            this.sort(workflowInfos);
            return workflowInfos;
        }

        private void sort(List<UIWorkflowInfo> workflowInfos) {
            final Collator collator = Collator.getInstance();
            Collections.sort(workflowInfos, new Comparator<UIWorkflowInfo>(){

                @Override
                public int compare(UIWorkflowInfo o1, UIWorkflowInfo o2) {
                    return collator.compare(o1.getName(), o2.getName());
                }
            });
        }
    }

    private static class WorkflowLabelProvider
    extends TypeLabelProvider {
        private WorkflowLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof UIWorkflowInfo) {
                UIWorkflowInfo workflowInfo = (UIWorkflowInfo)element;
                label.setText(workflowInfo.getName());
                label.setImage(this.getImage(ImagePool.WORKFLOW_ICON));
                return;
            }
            if (element instanceof UIWorkflowItem) {
                ImageDescriptor descriptor;
                UIWorkflowItem workflowItem = (UIWorkflowItem)element;
                label.setText(workflowItem.getName());
                URL url = workflowItem.getIconURL();
                if (url != null && (descriptor = WorkItemUI.getImageDescriptor((URL)url)) != null) {
                    label.setImage(this.getImage(descriptor));
                }
            }
        }
    }
}

