/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.internal.util.CollectionUtils;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IInputProvider;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.WorkItemEditorHistoryEntry;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkItemProviders {
    private static final int MAX_ENTRIES = 20;
    private static final Comparator<WorkItemEditorHistoryEntry> HISTORY_COMPARATOR = new Comparator<WorkItemEditorHistoryEntry>(){

        @Override
        public int compare(WorkItemEditorHistoryEntry o1, WorkItemEditorHistoryEntry o2) {
            return o1.getDate().compareTo(o2.getDate());
        }
    };

    public static IInputProvider createInputProvider() {
        return new WorkItemHistoryInputProvider();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkItemHistoryInputProvider
    implements IInputProvider {
        private WorkItemHistoryInputProvider() {
        }

        @Override
        public Object createInput(IProjectAreaHandle projectArea, Collection<Object> values, IProgressMonitor monitor) throws TeamRepositoryException {
            IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IAuditableClient.class);
            ItemHandleAwareHashSet handles = new ItemHandleAwareHashSet();
            for (Object value : values) {
                if (!(value instanceof IWorkItemHandle)) continue;
                handles.add((Object)((IWorkItemHandle)value));
            }
            WorkItemEditorHistoryEntry[] history = ClientModel.getHistoryManager().getHistoryEntries();
            Arrays.sort(history, HISTORY_COMPARATOR);
            int i = 0;
            while (i < Math.min(history.length, 20)) {
                if (history[i].getWorkItem() != null) {
                    handles.add((Object)history[i].getWorkItem());
                }
                ++i;
            }
            return CollectionUtils.removeNulls((List)auditableClient.resolveAuditables(handles.toList(), IWorkItem.SMALL_PROFILE, monitor));
        }
    }
}

