/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem;

import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.client.workingcopies.IIterationStructureWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProjectAreaWorkingCopy;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IInputProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IValueConverter;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class IterationProviders {
    public static IInputProvider createInputProvider() {
        return new IterationInputProvider();
    }

    public static ITreeContentProvider createContentProvider() {
        return new IterationContentProvider();
    }

    public static IValueConverter createConverter() {
        return new IterationConverter();
    }

    private static class IterationContentProvider
    implements ITreeContentProvider {
        private IterationInput fInput;
        private IIterationStructureWorkingCopy fIterationStructureWorkingCopy;

        private IterationContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                this.fInput = null;
                this.fIterationStructureWorkingCopy = null;
            } else if (newInput instanceof IterationInput) {
                this.fInput = (IterationInput)newInput;
                this.fIterationStructureWorkingCopy = this.fInput.getIterationStructure();
            }
        }

        public Object[] getChildren(Object parentElement) {
            IIteration iteration;
            if (parentElement instanceof IDevelopmentLine) {
                return this.fIterationStructureWorkingCopy.getIterations((IDevelopmentLineHandle)((IDevelopmentLine)parentElement));
            }
            if (parentElement instanceof IIteration && this.fInput.hasDeliverableChildren((IIterationHandle)(iteration = (IIteration)parentElement))) {
                return this.fIterationStructureWorkingCopy.getChildIterations((IIterationHandle)iteration);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IIterationHandle) {
                IIterationHandle iteration = (IIterationHandle)element;
                IIteration parent = this.fIterationStructureWorkingCopy.getParentIteration(iteration);
                if (parent != null) {
                    return parent;
                }
                return this.fIterationStructureWorkingCopy.getDevelopmentLine(iteration);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children != null && children.length > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IterationInput) {
                Assert.isTrue((((IterationInput)inputElement).getIterationStructure() == this.fIterationStructureWorkingCopy ? 1 : 0) != 0);
                return this.fIterationStructureWorkingCopy.getDevelopmentLines();
            }
            return new Object[0];
        }

        public void dispose() {
            this.fIterationStructureWorkingCopy = null;
        }
    }

    private static class IterationConverter
    implements IValueConverter {
        private IterationConverter() {
        }

        public Object convertFrom(Object object) {
            if (object instanceof IDevelopmentLineHandle) {
                return null;
            }
            return object;
        }

        public Object convertTo(Object object) {
            return object;
        }
    }

    public static class IterationInput {
        private final IIterationStructureWorkingCopy fIterationStructure;
        private final Set<IIterationHandle> fDeliverableSet = new ItemHandleAwareHashSet();

        private IterationInput(IIterationStructureWorkingCopy structure) {
            this.fIterationStructure = structure;
            this.buildDeliverableSet();
        }

        public IIterationStructureWorkingCopy getIterationStructure() {
            return this.fIterationStructure;
        }

        public boolean hasDeliverableChildren(IIterationHandle handle) {
            return this.fDeliverableSet.contains(handle);
        }

        private void buildDeliverableSet() {
            IDevelopmentLine[] iDevelopmentLineArray = this.fIterationStructure.getDevelopmentLines();
            int n = iDevelopmentLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDevelopmentLine developmentLine = iDevelopmentLineArray[n2];
                IIteration[] iIterationArray = this.fIterationStructure.getIterations((IDevelopmentLineHandle)developmentLine);
                int n3 = iIterationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IIteration iteration = iIterationArray[n4];
                    this.checkIteration(iteration);
                    ++n4;
                }
                ++n2;
            }
        }

        private boolean checkIteration(IIteration iteration) {
            boolean hasDeliverableChildren = false;
            IIteration[] iIterationArray = this.fIterationStructure.getChildIterations((IIterationHandle)iteration);
            int n = iIterationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IIteration childIteration = iIterationArray[n2];
                hasDeliverableChildren |= this.checkIteration(childIteration);
                ++n2;
            }
            if (hasDeliverableChildren) {
                this.fDeliverableSet.add((IIterationHandle)iteration);
            }
            return hasDeliverableChildren || iteration.hasDeliverable();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IterationInputProvider
    implements IInputProvider {
        private IterationInputProvider() {
        }

        @Override
        public Object createInput(IProjectAreaHandle projectAreaHandle, Collection<Object> values, IProgressMonitor monitor) throws TeamRepositoryException {
            IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectAreaHandle, IAuditableClient.class);
            IProjectArea projectArea = (IProjectArea)auditableClient.resolveAuditable((IAuditableHandle)projectAreaHandle, ItemProfile.createFullProfile((IItemType)IProjectArea.ITEM_TYPE), monitor);
            IProcessItemService processItemService = (IProcessItemService)ClientUtils.getClientLibrary((IItemHandle)projectAreaHandle, IProcessItemService.class);
            IProjectAreaWorkingCopy workingCopy = (IProjectAreaWorkingCopy)processItemService.getWorkingCopyManager().createPrivateWorkingCopy((IProcessItem)projectArea);
            return new IterationInput(workingCopy.getIterationStructure());
        }
    }
}

