/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.util.CollectionUtils;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.NullAwareArrayContentProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.TableViewerControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.ContributorInputProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.Messages;
import com.ibm.team.workitem.rcp.core.internal.FavoriteValues;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeComparatorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributorListControl
extends TableViewerControl {
    private Action fAddContributorAction = new Action(){

        public void run() {
            ContributorListControl.this.addContributors();
        }
    };
    private ArrayList<Object> fContributors;
    private ContributorUpdater fUpdater = new ContributorUpdater();

    public ContributorListControl(IQueryableAttribute attribute) {
        this.setComparator(AttributeComparatorFactory.createComparator((IQueryableAttribute)attribute));
        this.setLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        this.setPopupLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        this.setInputProvider(new ContributorInputProvider(attribute));
        this.setContentProvider((IContentProvider)new NullAwareArrayContentProvider());
        this.setPopupContentProvider((IContentProvider)new NullAwareArrayContentProvider());
        this.setWidthHintInChars(30);
        this.fAddContributorAction.setImageDescriptor(ImagePool.ADD_USER);
        this.fAddContributorAction.setText(Messages.ContributorListControl_ADD_USERS);
        this.fAddContributorAction.setToolTipText(Messages.ContributorListControl_SELECT_MORE_USERS);
    }

    @Override
    protected void initializeToolBar() {
        super.initializeToolBar();
        IToolBarManager toolBarManager = this.getSite().getToolBarManager();
        toolBarManager.add((IAction)this.fAddContributorAction);
        toolBarManager.update(false);
    }

    @Override
    protected void inputChanged(Object input) {
        if (input instanceof Object[]) {
            this.fContributors = new ArrayList<Object>(Arrays.asList((Object[])input));
        }
        if (input instanceof List) {
            this.fContributors = new ArrayList((List)input);
        }
        this.getViewer().setInput(this.fContributors);
    }

    @Override
    protected Object getResolvedInput() {
        return this.fContributors;
    }

    private void addContributors() {
        IContributorHandle[] contributors;
        if (this.getInput() == null) {
            return;
        }
        ITeamRepository repository = (ITeamRepository)this.getInput().getProjectArea().getOrigin();
        TeamContributorSelectionDialog dialog = new TeamContributorSelectionDialog(this.getShell(), repository, Arrays.asList(this.getSelectedElements()), true);
        dialog.setTitle(Messages.ContributorListControl_ADD_USERS);
        dialog.setMessage(Messages.ContributorListControl_CHOOSE_USERS_MESSAGE);
        if (dialog.open() == 0 && (contributors = dialog.getContributorResult()).length > 0) {
            List<IContributorHandle> selection = Arrays.asList(contributors);
            FavoriteValues.getInstance().addItems("com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem", selection);
            List<IContributorHandle> missing = this.getMissingContributors(selection);
            if (!missing.isEmpty()) {
                this.fUpdater.setMissing(missing);
                this.fUpdater.setSelection(selection);
                this.fUpdater.schedule();
            } else {
                this.updateSelection(selection);
            }
        }
    }

    private void updateSelection(List<IContributorHandle> selection) {
        ArrayList<Object> newSelection = new ArrayList<Object>();
        newSelection.addAll(selection);
        newSelection.addAll(Arrays.asList(this.getSelectedElements()));
        this.getSelectionProvider().setSelection((ISelection)new StructuredSelection(newSelection));
    }

    private List<IContributorHandle> getMissingContributors(List<IContributorHandle> selection) {
        ArrayList<IContributorHandle> missing = new ArrayList<IContributorHandle>();
        if (this.fContributors != null) {
            ItemHandleAwareHashSet existing = new ItemHandleAwareHashSet(this.fContributors);
            for (IContributorHandle candidate : selection) {
                if (existing.contains((Object)candidate)) continue;
                missing.add(candidate);
            }
        }
        return missing;
    }

    private Shell getShell() {
        return this.getCheckBoxTableViewer().getTable().getShell();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContributorUpdater
    extends UIUpdaterJob {
        private List<IContributorHandle> fMissing;
        private List<IContributor> fResolvedMissing;
        private List<IContributorHandle> fSelection;

        public ContributorUpdater() {
            super(Messages.ContributorListControl_UPDATING_USERS_JOB_MESSAGE);
        }

        public void setMissing(List<IContributorHandle> missing) {
            this.fMissing = missing;
        }

        public void setSelection(List<IContributorHandle> selection) {
            this.fSelection = selection;
        }

        public IStatus runInBackground(IProgressMonitor monitor) {
            if (!this.fMissing.isEmpty()) {
                IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)((IItemHandle)this.fMissing.get(0)), IAuditableClient.class);
                try {
                    this.fResolvedMissing = CollectionUtils.removeNulls((List)auditableClient.resolveAuditables(this.fMissing, ItemProfile.CONTRIBUTOR_DEFAULT, monitor));
                }
                catch (TeamRepositoryException e) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.ContributorListControl_UPDATING_USERS_ERROR, e);
                    ContributorListControl.this.getSite().showStatusText(Messages.ContributorListControl_COULD_NOT_ADD_USERS_ERROR);
                }
            }
            return super.runInBackground(monitor);
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            if (this.fResolvedMissing != null && !this.fResolvedMissing.isEmpty() && !ContributorListControl.this.getSite().isDisposed()) {
                ContributorListControl.this.fContributors.addAll(this.fResolvedMissing);
                ContributorListControl.this.getCheckBoxTableViewer().add(this.fResolvedMissing.toArray());
                ContributorListControl.this.updateSelection(this.fSelection);
            }
            return super.runInUI(monitor);
        }
    }
}

