/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.util.CollectionUtils;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.AttributeValueSetInputProvider;
import com.ibm.team.workitem.rcp.core.internal.FavoriteValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributorInputProvider
extends AttributeValueSetInputProvider {
    public static final String FAVORITE_KEY = "com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem";
    private static final int MAX_CONTRIBUTORS = 50;
    private static final int TEAM_SIZE_CUTOFF = 100;

    public ContributorInputProvider(IQueryableAttribute attribute) {
        super(attribute);
    }

    @Override
    public Object createInput(IProjectAreaHandle projectArea, Collection<Object> required, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IAuditableClient.class);
        ItemHandleAwareHashSet handles = new ItemHandleAwareHashSet();
        List favorites = FavoriteValues.getInstance().getItems(auditableClient.getTeamRepository(), FAVORITE_KEY, IContributorHandle.class);
        handles.addAll((Collection)favorites);
        List<IContributorHandle> requiredValues = this.getRequiredValues(required);
        handles.addAll(requiredValues);
        this.addTeamMates((ItemHandleAwareHashSet<IContributorHandle>)handles, projectArea, monitor);
        return CollectionUtils.removeNulls((List)auditableClient.resolveAuditables(new ArrayList(handles), ItemProfile.CONTRIBUTOR_DEFAULT, monitor)).toArray();
    }

    private List<IContributorHandle> getRequiredValues(Collection<Object> values) {
        ArrayList<IContributorHandle> required = new ArrayList<IContributorHandle>(values.size());
        for (Object value : values) {
            if (!(value instanceof IContributorHandle)) continue;
            required.add((IContributorHandle)value);
        }
        return required;
    }

    protected void addTeamMates(ItemHandleAwareHashSet<IContributorHandle> handles, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        if (handles.size() > 50) {
            return;
        }
        List<ITeamArea> teamAreas = this.findTeamAreas(projectArea, monitor);
        int total = this.getTotalMembers(teamAreas);
        HashMap<UUID, ScoredContributor> scoredMap = new HashMap<UUID, ScoredContributor>((int)((float)total / 0.75f));
        for (ITeamArea teamArea : teamAreas) {
            IContributorHandle[] members = teamArea.getMembers();
            if (members.length > 100) continue;
            IContributorHandle[] iContributorHandleArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IContributorHandle member = iContributorHandleArray[n2];
                ScoredContributor scored = (ScoredContributor)scoredMap.get(member.getItemId());
                if (scored == null) {
                    scored = new ScoredContributor(member);
                    scoredMap.put(member.getItemId(), scored);
                }
                scored.score += 1.0f / (float)members.length;
                ++n2;
            }
        }
        ArrayList scoredMembers = new ArrayList(scoredMap.values());
        Collections.sort(scoredMembers, new Comparator<ScoredContributor>(){

            @Override
            public int compare(ScoredContributor sc1, ScoredContributor sc2) {
                return Float.compare(sc2.score, sc1.score);
            }
        });
        int max = 50 - handles.size();
        int i = 0;
        while (i < Math.min(max, scoredMembers.size())) {
            handles.add((Object)((ScoredContributor)scoredMembers.get((int)i)).handle);
            ++i;
        }
    }

    private int getTotalMembers(List<ITeamArea> teamAreas) {
        int total = 0;
        for (ITeamArea teamArea : teamAreas) {
            int memberCount = teamArea.getMembers().length;
            if (memberCount > 100) continue;
            total += memberCount;
        }
        return total;
    }

    List<ITeamArea> findTeamAreas(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        List teamAreas = this.findCachedTeamAreas(projectArea);
        if (teamAreas.isEmpty()) {
            IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IAuditableClient.class);
            LinkedList<ITeamAreaHandle> teamAreaHandles = new LinkedList<ITeamAreaHandle>();
            ItemQueryIterator teamAreaIterator = WorkItemQueries.teamAreasByContributorAndProjectArea((IAuditableCommon)auditableClient, (IContributorHandle)auditableClient.getUser(), (IProjectAreaHandle)projectArea);
            while (teamAreaIterator.hasNext(monitor)) {
                teamAreaHandles.add((ITeamAreaHandle)teamAreaIterator.next(monitor));
            }
            teamAreas = auditableClient.resolveAuditablesPermissionAware(teamAreaHandles, ItemProfile.TEAM_AREA_DEFAULT, monitor);
        }
        return teamAreas;
    }

    private List<ITeamArea> findCachedTeamAreas(IProjectAreaHandle projectArea) {
        IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IAuditableClient.class);
        IContributorHandle currentUser = auditableClient.getUser();
        ArrayList<ITeamArea> myTeamAreas = new ArrayList<ITeamArea>();
        List teamAreas = auditableClient.findAllCachedAuditables(ItemProfile.TEAM_AREA_DEFAULT);
        for (ITeamArea teamArea : teamAreas) {
            if (!teamArea.getProjectArea().sameItemId((IItemHandle)projectArea) || !teamArea.hasMember(currentUser)) continue;
            myTeamAreas.add(teamArea);
        }
        return myTeamAreas;
    }

    private static class ScoredContributor {
        IContributorHandle handle;
        float score = 0.0f;

        public ScoredContributor(IContributorHandle contributor) {
            this.handle = contributor;
        }
    }
}

