/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.internal.util.CategoryTreeNode;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.TreeViewerControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.CategoryProviders;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.actions.ActionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryTreeViewerControl
extends TreeViewerControl {
    private Action fShowArchivedAction = new Action(Messages.CategoryTreeViewerControl_FILTER_SHOW_ARCHIVED, 2){

        public void run() {
            CategoryTreeViewerControl.this.fFilter.showArchived(this.isChecked());
            CategoryTreeViewerControl.this.refresh();
        }
    };
    private Action fShowDetailedAction = new Action(Messages.CategoryTreeViewerControl_FILTER_SHOW_INVISIBLE, 2){

        public void run() {
            CategoryTreeViewerControl.this.fFilter.showDetailed(this.isChecked());
            CategoryTreeViewerControl.this.refresh();
        }
    };
    private CategoryProviders.CategoryFilter fFilter;

    public CategoryTreeViewerControl() {
        this.setInputProvider(CategoryProviders.createInputProvider());
        this.setContentProvider((IContentProvider)CategoryProviders.createContentProvider());
        this.setPopupContentProvider((IContentProvider)CategoryProviders.createContentProvider());
        this.setLabelProvider((IBaseLabelProvider)CategoryProviders.createLabelProvider());
        this.setPopupLabelProvider((IBaseLabelProvider)CategoryProviders.createLabelProvider());
        this.setComparator(CategoryProviders.createComparator());
        this.setConverter(CategoryProviders.createConverter());
        this.setElementComparer(CategoryProviders.createElementComparer());
        this.fFilter = CategoryProviders.createFilter();
        this.setFilters(this.fFilter);
        this.setWidthHintInChars(30);
    }

    @Override
    protected void inputChanged(Object input) {
        super.inputChanged(input);
        if (input instanceof CategoryProviders.CategoryInput) {
            CategoryProviders.CategoryInput categoryInput = (CategoryProviders.CategoryInput)input;
            List<CategoryTreeNode> categoriesToExpand = this.getCategoriesToExpand(categoryInput);
            for (CategoryTreeNode category : categoriesToExpand) {
                this.getCheckboxTreeViewer().expandToLevel((Object)category, 1);
            }
        } else {
            this.getCheckboxTreeViewer().expandAll();
        }
    }

    private List<CategoryTreeNode> getCategoriesToExpand(CategoryProviders.CategoryInput categoryInput) {
        ArrayList<CategoryTreeNode> categoriesToExpand = new ArrayList<CategoryTreeNode>();
        IProjectArea projectArea = categoryInput.getCategoriesManager().getProjectArea();
        List connectedTeamAreas = ConnectedProjectAreaRegistry.getDefault().getSelectedTeamAreas((IProjectAreaHandle)projectArea);
        ItemHandleAwareHashSet teamAreas = new ItemHandleAwareHashSet((Collection)connectedTeamAreas);
        this.addMatching(categoriesToExpand, categoryInput.getCategoriesManager().getRoot().getChildren(), (Set<ITeamAreaHandle>)teamAreas);
        return categoriesToExpand;
    }

    private void addMatching(List<CategoryTreeNode> categoriesToExpand, Set<CategoryTreeNode> categoryNodes, Set<ITeamAreaHandle> teamAreas) {
        for (CategoryTreeNode categoryNode : categoryNodes) {
            if (this.containsAny(categoryNode, teamAreas)) {
                categoriesToExpand.add(categoryNode);
            }
            this.addMatching(categoriesToExpand, categoryNode.getChildren(), teamAreas);
        }
    }

    private boolean containsAny(CategoryTreeNode category, Set<ITeamAreaHandle> teamAreas) {
        for (ITeamAreaHandle teamAreaHandle : category.getTeamAreas()) {
            if (!teamAreas.contains(teamAreaHandle)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected ActionGroup createFilterActionGroup() {
        return new ActionGroup(){

            public void fillContextMenu(IMenuManager menu) {
                menu.add((IAction)CategoryTreeViewerControl.this.fShowDetailedAction);
                menu.add((IAction)CategoryTreeViewerControl.this.fShowArchivedAction);
            }
        };
    }

    private void refresh() {
        this.fFilter.setExcludedElements(this.getSelectedElements());
        this.getCheckboxTreeViewer().refresh();
        this.getCheckboxTreeViewer().expandAll();
    }

    @Override
    protected void setSelectedElements(Object[] elements) {
        this.fFilter.setExcludedElements(elements);
        super.setSelectedElements(elements);
    }

    @Override
    public AttributeOperation validateOperator(AttributeOperation currentOperator, Collection<Object> values) {
        if (AttributeOperation.EQUALS != currentOperator && AttributeOperation.NOT_EQUALS != currentOperator) {
            for (Object object : values) {
                IAttributeVariable variable;
                if (!(object instanceof IAttributeVariable) || !"my categories".equals((variable = (IAttributeVariable)object).getId())) continue;
                return AttributeOperation.EQUALS;
            }
        }
        return super.validateOperator(currentOperator, values);
    }
}

