/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableWorkItemAttribute;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IInputProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueSetInputProvider
implements IInputProvider {
    private IQueryableAttribute fAttribute;

    public AttributeValueSetInputProvider(IQueryableAttribute attribute) {
        this.fAttribute = attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object createInput(IProjectAreaHandle projectArea, Collection<Object> required, IProgressMonitor monitor) throws TeamRepositoryException {
        workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IWorkItemClient.class);
        auditableClient = workItemClient.getAuditableCommon();
        workItemHandle = null;
        workingCopyManager = workItemClient.getWorkItemWorkingCopyManager();
        type = AttributeTypes.getAttributeType((String)this.fAttribute.getAttributeType());
        try {
            monitor.beginTask(Messages.AttributeValueSetInputProvider_RETRIEVING_VALUES_JOB_MESSAGE, 100);
            var10_9 = AttributeValueSetInputProvider.class;
            synchronized (AttributeValueSetInputProvider.class) {
                workItemHandle = workingCopyManager.connectNew(this.getWorkItemType(workItemClient, projectArea, "com.ibm.team.workitem.workItemType"), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                workItem = workingCopyManager.getWorkingCopy(workItemHandle).getWorkItem();
                // ** MonitorExit[var10_9] (shouldn't be in output)
                attribute = null;
                if (this.fAttribute instanceof QueryableWorkItemAttribute) {
                    attribute = ((QueryableWorkItemAttribute)this.fAttribute).getAttribute();
                }
                if ((values = type.getValueSet(auditableClient, workItem, attribute, monitor)) == null) {
                    var17_12 = new Object[]{};
                    if (workItemHandle == null) break block11;
                }
                ** GOTO lbl-1000
            }
        }
        catch (Throwable var16_19) {
            if (workItemHandle != null) {
                workingCopyManager.disconnect(workItemHandle);
            }
            monitor.done();
            throw var16_19;
        }
        {
            block13: {
                block12: {
                    block11: {
                        workingCopyManager.disconnect(workItemHandle);
                    }
                    monitor.done();
                    return var17_12;
lbl-1000:
                    // 1 sources

                    {
                        if (!required.isEmpty()) ** GOTO lbl-1000
                        var17_13 = values;
                        if (workItemHandle == null) break block12;
                    }
                    workingCopyManager.disconnect(workItemHandle);
                }
                monitor.done();
                return var17_13;
lbl-1000:
                // 1 sources

                {
                    valueSet = new ArrayList<Object>(Arrays.asList(values));
                    set = new ItemHandleAwareHashSet(valueSet);
                    for (Object value : required) {
                        if (set.contains(value)) continue;
                        valueSet.add(value);
                    }
                    var17_14 = valueSet.toArray();
                    if (workItemHandle == null) break block13;
                }
                workingCopyManager.disconnect(workItemHandle);
            }
            monitor.done();
            return var17_14;
        }
    }

    private IWorkItemType getWorkItemType(IWorkItemClient workItemClient, IProjectAreaHandle projectAreaHandle, String category) throws TeamRepositoryException {
        List types = workItemClient.findWorkItemTypes(projectAreaHandle, null);
        if (types == null) {
            return null;
        }
        for (IWorkItemType type : types) {
            if (!category.equals(type.getCategory())) continue;
            return type;
        }
        for (IWorkItemType type : types) {
            if (!category.startsWith(type.getCategory()) && !type.getCategory().startsWith(category)) continue;
            return type;
        }
        return workItemClient.findWorkItemType(projectAreaHandle, "defect", null);
    }

    protected IQueryableAttribute getAttribute() {
        return this.fAttribute;
    }
}

