/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.util;

import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.util.Constants;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;

public class VariableAwareLabelProvider
extends BaseLabelProvider
implements IViewerLabelProvider,
ILabelProvider {
    private IBaseLabelProvider fLabelProvider;
    private final boolean fDisposeDelegate;

    public VariableAwareLabelProvider(IBaseLabelProvider labelProvider) {
        this(labelProvider, true);
    }

    public VariableAwareLabelProvider(IBaseLabelProvider labelProvider, boolean disposeDelegate) {
        this.fLabelProvider = labelProvider;
        this.fDisposeDelegate = disposeDelegate;
    }

    public void updateLabel(ViewerLabel label, Object element) {
        if (Constants.NULL == element) {
            element = null;
        }
        if (element instanceof IAttributeVariable) {
            IAttributeVariable variable = (IAttributeVariable)element;
            label.setText(variable.getDisplayName());
            return;
        }
        if (this.fLabelProvider instanceof IViewerLabelProvider) {
            ((IViewerLabelProvider)this.fLabelProvider).updateLabel(label, element);
        } else if (this.fLabelProvider instanceof ILabelProvider) {
            ILabelProvider lp = (ILabelProvider)this.fLabelProvider;
            label.setText(lp.getText(element));
            label.setImage(lp.getImage(element));
        }
    }

    public Image getImage(Object element) {
        ViewerLabel label = new ViewerLabel("", null);
        this.updateLabel(label, element);
        return label.getImage();
    }

    public String getText(Object element) {
        ViewerLabel label = new ViewerLabel("", null);
        this.updateLabel(label, element);
        return label.getText();
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fLabelProvider != null) {
            this.fLabelProvider.addListener(listener);
        } else {
            super.addListener(listener);
        }
    }

    public void dispose() {
        if (this.fDisposeDelegate) {
            this.disposeDelegate();
        }
        super.dispose();
    }

    public void disposeDelegate() {
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        if (this.fLabelProvider != null) {
            return this.fLabelProvider.isLabelProperty(element, property);
        }
        return super.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fLabelProvider != null) {
            this.fLabelProvider.removeListener(listener);
        } else {
            super.removeListener(listener);
        }
    }
}

