/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.util;

import com.ibm.team.jface.util.ConvertingSelectionProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IValueConverter;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.util.Constants;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ConvertingValueSelectionProvider
implements ISelectionProvider {
    private IValueConverter fValueConverter;
    private ISelection fLastSelection = StructuredSelection.EMPTY;
    private final ConvertingSelectionProvider fConvertingSelectionProvider;

    public ConvertingValueSelectionProvider(ISelectionProvider provider) {
        this.fConvertingSelectionProvider = new ConvertingSelectionProvider(provider){

            protected ISelection convertFrom(ISelection viewerSelection) {
                if (viewerSelection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)viewerSelection;
                    ArrayList converted = new ArrayList();
                    for (Object object : structuredSelection) {
                        if (object == Constants.NULL) {
                            converted.add(null);
                            continue;
                        }
                        Object value = object;
                        if (ConvertingValueSelectionProvider.this.fValueConverter != null) {
                            value = ConvertingValueSelectionProvider.this.fValueConverter.convertFrom(object);
                        }
                        if (value == null || "".equals(value)) continue;
                        converted.add(value);
                    }
                    return new StructuredSelection(converted);
                }
                return viewerSelection;
            }

            public ISelection convertTo(ISelection selection) {
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    ArrayList<Object> converted = new ArrayList<Object>();
                    for (Object object : structuredSelection) {
                        if (object == null) {
                            converted.add((Object)Constants.NULL);
                            continue;
                        }
                        if (ConvertingValueSelectionProvider.this.fValueConverter != null) {
                            converted.add(ConvertingValueSelectionProvider.this.fValueConverter.convertTo(object));
                            continue;
                        }
                        converted.add(object);
                    }
                    return new StructuredSelection(converted);
                }
                return selection;
            }
        };
    }

    public ISelection getLastSelection(boolean convert) {
        if (convert) {
            return this.fConvertingSelectionProvider.convertTo(this.fLastSelection);
        }
        return this.fLastSelection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fConvertingSelectionProvider.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.fConvertingSelectionProvider.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fConvertingSelectionProvider.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.fLastSelection = selection;
        this.fConvertingSelectionProvider.setSelection(selection);
    }

    public void setValueConverter(IValueConverter converter) {
        this.fValueConverter = converter;
    }
}

