/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.part;

import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.EditableAttributeExpression;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.internal.expression.EditableStatement;
import com.ibm.team.workitem.common.internal.expression.EditableTerm;
import com.ibm.team.workitem.common.model.AttributeOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeGroupTermAdapter
extends EditableAttributeExpression {
    private final EditableTerm fTerm;

    public TypeGroupTermAdapter(EditableTerm term) {
        super((EditableAttributeExpression)term.getExpressions().get(0));
        this.fTerm = term;
    }

    public void addValue(Object value) {
        super.addValue(value);
        for (EditableExpression expression : this.fTerm.getExpressions()) {
            if (!(expression instanceof EditableAttributeExpression)) continue;
            ((EditableAttributeExpression)expression).addValue(value);
        }
    }

    public void removeValue(Object value) {
        super.removeValue(value);
        for (EditableExpression expression : this.fTerm.getExpressions()) {
            if (!(expression instanceof EditableAttributeExpression)) continue;
            ((EditableAttributeExpression)expression).removeValue(value);
        }
    }

    public void setOperator(AttributeOperation operator) {
        super.setOperator(operator);
        for (EditableExpression expression : this.fTerm.getExpressions()) {
            if (!(expression instanceof EditableAttributeExpression)) continue;
            ((EditableAttributeExpression)expression).setOperator(operator);
        }
    }

    public void setValues(Collection<Object> values) {
        super.setValues(values);
        for (EditableExpression expression : this.fTerm.getExpressions()) {
            if (!(expression instanceof EditableAttributeExpression)) continue;
            ((EditableAttributeExpression)expression).setValues(values);
        }
    }

    public List<IQueryableAttribute> getAttributes() {
        ArrayList<IQueryableAttribute> attributes = new ArrayList<IQueryableAttribute>();
        for (EditableExpression expression : this.fTerm.getExpressions()) {
            if (!(expression instanceof EditableAttributeExpression)) continue;
            attributes.add(((EditableAttributeExpression)expression).getAttribute());
        }
        return attributes;
    }

    public void addAttribute(IQueryableAttribute attribute) {
        EditableAttributeExpression expression = new EditableAttributeExpression(attribute, this.getOperator());
        expression.setValues(this.getValues());
        this.fTerm.add((EditableExpression)expression);
    }

    public void removeAttribute(IQueryableAttribute attribute) {
        ArrayList<EditableExpression> toRemove = new ArrayList<EditableExpression>(1);
        for (EditableExpression expression : this.fTerm.getExpressions()) {
            if (!(expression instanceof EditableAttributeExpression) || !((EditableAttributeExpression)expression).getAttribute().getIdentifier().equals(attribute.getIdentifier())) continue;
            toRemove.add(expression);
        }
        for (EditableExpression expression : toRemove) {
            this.fTerm.remove(expression);
        }
    }

    public EditableTerm getTerm() {
        return this.fTerm;
    }

    public EditableStatement getStatement() {
        return this.fTerm.getStatement();
    }

    public EditableTerm getParent() {
        return this.fTerm.getParent();
    }
}

