/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.part;

import com.ibm.team.workitem.client.query.WorkingCopyChangeEvent;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.EditableAttributeExpression;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.internal.expression.EditableTerm;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.TypeGroupDescriptor;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.ConditionPart;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.TypeGroupTermAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeGroupPart
extends ConditionPart {
    private static final String KEY_ATTRIBUTE = "_attribute";
    private SelectionListener fAttributeSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TypeGroupPart.this.handleAttributeSelectionEvent(e);
        }
    };
    private final TypeGroupTermAdapter fCondition;
    private final List<Button> fAttributeCheckBoxes;
    private List<AttributeOperation> fOperators;

    public static boolean canHandle(EditableTerm term, List<TypeGroupDescriptor> configuredTypeGroups) {
        List expressions = term.getExpressions();
        if (expressions.isEmpty()) {
            return false;
        }
        ArrayList<EditableAttributeExpression> attributeExpressions = new ArrayList<EditableAttributeExpression>(expressions.size());
        for (EditableExpression expression : expressions) {
            if (expression instanceof EditableAttributeExpression) {
                attributeExpressions.add((EditableAttributeExpression)expression);
                continue;
            }
            return false;
        }
        EditableAttributeExpression master = (EditableAttributeExpression)attributeExpressions.get(0);
        String requiredType = master.getAttribute().getAttributeType();
        if (TypeGroupPart.getTypeGroupDescriptor(configuredTypeGroups, requiredType) == null) {
            return false;
        }
        AttributeOperation requiredOperator = master.getOperator();
        ItemHandleAwareHashSet requiredValueSet = new ItemHandleAwareHashSet(master.getValues());
        for (EditableAttributeExpression attributeExpression : attributeExpressions) {
            if (requiredType.equals(attributeExpression.getAttribute().getAttributeType()) && requiredOperator.equals((Object)attributeExpression.getOperator()) && requiredValueSet.containsAll(attributeExpression.getValues()) && new ItemHandleAwareHashSet(attributeExpression.getValues()).containsAll((Collection)requiredValueSet)) continue;
            return false;
        }
        return true;
    }

    private static TypeGroupDescriptor getTypeGroupDescriptor(List<TypeGroupDescriptor> typeGroups, String type) {
        for (TypeGroupDescriptor typeGroup : typeGroups) {
            if (!type.equals(typeGroup.getTypeIdentifier())) continue;
            return typeGroup;
        }
        return null;
    }

    public TypeGroupPart(EditableTerm condition) {
        this(new TypeGroupTermAdapter(condition));
    }

    private TypeGroupPart(TypeGroupTermAdapter condition) {
        super(condition);
        this.fCondition = condition;
        this.fAttributeCheckBoxes = new ArrayList<Button>();
    }

    @Override
    protected void update(WorkingCopyChangeEvent event) {
        super.update(event);
        if (event.affects((EditableExpression)this.fCondition.getTerm())) {
            switch (event.getExpressionChangeEventType()) {
                case TERM_CONDITION_ADDED: 
                case TERM_CONDITION_REMOVED: 
                case TERM_CLEARED: {
                    this.updateAttributes();
                }
            }
        }
    }

    @Override
    public String getPartTitle() {
        return this.getTypeGroupDescriptor().getSectionLabel();
    }

    @Override
    protected EditableExpression getCondition() {
        return this.fCondition.getTerm();
    }

    @Override
    protected void createPartContent(Composite parent) {
        RowLayout layout = new RowLayout(this.getTypeGroupDescriptor().useHorizontalLayout() ? 512 : 256);
        layout.fill = true;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.getSite().getToolkit();
        Composite attributeComposite = toolkit.createComposite(parent);
        attributeComposite.setBackground(null);
        this.createAttributeControls(attributeComposite);
        Composite valueComposite = toolkit.createComposite(parent);
        valueComposite.setBackground(null);
        this.createConditionPartContent(valueComposite);
    }

    private void createAttributeControls(Composite attributeComposite) {
        RowLayout layout = new RowLayout(this.getTypeGroupDescriptor().useHorizontalLayout() ? 256 : 512);
        attributeComposite.setLayout((Layout)layout);
        FormToolkit toolkit = this.getSite().getToolkit();
        for (IQueryableAttribute attribute : this.getTypeAttributes()) {
            Button checkBox = toolkit.createButton(attributeComposite, attribute.getDisplayName(), 32);
            checkBox.setData(KEY_ATTRIBUTE, (Object)attribute);
            checkBox.addSelectionListener(this.fAttributeSelectionListener);
            this.fAttributeCheckBoxes.add(checkBox);
        }
        this.updateAttributes();
    }

    @Override
    protected List<AttributeOperation> getOperators() {
        if (this.fOperators == null) {
            ArrayList<AttributeOperation> operators = new ArrayList<AttributeOperation>();
            for (IQueryableAttribute attribute : this.getTypeAttributes()) {
                if (operators.isEmpty()) {
                    operators.addAll(attribute.getOperators());
                    continue;
                }
                operators.retainAll(attribute.getOperators());
            }
            this.fOperators = operators;
        }
        return this.fOperators;
    }

    private TypeGroupDescriptor getTypeGroupDescriptor() {
        List<TypeGroupDescriptor> typeGroups = this.getInput().getConfiguration().getTypeGroups();
        return TypeGroupPart.getTypeGroupDescriptor(typeGroups, this.fCondition.getAttribute().getAttributeType());
    }

    private List<IQueryableAttribute> getTypeAttributes() {
        return this.getTypeGroupDescriptor().filter(this.getInput().getConfiguration().getAttributes());
    }

    private void updateAttributes() {
        List<String> attributes = this.getIdentifiers(this.fCondition.getAttributes());
        for (Button checkBox : this.fAttributeCheckBoxes) {
            IQueryableAttribute attribute = this.getAttribute(checkBox);
            checkBox.setSelection(attributes.contains(attribute.getIdentifier()));
        }
    }

    private List<String> getIdentifiers(List<IQueryableAttribute> attributes) {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (IQueryableAttribute attribute : attributes) {
            identifiers.add(attribute.getIdentifier());
        }
        return identifiers;
    }

    private void handleAttributeSelectionEvent(SelectionEvent e) {
        Button checkBox = (Button)e.widget;
        IQueryableAttribute attribute = this.getAttribute(checkBox);
        if (checkBox.getSelection()) {
            this.fCondition.addAttribute(attribute);
        } else {
            this.fCondition.removeAttribute(attribute);
        }
    }

    private IQueryableAttribute getAttribute(Button checkBox) {
        return (IQueryableAttribute)checkBox.getData(KEY_ATTRIBUTE);
    }
}

