/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.part;

import com.ibm.team.workitem.client.query.WorkingCopyChangeEvent;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.internal.expression.EditableAttributeExpression;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.internal.expression.EditableTerm;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.actions.AddConditionsAction;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.actions.ChangeTermOperatorAction;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.actions.RemoveChildrenAction;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.actions.RemoveConditionAction;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.TypeGroupDescriptor;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.AbstractConditionPart;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.ConditionPart;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.CustomSection;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.QueryEditorFormPart;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.TypeGroupPart;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.WrapLayout;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class TermPart
extends QueryEditorFormPart {
    private static boolean WORK_AROUND_32664 = "gtk".equals(SWT.getPlatform());
    private static final String[] HANDLED_ATTRIBUTES = new String[]{IQueryDescriptor.EXPRESSION_PROPERTY};
    private final EditableTerm fTerm;
    private final boolean fIsRoot;
    private CustomSection fCustomSection;
    private Composite fConditionComposite;
    private Action fAddConditionAction;
    private Action fRemoveAction;
    private final List<PartAssociation> fPartAssociations = new ArrayList<PartAssociation>();

    public TermPart(EditableTerm term) {
        this(term, true);
    }

    private TermPart(EditableTerm term, boolean isRoot) {
        this.fTerm = term;
        this.fIsRoot = isRoot;
    }

    protected String[] getHandledAttributes() {
        return HANDLED_ATTRIBUTES;
    }

    protected void update(WorkingCopyChangeEvent event) {
        if (event.affects((EditableExpression)this.fTerm)) {
            switch (event.getExpressionChangeEventType()) {
                case TERM_OPERATOR_CHANGED: {
                    this.updateOperator();
                    break;
                }
                case TERM_CONDITION_ADDED: {
                    this.addCondition(event.getCondition());
                    break;
                }
                case TERM_CONDITION_REMOVED: {
                    this.removeCondition(event.getCondition());
                    break;
                }
                case TERM_CLEARED: {
                    this.removeAllConditions();
                }
            }
            this.updateButtonEnablement();
        }
    }

    private void updateOperator() {
        Term.Operator operator = this.fTerm.getOperator();
        this.setOperatorLabel(operator.getLabel(), operator == Term.Operator.AND ? Messages.TermPart_AND_EXPLANATION : Messages.TermPart_OR_EXPLANATION);
    }

    private void setOperatorLabel(String label, String description) {
        this.getCustomSection().setTitle(label);
        this.getCustomSection().setMenuLabel(description);
    }

    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.fCustomSection = toolkit.createCustomSection(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fCustomSection);
        GridLayoutFactory.fillDefaults().applyTo(this.fCustomSection.getClientComposite());
        this.fConditionComposite = toolkit.createComposite(this.fCustomSection.getClientComposite());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fConditionComposite);
        WrapLayout wrapLayout = new WrapLayout();
        wrapLayout.setSpacing(10, 10);
        this.fConditionComposite.setLayout((Layout)wrapLayout);
        this.installOperatorMenu();
        this.installToolbar();
        this.updateOperator();
        this.createConditionSections();
        this.updateButtonEnablement();
    }

    private void installOperatorMenu() {
        IMenuManager operatorMenu = this.fCustomSection.getMenuManager();
        operatorMenu.add((IAction)new ChangeTermOperatorAction(this.fTerm, Term.Operator.AND));
        operatorMenu.add((IAction)new ChangeTermOperatorAction(this.fTerm, Term.Operator.OR));
        operatorMenu.update(true);
    }

    private void installToolbar() {
        this.fRemoveAction = this.fIsRoot ? new RemoveChildrenAction(this.fTerm) : new RemoveConditionAction((EditableExpression)this.fTerm);
        IToolBarManager toolbar = this.fCustomSection.getToolBarManager();
        toolbar.add((IAction)this.fRemoveAction);
        this.installAddConditionAction();
        toolbar.update(true);
    }

    private void installAddConditionAction() {
        QueryEditorInput input = this.getInput();
        if (input != null && this.fCustomSection != null && this.fAddConditionAction == null) {
            this.fAddConditionAction = new AddConditionsAction(this.fCustomSection.getShell(), this.fTerm, null, input.getConfiguration());
            this.fCustomSection.getToolBarManager().add((IAction)this.fAddConditionAction);
        }
    }

    private void createConditionSections() {
        for (EditableExpression expression : this.fTerm.getExpressions()) {
            this.addCondition(expression);
        }
    }

    private void addCondition(EditableExpression condition) {
        EditableTerm term;
        if (condition instanceof EditableAttributeExpression) {
            this.addSingleCondition((EditableAttributeExpression)condition);
        } else if (condition instanceof EditableTerm && !(term = (EditableTerm)condition).isInternal()) {
            List<TypeGroupDescriptor> configuredTypeGroups = this.getInput().getConfiguration().getTypeGroups();
            if (TypeGroupPart.canHandle(term, configuredTypeGroups)) {
                this.addTypeGroupCondition(term);
            } else {
                this.addTermCondition(term);
            }
        }
    }

    private void addTermCondition(EditableTerm term) {
        TermPart conditionsPart = new TermPart(term, false);
        conditionsPart.init(this.getSite());
        conditionsPart.setInput((Object)this.getInput());
        conditionsPart.createContent(this.fConditionComposite.getParent());
        this.associatePart((EditableExpression)term, conditionsPart);
        this.refreshLayout();
    }

    private void addSingleCondition(EditableAttributeExpression expression) {
        ConditionPart part = new ConditionPart(expression);
        this.showPart(part);
    }

    private void addTypeGroupCondition(EditableTerm term) {
        TypeGroupPart part = new TypeGroupPart(term);
        this.showPart(part);
    }

    private void showPart(AbstractConditionPart part) {
        part.init(this.getSite());
        part.setInput((Object)this.getInput());
        part.createContent(this.fConditionComposite);
        QueryEditorFormPart predecessor = this.findPredecessor(part.getCondition());
        CustomSection predecessorControl = this.getControl(predecessor);
        if (predecessorControl != null) {
            part.getCustomSection().moveBelow((Control)predecessorControl);
        }
        this.associatePart(part.getCondition(), part);
        this.refreshLayout();
        if (!WORK_AROUND_32664) {
            part.setFocus();
        }
    }

    private void associatePart(EditableExpression expression, QueryEditorFormPart part) {
        this.fPartAssociations.add(new PartAssociation(expression, part));
    }

    private QueryEditorFormPart getAssociatedPart(EditableExpression expression) {
        for (PartAssociation partAssociation : this.fPartAssociations) {
            if (partAssociation.expression != expression) continue;
            return partAssociation.part;
        }
        return null;
    }

    private QueryEditorFormPart disassociatePart(EditableExpression expression) {
        for (PartAssociation partAssociation : this.fPartAssociations) {
            if (partAssociation.expression != expression) continue;
            this.fPartAssociations.remove(partAssociation);
            return partAssociation.part;
        }
        return null;
    }

    private QueryEditorFormPart findPredecessor(EditableExpression expression) {
        EditableExpression predecessor = this.fTerm.getPredecessor(expression);
        return this.getAssociatedPart(predecessor);
    }

    private void removeCondition(EditableExpression condition) {
        QueryEditorFormPart part = this.disassociatePart(condition);
        if (part != null) {
            part.dispose();
            this.refreshLayout();
        }
    }

    private void removeAllConditions() {
        for (PartAssociation partAssociation : this.fPartAssociations) {
            partAssociation.part.dispose();
        }
        this.fPartAssociations.clear();
        this.refreshLayout();
    }

    private void refreshLayout() {
        SharedScrolledComposite form = this.getScrolledComposite();
        if (form != null) {
            form.reflow(true);
            form.layout(true, true);
        } else {
            this.fCustomSection.layout(true, true);
        }
    }

    private SharedScrolledComposite getScrolledComposite() {
        Composite parent = this.fCustomSection.getParent();
        while (parent != null) {
            if (parent instanceof SharedScrolledComposite) {
                return (SharedScrolledComposite)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private void updateButtonEnablement() {
        if (this.fIsRoot) {
            this.fRemoveAction.setEnabled(!this.fTerm.getExpressions().isEmpty());
        }
    }

    CustomSection getCustomSection() {
        return this.fCustomSection;
    }

    public void dispose() {
        super.dispose();
        this.fPartAssociations.clear();
        this.fCustomSection.dispose();
    }

    private CustomSection getControl(QueryEditorFormPart part) {
        if (part instanceof ConditionPart) {
            return ((ConditionPart)part).getCustomSection();
        }
        if (part instanceof TermPart) {
            return ((TermPart)part).getCustomSection();
        }
        return null;
    }

    private static class PartAssociation {
        final EditableExpression expression;
        final QueryEditorFormPart part;

        public PartAssociation(EditableExpression e, QueryEditorFormPart p) {
            this.expression = e;
            this.part = p;
        }
    }
}

