/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.part;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.ProcessAreaSelectionDialog;
import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.client.query.WorkingCopyChangeEvent;
import com.ibm.team.workitem.common.internal.util.CollectionUtils;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.query.IAssociation;
import com.ibm.team.workitem.common.query.IAssociations;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.QueryEditorFormPart;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.util.SectionUtils;
import com.ibm.team.workitem.rcp.ui.internal.util.ButtonUtils;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.Section;

public class SharingPart
extends QueryEditorFormPart {
    public static final String PART_ID = "com.ibm.team.query.part.sharing";
    private static final String[] HANDLED_ATTRIBUTES = new String[]{IQueryDescriptor.ASSOCIATIONS_PROPERTY};
    private static final int MAGIC_WIDTH_HINT_IN_CHARS = 16;
    private UIUpdaterJob fAssociationUpdater = new UIUpdaterJob(Messages.SharingPart_RESOLVING_JOB_MESSAGE){
        private List<IAuditableHandle> fAssociationTargets;

        public IStatus runInBackground(IProgressMonitor monitor) {
            block5: {
                try {
                    try {
                        monitor.beginTask(this.getName(), 100);
                        IAssociations associations = SharingPart.this.getInput().getWorkingCopy().getQueryDescriptor().getAssociations();
                        ArrayList<IAuditableHandle> associationTargets = new ArrayList<IAuditableHandle>(associations.getContents().size());
                        List processAreaAssociations = associations.filterTargets(IProcessAreaHandle.class);
                        List contributorAssociations = associations.filterTargets(IContributorHandle.class);
                        associationTargets.addAll(this.resolveAuditables(processAreaAssociations, ItemProfile.PROCESS_AREA_DEFAULT, (IProgressMonitor)new SubProgressMonitor(monitor, 50)));
                        associationTargets.addAll(this.resolveAuditables(contributorAssociations, ItemProfile.CONTRIBUTOR_DEFAULT, (IProgressMonitor)new SubProgressMonitor(monitor, 50)));
                        this.fAssociationTargets = associationTargets;
                    }
                    catch (TeamRepositoryException teamRepositoryException) {
                        this.fAssociationTargets = null;
                        monitor.done();
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
            return super.runInBackground(monitor);
        }

        private <T extends IAuditable> Collection<T> resolveAuditables(List<IAssociation> associations, ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
            if (associations.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<IAuditableHandle> handles = new ArrayList<IAuditableHandle>();
            for (IAssociation association : associations) {
                handles.add(association.getTarget());
            }
            IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)SharingPart.this.getInput().getItemHandle(), IAuditableClient.class);
            return CollectionUtils.removeNulls((List)auditableClient.resolveAuditables(handles, profile, monitor));
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            if (this.fAssociationTargets != null) {
                SharingPart.this.fTableViewer.setInput((Object)this.fAssociationTargets.toArray());
            }
            return super.runInUI(monitor);
        }
    };
    private SelectionAdapter fRemoveListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            SharingPart.this.removeAssociationTarget();
        }
    };
    private ISelectionChangedListener fEnablementUpdater = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            SharingPart.this.fRemoveButton.setEnabled(!event.getSelection().isEmpty());
        }
    };
    private TableViewer fTableViewer;
    private Button fRemoveButton;
    private ILabelProvider fLabelProvider;
    private ShareWithProcessAreaAction fShareWithProcessAreaAction;
    private ShareWithContributorAction fShareWithContributorAction;

    protected String[] getHandledAttributes() {
        return HANDLED_ATTRIBUTES;
    }

    protected void update(WorkingCopyChangeEvent event) {
        this.fAssociationUpdater.schedule();
    }

    public void setInput(Object input) {
        super.setInput(input);
        IQueryDescriptor workingCopy = this.getInput().getWorkingCopy().getQueryDescriptor();
        this.fShareWithProcessAreaAction.setWorkingCopy(workingCopy);
        this.fShareWithContributorAction.setWorkingCopy(workingCopy);
    }

    public void createContent(Composite parent) {
        this.setDescription(parent);
        parent.setLayout((Layout)new GridLayout(2, false));
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        Composite border = toolkit.createBorder(parent);
        Table table = toolkit.createTable(border, 0);
        table.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.fLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.addPostSelectionChangedListener(this.fEnablementUpdater);
        int minWidth = Utils.convertWidthInCharsToPixels((Control)this.fTableViewer.getControl(), (int)16);
        int minHeight = table.getItemHeight() * 3;
        GridDataFactory.fillDefaults().grab(true, true).hint(minWidth, minHeight).span(1, 2).applyTo((Control)border);
        MenuManager shareWithMenu = new MenuManager("#Popup");
        this.fShareWithProcessAreaAction = new ShareWithProcessAreaAction(parent.getShell());
        this.fShareWithContributorAction = new ShareWithContributorAction(parent.getShell());
        shareWithMenu.add((IAction)this.fShareWithProcessAreaAction);
        shareWithMenu.add((IAction)this.fShareWithContributorAction);
        Button shareWithButton = this.createButton(parent, Messages.SharingPart_SHARE_BUTTON);
        ButtonUtils.installMenu((Button)shareWithButton, (MenuManager)shareWithMenu);
        this.fRemoveButton = this.createButton(parent, Messages.SharingPart_REMOVE_BUTTON);
        this.fRemoveButton.addSelectionListener((SelectionListener)this.fRemoveListener);
        this.fRemoveButton.setEnabled(false);
    }

    private Button createButton(Composite parent, String label) {
        Button button = this.getSite().getToolkit().createButton(parent, label, 0x800000);
        button.setBackground(this.getSite().getToolkit().getColors().getBackground());
        button.setLayoutData((Object)new GridData(4, 128, false, false));
        return button;
    }

    private void setDescription(Composite parent) {
        Section section = SectionUtils.getSection(parent);
        section.setDescription(Messages.SharingPart_SECTION_EXPLANATION);
    }

    private void removeAssociationTarget() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        IAssociations associations = this.getInput().getWorkingCopy().getQueryDescriptor().getAssociations();
        for (Object selected : selection.toList()) {
            if (!(selected instanceof IAuditableHandle)) continue;
            IAssociation association = associations.createAssociation((IAuditableHandle)selected);
            associations.disassociate(association);
        }
    }

    public void dispose() {
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
        super.dispose();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    private static class ShareWithAuditableAction
    extends Action {
        private Shell fShell;
        private IQueryDescriptor fWorkingCopy;

        public ShareWithAuditableAction(String title, Shell shell) {
            super(title);
            this.fShell = shell;
        }

        public void setWorkingCopy(IQueryDescriptor workingCopy) {
            this.fWorkingCopy = workingCopy;
        }

        protected void associate(IAuditableHandle handle) {
            if (handle != null && !this.fWorkingCopy.getAssociations().containsTarget(handle)) {
                IAssociation association = this.fWorkingCopy.getAssociations().createAssociation(handle);
                this.fWorkingCopy.getAssociations().associate(association);
            }
        }

        protected Shell getShell() {
            return this.fShell;
        }

        protected IQueryDescriptor getWorkingCopy() {
            return this.fWorkingCopy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShareWithContributorAction
    extends ShareWithAuditableAction {
        public ShareWithContributorAction(Shell shell) {
            super(Messages.SharingPart_USER_LABEL, shell);
        }

        public void run() {
            if (this.getWorkingCopy() != null) {
                IContributorHandle[] selected;
                ITeamRepository repository = (ITeamRepository)this.getWorkingCopy().getProjectArea().getOrigin();
                List<IContributorHandle> filteredContributors = this.getFilteredContributors();
                TeamContributorSelectionDialog dialog = new TeamContributorSelectionDialog(this.getShell(), repository, filteredContributors, true);
                dialog.setTitle(Messages.SharingPart_SELECT_USER);
                dialog.setShellTitle(Messages.SharingPart_SELECT_USER);
                dialog.setMessage(Messages.SharingPart_SELECT_USERS_QUERY_MESSAGE);
                if (dialog.open() == 0 && (selected = dialog.getContributorResult()) != null && selected.length > 0) {
                    IContributorHandle[] iContributorHandleArray = selected;
                    int n = selected.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributorHandle contributorHandle = iContributorHandleArray[n2];
                        this.associate((IAuditableHandle)contributorHandle);
                        ++n2;
                    }
                }
            }
        }

        private List<IContributorHandle> getFilteredContributors() {
            List filteredAssociations = this.getWorkingCopy().getAssociations().filterTargets(IContributorHandle.class);
            ArrayList<IContributorHandle> filtered = new ArrayList<IContributorHandle>(filteredAssociations.size());
            for (IAssociation association : filteredAssociations) {
                filtered.add((IContributorHandle)association.getTarget());
            }
            return filtered;
        }
    }

    private static class ShareWithProcessAreaAction
    extends ShareWithAuditableAction {
        private ViewerFilter fFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProjectAreaHandle) {
                    IProjectAreaHandle projectArea = (IProjectAreaHandle)element;
                    return projectArea.sameItemId((IItemHandle)ShareWithProcessAreaAction.this.getWorkingCopy().getProjectArea());
                }
                return true;
            }
        };

        public ShareWithProcessAreaAction(Shell shell) {
            super(Messages.SharingPart_TEAM_AREA_LABEL, shell);
        }

        public void run() {
            if (this.getWorkingCopy() != null) {
                IProcessArea[] processAreas;
                ProcessAreaSelectionDialog dialog = new ProcessAreaSelectionDialog(this.getShell(), false);
                dialog.setAllowMultiple(true);
                dialog.addFilter(this.fFilter);
                dialog.setInput(this.getWorkingCopy().getOrigin());
                if (dialog.open() == 0 && (processAreas = dialog.getSelectedProcessAreas()) != null) {
                    IProcessArea[] iProcessAreaArray = processAreas;
                    int n = processAreas.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcessArea processArea = iProcessAreaArray[n2];
                        this.associate((IAuditableHandle)processArea);
                        ++n2;
                    }
                }
            }
        }
    }
}

