/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.part;

import com.ibm.team.workitem.client.query.WorkingCopyChangeEvent;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.QueryEditorFormPart;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NamePart
extends QueryEditorFormPart {
    public static final String PART_ID = "com.ibm.team.query.part.name";
    private static final String[] HANDLED_ATTRIBUTES = new String[]{IQueryDescriptor.NAME_PROPERTY};
    private Text fText;
    private ControlDecoration fErrorDecoration;

    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 10;
        parent.setLayout((Layout)layout);
        Label label = toolkit.createLabel(parent, Messages.NamePart_NAME_LABEL);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Composite container = toolkit.createBorder(parent);
        container.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fText = toolkit.createText(container, "");
        this.fText.setTextLimit((int)IQueryDescriptor.ITEM_TYPE.getMaxSize(IQueryDescriptor.NAME_PROPERTY));
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NamePart.this.setErrorMessage(NamePart.this.fText.getCharCount() == 0 ? Messages.NamePart_NAME_NOT_EMPTY_MESSAGE : null);
                IQueryDescriptor workingCopy = NamePart.this.getWorkingCopy().getQueryDescriptor();
                String name = NamePart.this.fText.getText();
                if (!workingCopy.getName().equals(name)) {
                    workingCopy.setName(name);
                }
            }
        });
        this.fText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.updateTextEnablement();
        this.addDecorations();
    }

    public void setInput(Object input) {
        boolean highlightSummary;
        super.setInput(input);
        this.updateTextEnablement();
        if (input instanceof QueryEditorInput && (highlightSummary = ((QueryEditorInput)((Object)input)).getConfiguration().hasOption(1)) && this.fText != null) {
            this.fText.selectAll();
            this.fText.setFocus();
        }
    }

    private void updateTextEnablement() {
        if (this.fText != null) {
            this.fText.setEnabled(this.getInput() != null);
        }
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return false;
    }

    protected String[] getHandledAttributes() {
        return HANDLED_ATTRIBUTES;
    }

    protected void update(WorkingCopyChangeEvent event) {
        IQueryDescriptor descriptor = event.getWorkingCopy().getQueryDescriptor();
        if (!this.fText.getText().equals(descriptor.getName())) {
            this.fText.setText(descriptor.getName());
        }
    }

    private void addDecorations() {
        this.fErrorDecoration = new ControlDecoration((Control)this.fText.getParent(), 0x1004000);
        this.fErrorDecoration.hide();
        this.fErrorDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
    }

    private void setErrorMessage(String message) {
        if (message != null) {
            this.fErrorDecoration.setDescriptionText(message);
            this.fErrorDecoration.show();
        } else {
            this.fErrorDecoration.hide();
        }
    }
}

