/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.part;

import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.client.query.WorkingCopyChangeEvent;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.QueryEditorFormPart;
import com.ibm.team.workitem.rcp.ui.internal.util.HyperlinkUtils;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DetailsPart
extends QueryEditorFormPart {
    public static final String PART_ID = "com.ibm.team.query.part.details";
    private static final String[] HANDLED_ATTRIBUTES = new String[]{IQueryDescriptor.PROJECTAREA_PROPERTY, IQueryDescriptor.CREATOR_PROPERTY, IQueryDescriptor.DESCRIPTION_PROPERTY};
    private IProjectArea fProjectArea;
    private IContributor fCreator;
    private HyperlinkUtils.DecoratedHyperlink fProjectAreaLink;
    private HyperlinkUtils.DecoratedHyperlink fCreatorLink;
    private Text fDescription;
    private ReferenceResolver fReferenceResolver = new ReferenceResolver();
    private ModifyListener fDescriptionModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            DetailsPart.this.modifyDescription(e);
        }
    };

    protected String[] getHandledAttributes() {
        return HANDLED_ATTRIBUTES;
    }

    public void setInput(Object input) {
        super.setInput(input);
        this.fReferenceResolver.schedule();
    }

    protected void update(WorkingCopyChangeEvent event) {
        if (IQueryDescriptor.DESCRIPTION_PROPERTY.equals(event.getAttribute())) {
            this.updateDescription();
        } else {
            this.fReferenceResolver.schedule();
        }
    }

    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        parent.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)parent);
        toolkit.createLabel(parent, Messages.DetailsPart_PROJECT_AREA_LABEL);
        this.fProjectAreaLink = this.createDecoratedHyperlink(parent);
        toolkit.createLabel(parent, Messages.DetailsPart_CREATED_BY_LABEL);
        this.fCreatorLink = this.createDecoratedHyperlink(parent);
        Label descriptionLabel = toolkit.createLabel(parent, Messages.DetailsPart_DESCRIPTION_LABEL);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)descriptionLabel);
        Composite border = toolkit.createBorder(parent);
        this.fDescription = toolkit.createText(border, "", 66);
        this.fDescription.setTextLimit((int)IQueryDescriptor.ITEM_TYPE.getMaxSize(IQueryDescriptor.DESCRIPTION_PROPERTY));
        this.fDescription.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.fDescription.addModifyListener(this.fDescriptionModifyListener);
        int minWidth = Utils.convertWidthInCharsToPixels((Control)this.fDescription, (int)10);
        int minHeight = this.fDescription.getLineHeight() * 4;
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).hint(minWidth, minHeight).applyTo((Control)border);
    }

    private void modifyDescription(ModifyEvent e) {
        this.getWorkingCopy().getQueryDescriptor().setDescription(this.fDescription.getText());
    }

    private void updateDescription() {
        String description = this.getWorkingCopy().getQueryDescriptor().getDescription();
        if (!description.equals(this.fDescription.getText())) {
            this.fDescription.setText(description);
        }
    }

    private void updateValues() {
        this.fProjectAreaLink.getControlLabelProvider().setElement((Object)this.fProjectArea);
        this.fCreatorLink.getControlLabelProvider().setElement((Object)this.fCreator);
    }

    private HyperlinkUtils.DecoratedHyperlink createDecoratedHyperlink(Composite parent) {
        Hyperlink hyperlink = this.getSite().getToolkit().createHyperlink(parent, Messages.DetailsPart_RESOLVING_PLACEHOLDER, 0);
        HyperlinkUtils.DecoratedHyperlink decorated = HyperlinkUtils.createDecoratedHyperlink((Control)hyperlink);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(decorated.getControlLabelProvider().getControl());
        this.getSite().registerContextMenu(this.getId(), decorated.getMenuManager(), decorated.getSelectionProvider());
        return decorated;
    }

    private class ReferenceResolver
    extends UIUpdaterJob {
        public ReferenceResolver() {
            super(Messages.DetailsPart_RESOLVING_JOB_MESSAGE);
        }

        public IStatus runInBackground(IProgressMonitor monitor) {
            try {
                IQueryDescriptor queryDescriptor = DetailsPart.this.getWorkingCopy().getQueryDescriptor();
                IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)queryDescriptor, IAuditableClient.class);
                DetailsPart.this.fProjectArea = (IProjectArea)auditableClient.resolveAuditable((IAuditableHandle)queryDescriptor.getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT, monitor);
                DetailsPart.this.fCreator = (IContributor)auditableClient.resolveAuditable((IAuditableHandle)queryDescriptor.getCreator(), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
                return super.runInBackground(monitor);
            }
            catch (TeamRepositoryException e) {
                return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.DetailsPart_RESOLVING_JOB_ERROR, (Throwable)e);
            }
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            DetailsPart.this.updateValues();
            return super.runInUI(monitor);
        }
    }
}

