/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.part;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class CustomSectionTitle
extends Hyperlink {
    private DisposeListener fDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            CustomSectionTitle.this.onDispose(e);
        }
    };
    public static final String TITLE_HREF = "title_href";
    public static final String MENU_HREF = "menu_href";
    private static final int MENU_HANDLE_WIDTH = 5;
    private String fMenuText = "";
    private Rectangle fMenuTextBox;
    private boolean fHovering = false;
    private boolean fMenuMode = false;
    private boolean fHoverHighlighting = false;
    private BoldFontHolder fBoldFontHolder = new BoldFontHolder();
    private Color fTextHoverColor = this.getForeground();
    private Color fMenuTextHoverBackground = this.getBackground();
    private int fMenuBoxVMargin = 1;
    private int fMenuBoxHMargin = 2;
    private int fMenuTextSpacing = 5;

    public CustomSectionTitle(Composite parent, int style) {
        super(parent, style);
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                CustomSectionTitle.this.handleMouseMove(e);
            }
        });
        this.addDisposeListener(this.fDisposeListener);
        this.addAccessibility();
    }

    public void setHoverHighlighting(boolean on) {
        this.fHoverHighlighting = on;
    }

    public void setMenuText(String text) {
        this.fMenuText = text != null ? text : "";
        this.getParent().layout();
        this.redraw();
    }

    public void setTextHoverColor(Color color) {
        this.fTextHoverColor = color;
    }

    public void setMenuTextHoverBackground(Color color) {
        this.fMenuTextHoverBackground = color;
    }

    public Color getTextColor() {
        return this.fHoverHighlighting && this.fHovering && !this.fMenuMode ? this.fTextHoverColor : this.getForeground();
    }

    public Object getHref() {
        return this.fMenuMode ? MENU_HREF : TITLE_HREF;
    }

    protected Point computeTextSize(int widthHint, int heightHint) {
        GC gc = new GC((Drawable)this);
        String text = this.getText();
        gc.setFont(this.fBoldFontHolder.getBoldFont((Control)this));
        Point titleExtent = gc.textExtent(text != null ? text : "");
        gc.setFont(this.getFont());
        Point menuExtent = this.getMaxMenuExtent(gc);
        int width = titleExtent.x + menuExtent.x + this.fMenuTextSpacing + 2 * this.fMenuBoxHMargin + 5;
        Point extent = new Point(width, Math.max(titleExtent.y, menuExtent.y));
        if (extent.x < widthHint) {
            extent.x = widthHint;
        }
        if (extent.y < heightHint) {
            extent.y = heightHint;
        }
        gc.dispose();
        return extent;
    }

    private Point getMaxMenuExtent(GC gc) {
        Point maxExtent = gc.textExtent(this.getMenuText());
        Menu menu = this.getMenu();
        if (menu == null || menu.getItemCount() == 0) {
            return maxExtent;
        }
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            Point extent = gc.textExtent(menuItem.getText());
            maxExtent = Geometry.max((Point)maxExtent, (Point)extent);
            ++n2;
        }
        return maxExtent;
    }

    protected void paintText(GC gc, Rectangle bounds) {
        gc.setFont(this.fBoldFontHolder.getBoldFont((Control)this));
        gc.setForeground(this.getTextColor());
        String textToDraw = this.getText();
        Point textExtent = gc.textExtent(textToDraw);
        gc.drawText(textToDraw, bounds.x, bounds.y, true);
        gc.setFont(this.getFont());
        gc.setForeground(this.getForeground());
        String menuTextToDraw = this.getMenuText();
        Point menuTextExtent = gc.textExtent(menuTextToDraw);
        int menuTextStart = bounds.x + textExtent.x + this.fMenuTextSpacing;
        this.fMenuTextBox = new Rectangle(menuTextStart - this.fMenuBoxHMargin, bounds.y - this.fMenuBoxVMargin, menuTextExtent.x + 5 * this.fMenuBoxHMargin + 5, bounds.height + 2 * this.fMenuBoxVMargin);
        if (this.fMenuMode) {
            gc.setBackground(this.fMenuTextHoverBackground);
            gc.fillRoundRectangle(this.fMenuTextBox.x, this.fMenuTextBox.y, this.fMenuTextBox.width, this.fMenuTextBox.height, 2, 2);
        }
        this.drawMenuHandle(gc, this.fMenuTextBox.x + this.fMenuTextBox.width - 2 * this.fMenuBoxHMargin - 5, this.fMenuTextBox.y + this.fMenuTextBox.height / 2);
        gc.drawText(menuTextToDraw, menuTextStart, bounds.y, true);
    }

    private void drawMenuHandle(GC gc, int x, int y) {
        gc.drawLine(x, y - 1, x + 4, y - 1);
        gc.drawLine(x + 1, y, x + 3, y);
        gc.drawLine(x + 2, y + 1, x + 2, y + 1);
    }

    private String getMenuText() {
        return this.fMenuText;
    }

    protected void handleActivate(Event e) {
        Menu menu;
        super.handleActivate(e);
        if ((this.isOverMenu(e.x) || e.type == 1) && (menu = this.getMenu()) != null) {
            Point location = this.toDisplay(this.fMenuTextBox.x, this.fMenuTextBox.y + this.fMenuTextBox.height);
            menu.setLocation(location);
            menu.setVisible(true);
        }
    }

    protected void handleEnter(Event e) {
        if (e.type == 6) {
            this.fHovering = true;
            this.fMenuMode = this.isOverMenu(e.x);
        }
        super.handleEnter(e);
    }

    protected void handleExit(Event e) {
        if (e.type == 7) {
            this.fHovering = false;
            this.fMenuMode = false;
        }
        super.handleExit(e);
    }

    private void handleMouseMove(MouseEvent e) {
        boolean overMenu = this.isOverMenu(e.x);
        if (overMenu != this.fMenuMode) {
            this.fMenuMode = overMenu;
            this.redraw();
        }
    }

    private boolean isOverMenu(int x) {
        if (this.fMenuTextBox == null) {
            return false;
        }
        return x > this.fMenuTextBox.x && x < this.fMenuTextBox.x + this.fMenuTextBox.width;
    }

    private void onDispose(DisposeEvent e) {
        this.fBoldFontHolder.dispose();
    }

    private void addAccessibility() {
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 11;
            }
        });
    }

    private static class BoldFontHolder {
        private Font fNormalFont;
        private Font fBoldFont;

        public Font getBoldFont(Display display, Font font) {
            this.initBoldFont(display, font);
            return this.fBoldFont;
        }

        public Font getBoldFont(Control control) {
            return this.getBoldFont(control.getDisplay(), control.getFont());
        }

        private void initBoldFont(Display display, Font font) {
            if (this.fNormalFont == null || !this.fNormalFont.equals((Object)font)) {
                this.fNormalFont = font;
                this.dispose();
            }
            if (this.fBoldFont == null) {
                this.fBoldFont = this.createBoldFont(display, this.fNormalFont);
            }
        }

        private Font createBoldFont(Display display, Font regularFont) {
            FontData[] fontDatas = regularFont.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setStyle(fontDatas[i].getStyle() | 1);
                ++i;
            }
            return new Font((Device)display, fontDatas);
        }

        public void dispose() {
            if (this.fBoldFont != null) {
                this.fBoldFont.dispose();
                this.fBoldFont = null;
            }
        }
    }
}

