/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.part;

import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.CustomSectionTitle;
import java.util.HashMap;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;

public class CustomSection
extends Composite {
    private static boolean DISABLE_ANTIALIASING = "win32".equals(SWT.getPlatform());
    public static final int STYLE_STATUS = 2;
    private static final int BORDER_RADIUS = 6;
    private PaintListener fBorderPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            CustomSection.this.onPaint(e);
        }
    };
    private DisposeListener fDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            CustomSection.this.onDispose(e);
        }
    };
    private Label fTitleLabel;
    private ToolBarManager fToolBarManager;
    private Composite fTitleComposite;
    private Composite fClientComposite;
    private Color fBorderColor = WorkItemIDEUIPlugin.getDefault().getMidShadow();
    private CustomSectionTitle fSectionTitle;
    private Label fStatusLabel;
    private MenuManager fMenuManager;
    private HashMap<String, String> fMessageMap = new HashMap();
    private Stack<String> fKeyStack = new Stack();

    public CustomSection(Composite parent, int style) {
        super(parent, 0);
        this.setBackgroundMode(1);
        this.addPaintListener(this.fBorderPaintListener);
        this.addDisposeListener(this.fDisposeListener);
        this.createControls(style);
    }

    private void createControls(int style) {
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 2;
        formLayout.marginWidth = 2;
        this.setLayout((Layout)formLayout);
        this.fTitleComposite = new Composite((Composite)this, 0);
        FormData titleFormData = new FormData();
        titleFormData.left = new FormAttachment(0);
        titleFormData.right = new FormAttachment(100);
        titleFormData.top = new FormAttachment(0);
        this.fTitleComposite.setLayoutData((Object)titleFormData);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(5, 5, 1, 1).applyTo(this.fTitleComposite);
        this.fSectionTitle = new CustomSectionTitle(this.fTitleComposite, 0);
        GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)this.fSectionTitle);
        this.fToolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = this.fToolBarManager.createControl(this.fTitleComposite);
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
        if ((style & 2) != 0) {
            this.fStatusLabel = new Label((Composite)this, 524288);
            FormData statusFormData = new FormData();
            statusFormData.left = new FormAttachment(0, 10);
            statusFormData.right = new FormAttachment(100, -10);
            statusFormData.bottom = new FormAttachment(100, -7);
            this.fStatusLabel.setLayoutData((Object)statusFormData);
        }
        this.fClientComposite = new Composite((Composite)this, 1);
        this.fClientComposite.setBackground(null);
        FormData clientFormData = new FormData();
        clientFormData.left = new FormAttachment(0, 10);
        clientFormData.right = new FormAttachment(100, -10);
        clientFormData.bottom = this.fStatusLabel != null ? new FormAttachment((Control)this.fStatusLabel, -4) : new FormAttachment(100, -10);
        clientFormData.top = new FormAttachment((Control)this.fTitleComposite, 10);
        this.fClientComposite.setLayoutData((Object)clientFormData);
    }

    public void setBorderColor(Color color) {
        Assert.isNotNull((Object)color);
        this.fBorderColor = color;
    }

    public void setTitleForegroundColor(Color color) {
        this.fSectionTitle.setForeground(color);
    }

    public void setTitleBackgroundColor(Color color) {
        this.fTitleComposite.setBackground(color);
    }

    public void setTitle(String text) {
        Assert.isNotNull((Object)text);
        this.fSectionTitle.setText(text);
    }

    public void setTitleToolTip(String toolTipText) {
        this.fTitleLabel.setToolTipText(toolTipText);
    }

    public void setMenuHoverBackgroundColor(Color color) {
        this.fSectionTitle.setMenuTextHoverBackground(color);
    }

    public void setMenuLabel(String label) {
        this.fSectionTitle.setMenuText(label);
    }

    public void setStatusText(String key, String statusText) {
        if (this.fStatusLabel == null) {
            return;
        }
        if (statusText == null || "".equals(statusText)) {
            this.fMessageMap.remove(key);
            this.fKeyStack.remove(key);
        } else {
            this.fMessageMap.put(key, statusText);
            if (!this.fKeyStack.contains(key)) {
                this.fKeyStack.push(key);
            }
        }
        if (this.fKeyStack.isEmpty()) {
            this.fStatusLabel.setText("");
        } else {
            this.fStatusLabel.setText(this.fMessageMap.get(this.fKeyStack.peek()));
        }
    }

    public IMenuManager getMenuManager() {
        if (this.fMenuManager == null) {
            this.fMenuManager = new MenuManager("#popup");
            Menu menu = this.fMenuManager.createContextMenu((Control)this.fSectionTitle);
            this.fSectionTitle.setMenu(menu);
        }
        return this.fMenuManager;
    }

    public IToolBarManager getToolBarManager() {
        return this.fToolBarManager;
    }

    public Composite getClientComposite() {
        return this.fClientComposite;
    }

    private void onPaint(PaintEvent e) {
        GC gc = e.gc;
        Color foreground = this.getForeground();
        try {
            Rectangle clientArea = this.getClientArea();
            if (!DISABLE_ANTIALIASING) {
                gc.setAntialias(1);
            }
            gc.setForeground(this.fBorderColor);
            gc.drawRoundRectangle(0, 0, clientArea.width - 1, clientArea.height - 1, 6, 6);
            gc.setForeground(this.getBackground());
            gc.drawPoint(0, clientArea.height - 1);
            gc.drawPoint(clientArea.width - 1, clientArea.height - 1);
        }
        finally {
            if (!DISABLE_ANTIALIASING) {
                gc.setAntialias(0);
            }
            gc.setForeground(foreground);
        }
    }

    private void onDispose(DisposeEvent e) {
    }
}

