/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.part;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.query.WorkingCopyChangeEvent;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.internal.expression.EditableAttributeExpression;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.ConditionControlInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.AbstractConditionPart;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.Messages;
import java.text.ChoiceFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionPart
extends AbstractConditionPart {
    private static final String KEY_VALUE = "_value";
    private SelectionListener fValueSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ConditionPart.this.handleValueSelectionEvent(e);
        }
    };
    private final EditableAttributeExpression fCondition;
    private IConditionControl fConditionControl;
    private List<Button> fValueCheckBoxes;
    private boolean fShowSummary;

    public ConditionPart(EditableAttributeExpression expression) {
        this.fCondition = expression;
        this.fValueCheckBoxes = new ArrayList<Button>();
        this.fShowSummary = false;
    }

    @Override
    protected void update(WorkingCopyChangeEvent event) {
        if (event.affects((EditableExpression)this.fCondition)) {
            switch (event.getExpressionChangeEventType()) {
                case CONDITION_OPERATOR_CHANGED: {
                    this.updateOperator();
                    break;
                }
                case CONDITION_VALUE_CHANGED: {
                    this.updateStatus();
                    this.validateOperator();
                }
            }
        }
    }

    @Override
    public String getPartTitle() {
        return this.getPathLabel(this.fCondition.getAttribute());
    }

    @Override
    protected void createPartContent(Composite contentArea) {
        this.createConditionPartContent(contentArea);
    }

    @Override
    protected EditableExpression getCondition() {
        return this.fCondition;
    }

    public void setFocus() {
        if (this.fConditionControl != null) {
            this.fConditionControl.setFocus();
        }
    }

    protected void createConditionPartContent(Composite contentArea) {
        this.fConditionControl = this.getInput().getConfiguration().createConditionControl(this.fCondition.getAttribute());
        if (this.fConditionControl == null) {
            return;
        }
        this.fConditionControl.init(this);
        this.createOperatorMenu();
        this.updateOperator();
        IQueryableAttribute attribute = this.fCondition.getAttribute();
        ArrayList variables = new ArrayList();
        variables.addAll(attribute.getVariables());
        if (!variables.isEmpty()) {
            List<IAttributeVariable<?>> list = this.getVariables(this.fCondition.getValues());
            for (IAttributeVariable<?> used : list) {
                if (variables.contains(used)) continue;
                variables.add(used);
            }
        }
        if (variables.isEmpty() && !attribute.hasNullValue()) {
            this.fConditionControl.createContent(contentArea);
        } else {
            GridLayoutFactory.fillDefaults().numColumns(2).spacing(10, 2).applyTo(contentArea);
            if (attribute.hasNullValue()) {
                Button button = this.createValueControl(contentArea, Messages.ConditionPart_UNASSIGNED_LITERAL, attribute.getNullValue());
                GridDataFactory.fillDefaults().applyTo((Control)button);
            }
            for (IAttributeVariable iAttributeVariable : variables) {
                Button variableControl = this.createValueControl(contentArea, iAttributeVariable.getDisplayName(), iAttributeVariable);
                GridDataFactory.fillDefaults().applyTo((Control)variableControl);
            }
            Composite composite = this.getToolkit().createComposite(contentArea);
            composite.setBackground(null);
            GridDataFactory.fillDefaults().grab(true, true).span(2, 1).indent(0, 4).applyTo((Control)composite);
            this.fConditionControl.createContent(composite);
        }
        this.updateStatus();
        this.setInput();
        this.updateValues();
        this.installListeners();
    }

    private List<IAttributeVariable<?>> getVariables(Collection<Object> values) {
        ArrayList variables = new ArrayList();
        for (Object object : values) {
            if (!(object instanceof IAttributeVariable)) continue;
            variables.add((IAttributeVariable)object);
        }
        return variables;
    }

    private void setInput() {
        IProjectAreaHandle projectArea = this.getInput().getWorkingCopy().getQueryDescriptor().getProjectArea();
        this.fConditionControl.setInput(new ConditionControlInput(projectArea, this.fCondition));
    }

    private void updateValues() {
        ItemHandleAwareHashSet valueSet = new ItemHandleAwareHashSet(this.fCondition.getValues());
        for (Button valueCheckBox : this.fValueCheckBoxes) {
            Object value = this.getValue(valueCheckBox);
            if (valueSet.contains(value)) {
                valueCheckBox.setSelection(true);
                valueSet.remove(value);
                continue;
            }
            valueCheckBox.setSelection(false);
        }
        this.fConditionControl.getSelectionProvider().setSelection((ISelection)new StructuredSelection(valueSet.toArray()));
    }

    private void installListeners() {
        this.fConditionControl.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConditionPart.this.handleSelectionChanged(event);
            }
        });
    }

    private Button createValueControl(Composite parent, String label, Object value) {
        Button variableCheckBox = this.getToolkit().createButton(parent, label, 32);
        variableCheckBox.setData(KEY_VALUE, value);
        variableCheckBox.addSelectionListener(this.fValueSelectionListener);
        this.fValueCheckBoxes.add(variableCheckBox);
        return variableCheckBox;
    }

    protected List<AttributeOperation> getOperators() {
        return this.fCondition.getAttribute().getOperators();
    }

    protected void handleSetOperator(AttributeOperation operator) {
        this.fCondition.setOperator(operator);
    }

    private void updateOperator() {
        this.getCustomSection().setMenuLabel(this.fCondition.getOperator().getDisplayName());
    }

    private void createOperatorMenu() {
        IMenuManager operatorMenu = this.getMenuManager();
        List<AttributeOperation> operators = this.getOperators();
        for (AttributeOperation operator : operators) {
            SetOperatorAction action = new SetOperatorAction(operator);
            operatorMenu.add((IAction)action);
        }
        operatorMenu.update(true);
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        ArrayList<Object> values = new ArrayList<Object>(this.getSelectionValues(event.getSelection()));
        values.addAll(this.getCheckedValues());
        this.fCondition.setValues(values);
    }

    private List<Object> getSelectionValues(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.toList();
        }
        return Collections.emptyList();
    }

    private List<Object> getCheckedValues() {
        ArrayList<Object> variables = new ArrayList<Object>(this.fValueCheckBoxes.size());
        for (Button variableCheckBox : this.fValueCheckBoxes) {
            if (!variableCheckBox.getSelection()) continue;
            Object value = this.getValue(variableCheckBox);
            variables.add(value);
        }
        return variables;
    }

    private void handleValueSelectionEvent(SelectionEvent e) {
        Button valueCheckBox = (Button)e.widget;
        Object value = this.getValue(valueCheckBox);
        if (valueCheckBox.getSelection()) {
            this.fCondition.addValue(value);
        } else {
            this.fCondition.removeValue(value);
        }
    }

    private Object getValue(Button valueCheckBox) {
        return valueCheckBox.getData(KEY_VALUE);
    }

    private String getPathLabel(IQueryableAttribute attribute) {
        LinkedList<IQueryableAttribute> path = new LinkedList<IQueryableAttribute>();
        IQueryableAttribute parent = attribute;
        while (parent != null) {
            path.add(parent);
            parent = parent.getParent();
        }
        StringBuffer buffer = new StringBuffer();
        ListIterator iterator = path.listIterator(path.size());
        while (iterator.hasPrevious()) {
            buffer.append(((IQueryableAttribute)iterator.previous()).getDisplayName());
            if (!iterator.hasPrevious()) continue;
            buffer.append(Messages.ConditionPart_ATTRIBUTE_PATH_SEPARATOR);
        }
        return buffer.toString();
    }

    @Override
    public void showSummary(boolean show) {
        this.fShowSummary = show;
    }

    private void updateStatus() {
        if (this.fShowSummary) {
            int number = this.fCondition.getValues().size();
            ChoiceFormat choiceFormat = new ChoiceFormat(Messages.ConditionPart_SELECTED_VALUES_CHOICEFORMAT);
            String format = choiceFormat.format(number);
            String message = NLS.bind((String)format, (Object)number, (Object[])new Object[0]);
            this.getCustomSection().setStatusText("count", message);
        }
    }

    private void validateOperator() {
        AttributeOperation operator = this.fConditionControl.validateOperator(this.fCondition.getOperator(), this.fCondition.getValues());
        if (operator != null && !this.fCondition.getOperator().equals((Object)operator)) {
            this.fCondition.setOperator(operator);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.getCustomSection().isDisposed();
    }

    private class SetOperatorAction
    extends Action {
        private AttributeOperation fOperator;

        public SetOperatorAction(AttributeOperation operator) {
            super(operator.getDisplayName());
            this.fOperator = operator;
        }

        public void run() {
            ConditionPart.this.handleSetOperator(this.fOperator);
        }
    }
}

