/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.part;

import com.ibm.team.workitem.client.query.WorkingCopyChangeEvent;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.StatementChangeEvent;
import com.ibm.team.workitem.common.internal.expression.EditableStatement;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.SlushBucket;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.QueryEditorFormPart;
import com.ibm.team.workitem.rcp.ui.internal.queries.QueryableAttributeContentProvider;
import com.ibm.team.workitem.rcp.ui.internal.queries.QueryableAttributeLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.util.DefaultViewerComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnsPart
extends QueryEditorFormPart {
    public static final String PART_ID = "com.ibm.team.query.part.columns";
    private static final String[] HANDLED_ATTRIBUTES = new String[]{IQueryDescriptor.EXPRESSION_PROPERTY};
    private SelectionAdapter fButtonDispatcher = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (ColumnsPart.this.fSlushBucket.getAddButton() == e.widget) {
                ColumnsPart.this.handleAdd();
            } else if (ColumnsPart.this.fSlushBucket.getAddAllButton() == e.widget) {
                ColumnsPart.this.handleAddAll();
            } else if (ColumnsPart.this.fSlushBucket.getRemoveButton() == e.widget) {
                ColumnsPart.this.handleRemove();
            } else if (ColumnsPart.this.fSlushBucket.getRemoveAllButton() == e.widget) {
                ColumnsPart.this.handleRemoveAll();
            } else if (ColumnsPart.this.fSlushBucket.getUpButton() == e.widget) {
                ColumnsPart.this.handleMoveUp();
            } else if (ColumnsPart.this.fSlushBucket.getDownButton() == e.widget) {
                ColumnsPart.this.handleMoveDown();
            } else if (ColumnsPart.this.fSlushBucket.getDefaultsButton() == e.widget) {
                ColumnsPart.this.handleSetDefaults();
            }
        }
    };
    private IDoubleClickListener fDoubleClickDispatcher = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            if (ColumnsPart.this.fAvailableColumnViewer == event.getViewer()) {
                ColumnsPart.this.handleAdd();
            } else if (ColumnsPart.this.fSelectedColumnViewer == event.getViewer()) {
                ColumnsPart.this.handleRemove();
            }
        }
    };
    private TableViewer fAvailableColumnViewer;
    private TableViewer fSelectedColumnViewer;
    private SlushBucket fSlushBucket;
    private EditableStatement fStatement;
    private List<IQueryableAttribute> fAvailableAttributes;

    @Override
    protected String[] getHandledAttributes() {
        return HANDLED_ATTRIBUTES;
    }

    @Override
    protected void update(WorkingCopyChangeEvent event) {
        if (event.affects(this.fStatement)) {
            StatementChangeEvent statementChangeEvent = event.getStatementChangeEvent();
            switch (statementChangeEvent.getType()) {
                case COLUMNS_ADDED: {
                    this.addColumns(statementChangeEvent.getColumns());
                    break;
                }
                case COLUMNS_REMOVED: {
                    this.removeColumns(statementChangeEvent.getColumns());
                    break;
                }
                case COLUMNS_CLEARED: 
                case COLUMNS_CHANGED: {
                    this.updateAll();
                    break;
                }
                case COLUMNS_CHANGED_ORDER: {
                    this.updateColumns();
                }
            }
        }
    }

    @Override
    public void setInput(Object input) {
        super.setInput(input);
        this.fStatement = this.getInput().getWorkingCopy().getEditableStatement();
        this.fAvailableAttributes = this.getInput().getConfiguration().getColumnAttributes();
        this.fAvailableColumnViewer.setInput(this.fAvailableAttributes);
        this.fSelectedColumnViewer.setInput((Object)this.fStatement);
        this.fSlushBucket.updateButtonEnablement();
    }

    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        this.fSlushBucket = toolkit.createSlushBucket(parent, Messages.ColumnsPart_AVAILABLE_COLUMNS, Messages.ColumnsPart_SELECTED_COLUMNS);
        this.fAvailableColumnViewer = new TableViewer(this.fSlushBucket.getAvailableTable());
        this.fAvailableColumnViewer.setContentProvider((IContentProvider)new QueryableAttributeContentProvider());
        this.fAvailableColumnViewer.setLabelProvider((IBaseLabelProvider)new QueryableAttributeLabelProvider());
        this.fAvailableColumnViewer.addFilter((ViewerFilter)new AvailableColumnsFilter());
        this.fAvailableColumnViewer.setComparator((ViewerComparator)new DefaultViewerComparator(QueryableAttributes.createComparator()));
        this.fSelectedColumnViewer = new TableViewer(this.fSlushBucket.getSelectedTable());
        this.fSelectedColumnViewer.setContentProvider((IContentProvider)new SelectedColumnsContentProvider());
        this.fSelectedColumnViewer.setLabelProvider((IBaseLabelProvider)new QueryableAttributeLabelProvider());
        this.fSlushBucket.addSelectionListener((SelectionListener)this.fButtonDispatcher);
        this.fAvailableColumnViewer.addDoubleClickListener(this.fDoubleClickDispatcher);
        this.fSelectedColumnViewer.addDoubleClickListener(this.fDoubleClickDispatcher);
    }

    private void handleAdd() {
        List<IQueryableAttribute> addedAttributes = this.getAttributesFromSelection(this.fAvailableColumnViewer.getSelection());
        this.fStatement.addColumns(addedAttributes);
    }

    private void handleAddAll() {
        this.fStatement.addColumns(this.fAvailableAttributes);
    }

    private void handleRemove() {
        List<IQueryableAttribute> addedAttributes = this.getAttributesFromSelection(this.fSelectedColumnViewer.getSelection());
        this.fStatement.removeColumns(addedAttributes);
    }

    private void handleRemoveAll() {
        this.fStatement.removeAllColumns();
    }

    private void handleMoveUp() {
        List<IQueryableAttribute> movedAttributes = this.getAttributesFromSelection(this.fSelectedColumnViewer.getSelection());
        this.fStatement.moveColumns(movedAttributes, -1);
    }

    private void handleMoveDown() {
        List<IQueryableAttribute> movedAttributes = this.getAttributesFromSelection(this.fSelectedColumnViewer.getSelection());
        this.fStatement.moveColumns(movedAttributes, 1);
    }

    private void addColumns(List<IQueryableAttribute> columns) {
        this.fSelectedColumnViewer.refresh();
        this.fSelectedColumnViewer.setSelection((ISelection)new StructuredSelection(columns));
        this.fAvailableColumnViewer.remove(columns.toArray());
        this.fSlushBucket.updateButtonEnablement();
    }

    private void removeColumns(List<IQueryableAttribute> columns) {
        this.fSelectedColumnViewer.refresh();
        this.fAvailableColumnViewer.add(columns.toArray());
        this.fAvailableColumnViewer.setSelection((ISelection)new StructuredSelection(columns));
        this.fSlushBucket.updateButtonEnablement();
    }

    private void updateAll() {
        this.fSelectedColumnViewer.refresh();
        this.fAvailableColumnViewer.refresh();
        this.fSlushBucket.updateButtonEnablement();
    }

    private void updateColumns() {
        this.fSelectedColumnViewer.refresh();
        this.fSlushBucket.updateButtonEnablement();
    }

    private void handleSetDefaults() {
        List<IQueryableAttribute> defaultColumns = this.getInput().getConfiguration().getDefaultColumns();
        this.fStatement.setColumns(defaultColumns);
    }

    private List<IQueryableAttribute> getAttributesFromSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<IQueryableAttribute> attributes = new ArrayList<IQueryableAttribute>(structuredSelection.size());
            for (Object element : structuredSelection) {
                if (!(element instanceof IQueryableAttribute)) continue;
                attributes.add((IQueryableAttribute)element);
            }
            return attributes;
        }
        return Collections.emptyList();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    private class AvailableColumnsFilter
    extends ViewerFilter {
        private AvailableColumnsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (ColumnsPart.this.fStatement != null) {
                IQueryableAttribute attribute = (IQueryableAttribute)element;
                for (IQueryableAttribute column : ColumnsPart.this.fStatement.getColumns()) {
                    if (!attribute.getIdentifier().equals(column.getIdentifier())) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static class SelectedColumnsContentProvider
    implements IStructuredContentProvider {
        private SelectedColumnsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EditableStatement) {
                EditableStatement statement = (EditableStatement)inputElement;
                return statement.getColumns().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

