/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.part;

import com.ibm.team.jface.GradientUtilities;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.actions.AddConditionsAction;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.actions.RemoveConditionAction;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IConditionControlSite;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.CustomSection;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.part.QueryEditorFormPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractConditionPart
extends QueryEditorFormPart
implements IConditionControlSite {
    private static final String[] HANDLED_ATTRIBUTES = new String[]{IQueryDescriptor.EXPRESSION_PROPERTY};
    private CustomSection fCustomSection;

    protected String[] getHandledAttributes() {
        return HANDLED_ATTRIBUTES;
    }

    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getToolkit();
        this.fCustomSection = toolkit.createCustomSection(parent, 2);
        this.fCustomSection.setTitle(this.getPartTitle());
        FormColors colors = this.getToolkit().getColors();
        GradientUtilities.setVerticalGradient((Composite)this.fCustomSection, (Color)colors.getColor("org.eclipse.ui.forms.H_GRADIENT_END"), (Color)colors.getColor("org.eclipse.ui.forms.H_GRADIENT_START"));
        this.createPartContent(this.fCustomSection.getClientComposite());
        this.installToolbarActions();
    }

    private void installToolbarActions() {
        QueryEditorInput input = this.getInput();
        this.getToolBarManager().add((IAction)new RemoveConditionAction(this.getCondition()));
        this.getToolBarManager().add((IAction)new AddConditionsAction(this.getCustomSection().getShell(), this.getCondition().getParent(), this.getCondition(), input.getConfiguration()));
        this.getToolBarManager().update(false);
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public IToolBarManager getToolBarManager() {
        return this.getCustomSection().getToolBarManager();
    }

    public FormToolkit getToolkit() {
        return this.getSite().getToolkit();
    }

    public void showStatusText(String text) {
        this.getCustomSection().setStatusText("status", text);
    }

    protected IMenuManager getMenuManager() {
        return this.getCustomSection().getMenuManager();
    }

    protected CustomSection getCustomSection() {
        return this.fCustomSection;
    }

    public void dispose() {
        super.dispose();
        this.getCustomSection().dispose();
    }

    protected abstract EditableExpression getCondition();

    protected abstract void createPartContent(Composite var1);
}

