/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.control;

import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.StructuredViewerControl;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeViewerControl
extends StructuredViewerControl {
    private ICheckStateListener fCheckStateListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (TreeViewerControl.this.fNonCheckableClasses != null) {
                Class<?> selectedClass = event.getElement().getClass();
                Class[] classArray = TreeViewerControl.this.fNonCheckableClasses;
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class clazz = classArray[n2];
                    if (clazz.isAssignableFrom(selectedClass)) {
                        event.getCheckable().setChecked(event.getElement(), false);
                        return;
                    }
                    ++n2;
                }
            }
            if (TreeViewerControl.this.fAutoCheckChildren) {
                TreeViewerControl.this.fTreeViewer.setSubtreeChecked(event.getElement(), event.getChecked());
            }
        }
    };
    private CheckboxTreeViewer fTreeViewer;
    private boolean fExpandAll = false;
    private boolean fAutoCheckChildren = false;
    private Class<?>[] fNonCheckableClasses;

    public void setExpandAll(boolean expandAll) {
        this.fExpandAll = expandAll;
    }

    public void setAutoCheckChildren(boolean auto) {
        this.fAutoCheckChildren = auto;
    }

    public void setNonCheckableClasses(Class<?> ... classes) {
        this.fNonCheckableClasses = classes;
    }

    @Override
    protected StructuredViewer createStructuredViewer(Composite parent) {
        Tree tree = this.getSite().getToolkit().createTree(parent, 34);
        this.fTreeViewer = new CheckboxTreeViewer(tree);
        this.fTreeViewer.addCheckStateListener(this.fCheckStateListener);
        return this.fTreeViewer;
    }

    @Override
    protected int getMinWidth() {
        return Utils.convertWidthInCharsToPixels((Control)this.fTreeViewer.getControl(), (int)this.getWidthHintInChars());
    }

    @Override
    protected int getMinHeight() {
        return this.fTreeViewer.getTree().getItemHeight() * this.getHeightHintInLines();
    }

    protected CheckboxTreeViewer getCheckboxTreeViewer() {
        return this.fTreeViewer;
    }

    @Override
    protected Object[] getSelectedElements() {
        return this.fTreeViewer.getCheckedElements();
    }

    @Override
    protected void inputChanged(Object input) {
        super.inputChanged(input);
        if (this.fExpandAll) {
            this.fTreeViewer.expandAll();
        }
    }

    @Override
    protected void setSelectedElements(Object[] elements) {
        if (this.fTreeViewer.getInput() != null) {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.fTreeViewer.expandToLevel(element, 0);
                ++n2;
            }
            this.fTreeViewer.setCheckedElements(elements);
            if (elements.length > 0) {
                this.fTreeViewer.reveal(elements[0]);
            }
        }
    }
}

