/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.control;

import com.ibm.icu.text.Collator;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.AbstractSelectionProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IValidator;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.MultiContentProposalProvider;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextControl
extends AbstractSelectionProvider {
    private static final String DEFAULT_SEPARATOR = ",";
    private VerifyListener fStrictVerificationListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            TextControl.this.handleVerification(e);
        }
    };
    private ModifyListener fWarnModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            TextControl.this.handleVerification(e);
        }
    };
    private Text fText;
    private Composite fTextContainer;
    private ControlDecoration fControlDecoration;
    private IValidator fValidator;
    private boolean fMultiSelection;
    private final ContentAssistCommandAdapter fContentAssistCommandAdapter;
    private final MultiContentProposalProvider fProposalProvider;

    public TextControl(Composite parent, int style) {
        this(parent, style, false);
    }

    public TextControl(Composite parent, int style, boolean supportContentAssist) {
        this.fTextContainer = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.fTextContainer);
        this.fText = new Text(this.fTextContainer, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fText);
        this.fControlDecoration = new ControlDecoration((Control)this.fText, 0x1004000);
        this.fControlDecoration.hide();
        this.fControlDecoration.setShowHover(true);
        if (supportContentAssist) {
            this.fProposalProvider = new MultiContentProposalProvider();
            this.fContentAssistCommandAdapter = new ContentAssistCommandAdapter((Control)this.fText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.fProposalProvider, null, new char[]{DEFAULT_SEPARATOR.charAt(0)}, true);
            this.fContentAssistCommandAdapter.setProposalAcceptanceStyle(2);
            this.fContentAssistCommandAdapter.setEnabled(true);
        } else {
            this.fProposalProvider = null;
            this.fContentAssistCommandAdapter = null;
        }
        this.useMultiSelection(true);
        this.installListeners();
    }

    public void setWidthHintInChars(int chars) {
        int widthInPixels = chars > 0 ? Utils.convertWidthInCharsToPixels((Control)this.fText, (int)chars) : -1;
        this.fText.setLayoutData((Object)new GridData(widthInPixels, -1));
    }

    public Text getTextControl() {
        return this.fText;
    }

    public Composite getTextContainer() {
        return this.fTextContainer;
    }

    public void setValidator(IValidator validator, Options options) {
        this.fValidator = validator;
        this.fText.removeVerifyListener(this.fStrictVerificationListener);
        this.fText.removeModifyListener(this.fWarnModifyListener);
        if (options == Options.VERIFY_STRICT) {
            this.fText.addVerifyListener(this.fStrictVerificationListener);
        } else if (options == Options.VERIFY_WARN) {
            this.fText.addModifyListener(this.fWarnModifyListener);
        }
    }

    public boolean isInputValid() {
        if (this.fValidator == null) {
            return true;
        }
        IStatus status = this.validate(this.fText.getText());
        return status.isOK() || 1 == status.getSeverity();
    }

    public void useMultiSelection(boolean multi) {
        this.fMultiSelection = multi;
    }

    public void setInput(Object input) {
        if (this.fContentAssistCommandAdapter == null) {
            return;
        }
        Object[] values = this.getInputValues(input);
        if (values.length > 0) {
            this.fProposalProvider.setProposals(this.createLabels(values));
            this.fProposalProvider.setSeparator(this.fMultiSelection ? DEFAULT_SEPARATOR : null);
        }
    }

    protected void handleVerification(VerifyEvent e) {
        if (this.fValidator != null) {
            String currentText = this.fText.getText();
            String newText = String.valueOf(currentText.substring(0, e.start)) + e.text + currentText.substring(e.end);
            IStatus status = this.validate(newText);
            if (!status.isOK()) {
                e.doit = false;
                this.fControlDecoration.showHoverText(status.getMessage());
            } else {
                this.fControlDecoration.hideHover();
            }
        }
    }

    protected void handleVerification(ModifyEvent e) {
        if (this.fValidator != null) {
            IStatus status = this.validate(this.fText.getText());
            this.showValidationStatus(status);
        }
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            List<String> currentValues = this.getCurrentValues();
            if (currentValues.containsAll(structuredSelection.toList()) && structuredSelection.toList().containsAll(currentValues)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            Iterator iterator = structuredSelection.toList().iterator();
            while (iterator.hasNext()) {
                buffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                buffer.append(DEFAULT_SEPARATOR);
                buffer.append(" ");
            }
            this.fText.setText(buffer.toString());
        }
    }

    private void installListeners() {
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TextControl.this.isInputValid()) {
                    TextControl.this.notifySelectionChanged((ISelection)new StructuredSelection(TextControl.this.getCurrentValues()));
                } else {
                    TextControl.this.notifySelectionChanged((ISelection)StructuredSelection.EMPTY);
                }
            }
        });
    }

    private List<String> getCurrentValues() {
        return this.getValues(this.fText.getText());
    }

    private List<String> getValues(String text) {
        String[] rawValues;
        if (!this.fMultiSelection) {
            String trimmed = text.trim();
            return trimmed.length() > 0 ? Collections.singletonList(trimmed) : Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>();
        String[] stringArray = rawValues = text.split(DEFAULT_SEPARATOR);
        int n = rawValues.length;
        int n2 = 0;
        while (n2 < n) {
            String rawValue = stringArray[n2];
            String trimmed = rawValue.trim();
            if (trimmed.length() > 0) {
                values.add(trimmed);
            }
            ++n2;
        }
        return values;
    }

    private IStatus validate(String text) {
        List<String> currentValues = this.getValues(text);
        for (String value : currentValues) {
            IStatus status = this.fValidator.validate(value);
            if (status.isOK()) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    public void showValidationStatus(IStatus status) {
        if (status.isOK()) {
            this.fControlDecoration.hide();
        } else {
            String fieldDecorationId = this.getDecorationId(status);
            FieldDecoration decoration = FieldDecorationRegistry.getDefault().getFieldDecoration(fieldDecorationId);
            this.fControlDecoration.setDescriptionText(status.getMessage());
            this.fControlDecoration.setImage(decoration.getImage());
            this.fControlDecoration.show();
        }
    }

    private String getDecorationId(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return "DEC_ERROR";
            }
            case 2: {
                return "DEC_WARNING";
            }
            case 1: {
                return "DEC_INFORMATION";
            }
        }
        return "DEC_INFORMATION";
    }

    private Object[] getInputValues(Object input) {
        if (input instanceof Object[]) {
            return (Object[])input;
        }
        if (input instanceof Collection) {
            return ((Collection)input).toArray();
        }
        return new Object[0];
    }

    private String[] createLabels(Object[] elements) {
        ArrayList<String> labels = new ArrayList<String>(elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String label;
            Object object = objectArray[n2];
            if (object != null && (label = object.toString()).length() > 0) {
                labels.add(label);
            }
            ++n2;
        }
        Collections.sort(labels, Collator.getInstance());
        return labels.toArray(new String[labels.size()]);
    }

    public void setFocus() {
        if (this.fText != null) {
            this.fText.setFocus();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Options {
        VERIFY_STRICT,
        VERIFY_WARN;

    }
}

