/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.control;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.AbstractConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Slider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SliderConditionControl<T extends Number>
extends AbstractConditionControl {
    private static final int FLOAT_SCALE = 100;
    private SelectionListener fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            SliderConditionControl.this.handleSelectionChange();
        }
    };
    private Slider fSlider;
    private Label fValueLabel;
    private Label fStartLabel;
    private Label fEndLabel;
    private final Type fType;
    private T fRangeStart;
    private T fRangeEnd;
    private String fStartLabelText;
    private String fEndLabelText;

    public SliderConditionControl(Type type, T rangeStart, T rangeEnd) {
        Assert.isNotNull((Object)((Object)type));
        Assert.isNotNull(rangeStart);
        Assert.isNotNull(rangeEnd);
        Assert.isLegal((((Number)rangeStart).floatValue() < ((Number)rangeEnd).floatValue() ? 1 : 0) != 0);
        this.fType = type;
        this.fRangeStart = rangeStart;
        this.fRangeEnd = rangeEnd;
    }

    @Override
    public void createContent(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(parent);
        this.fValueLabel = this.getSite().getToolkit().createLabel(parent, this.getValueText(null));
        this.fStartLabel = this.getSite().getToolkit().createLabel(parent, this.getStartLabelText());
        this.fSlider = new Slider(parent, 256);
        this.fSlider.setValues(this.getMinimum() + this.getMaximum() / 2, this.getMinimum(), this.getMaximum() + 1, 1, 1, 1);
        this.fSlider.addSelectionListener(this.fSelectionListener);
        this.fEndLabel = this.getSite().getToolkit().createLabel(parent, this.getEndLabelText());
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.fValueLabel);
        GridDataFactory.swtDefaults().applyTo((Control)this.fStartLabel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fSlider);
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.fEndLabel);
    }

    private String getValueText(Number number) {
        if (number == null) {
            return Messages.SliderConditionControl_NO_VALUE;
        }
        return NLS.bind((String)Messages.SliderConditionControl_SELECTED_VALUE_FORMAT, (Object)number, (Object[])new Object[0]);
    }

    private int getMinimum() {
        if (this.fType == Type.FLOAT) {
            return 0;
        }
        return ((Number)this.fRangeStart).intValue();
    }

    private int getMaximum() {
        if (this.fType == Type.FLOAT) {
            return 100;
        }
        return ((Number)this.fRangeEnd).intValue();
    }

    private void updateValueLabel(Number value) {
        this.fValueLabel.setText(this.getValueText(value));
    }

    public void setSelection(ISelection selection) {
        Object element;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof Number) {
            Number number = (Number)element;
            int value = this.getInternalValue(number);
            this.fSlider.setSelection(value);
            this.updateValueLabel(number);
        }
    }

    private int getInternalValue(Number number) {
        switch (this.fType) {
            case INTEGER: {
                return number.intValue();
            }
            case LONG: {
                return number.intValue();
            }
            case FLOAT: {
                Math.round((number.floatValue() - ((Number)this.fRangeStart).floatValue() / ((Number)this.fRangeEnd).floatValue() - ((Number)this.fRangeStart).floatValue()) * 100.0f);
            }
        }
        return 0;
    }

    private Number getExternalValue(int number) {
        switch (this.fType) {
            case INTEGER: {
                return new Integer(number);
            }
            case LONG: {
                return new Long(number);
            }
            case FLOAT: {
                return new Float(((Number)this.fRangeStart).floatValue() + (((Number)this.fRangeEnd).floatValue() - ((Number)this.fRangeStart).floatValue()) * (float)number / 100.0f);
            }
        }
        return null;
    }

    private void handleSelectionChange() {
        Number value = this.getExternalValue(this.fSlider.getSelection());
        this.updateValueLabel(value);
        if (value != null) {
            this.notifySelectionChanged((ISelection)new StructuredSelection((Object)value));
        }
    }

    @Override
    public void setFocus() {
        if (this.fSlider != null) {
            this.fSlider.setFocus();
        }
    }

    @Override
    protected void inputChanged(Object input) {
    }

    public String getStartLabelText() {
        if (this.fStartLabelText != null) {
            return this.fStartLabelText;
        }
        return this.fRangeStart.toString();
    }

    public void setStartLabelText(String startLabelText) {
        this.fStartLabelText = startLabelText;
        if (this.fStartLabel != null) {
            this.fStartLabel.setText(this.getStartLabelText());
        }
    }

    public String getEndLabelText() {
        if (this.fEndLabelText != null) {
            return this.fEndLabelText;
        }
        return this.fRangeEnd.toString();
    }

    public void setEndLabelText(String endLabelText) {
        this.fEndLabelText = endLabelText;
        if (this.fEndLabel != null) {
            this.fEndLabel.setText(this.getEndLabelText());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INTEGER,
        LONG,
        FLOAT;

    }
}

