/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.control;

import com.ibm.team.workitem.common.internal.util.FileSize;
import com.ibm.team.workitem.common.internal.util.FileSizeFormat;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.AbstractConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IValidator;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.TextControl;
import java.text.ParseException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FileSizeConditionControl
extends AbstractConditionControl {
    private FileSizeFormat fFormat = null;
    private TextControl fTextField;

    public void createContent(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.fTextField = new TextControl(parent, 0x804 | ("carbon".equals(SWT.getPlatform()) ? 16384 : 131072));
        this.fTextField.useMultiSelection(false);
        this.fTextField.setValidator(new IValidator(){

            public IStatus validate(Object object) {
                String string = (String)object;
                try {
                    FileSizeConditionControl.this.getFileSizeFormat().parse(string);
                }
                catch (ParseException exception) {
                    return new Status(4, "com.ibm.team.workitem.ide.ui", exception.getLocalizedMessage());
                }
                return Status.OK_STATUS;
            }
        }, TextControl.Options.VERIFY_WARN);
        this.fTextField.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FileSizeConditionControl.this.handleSelectionChanged(event.getSelection());
            }
        });
    }

    public void setFocus() {
        this.fTextField.setFocus();
    }

    public void setSelection(ISelection selection) {
        IStructuredSelection structured;
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).getFirstElement() instanceof Number) {
            Number number = (Number)structured.getFirstElement();
            this.setFileSize(new FileSize(number.longValue()));
        }
    }

    protected void inputChanged(Object input) {
    }

    private void handleSelectionChanged(ISelection selection) {
        if (!selection.isEmpty()) {
            try {
                FileSize fileSize = this.getFileSize(selection);
                if (fileSize != null) {
                    this.notifySelectionChanged((ISelection)new StructuredSelection((Object)fileSize.longValue()));
                }
            }
            catch (ParseException parseException) {}
            return;
        }
        this.notifySelectionChanged(selection);
    }

    private void setFileSize(FileSize fileSize) {
        Assert.isNotNull((Object)fileSize);
        String formatted = this.getFileSizeFormat().format(fileSize);
        this.fTextField.setSelection((ISelection)new StructuredSelection((Object)formatted));
    }

    private FileSize getFileSize(ISelection sel) throws ParseException {
        IStructuredSelection selection = (IStructuredSelection)sel;
        String element = (String)selection.getFirstElement();
        if (element != null) {
            return this.getFileSizeFormat().parse(element);
        }
        return null;
    }

    private FileSizeFormat getFileSizeFormat() {
        if (this.fFormat == null) {
            this.fFormat = FileSizeFormat.getInstance();
        }
        return this.fFormat;
    }
}

