/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.control;

import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.AbstractConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.DatePickerControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.RelativeDatePickerControl;
import java.sql.Timestamp;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.PageBook;

public class DateConditionControl
extends AbstractConditionControl {
    private ISelectionChangedListener fDelegateSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            DateConditionControl.this.notifySelectionChanged(event.getSelection());
        }
    };
    private PageBook fPageBook;
    private DatePickerPage fDatePickerPage;
    private RelativeDatePickerPage fRelativeDatePickerPage;
    private DatePage fCurrentPage;
    private Button fPickerRadio;
    private Button fRelativeRadio;
    private boolean fAllowFutureVariables = true;

    public void setAllowFutureVariables(boolean allow) {
        this.fAllowFutureVariables = allow;
        if (this.fRelativeDatePickerPage != null) {
            this.fRelativeDatePickerPage.getControl().setAllowFutureVariables(this.fAllowFutureVariables);
        }
    }

    public void createContent(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        FormToolkit toolkit = this.getSite().getToolkit();
        this.fPageBook = new PageBook(parent, 0);
        toolkit.adapt((Composite)this.fPageBook);
        this.fPageBook.setBackground(null);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.fPageBook);
        this.fDatePickerPage = new DatePickerPage(this.fPageBook, toolkit);
        this.fRelativeDatePickerPage = new RelativeDatePickerPage(this.fPageBook, toolkit);
        this.fRelativeDatePickerPage.getControl().setAllowFutureVariables(this.fAllowFutureVariables);
        this.fPickerRadio = new Button(parent, 16);
        this.fPickerRadio.setText(Messages.DateConditionControl_SPECIFIC_DATE_LABEL);
        this.fPickerRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DateConditionControl.this.fPickerRadio.getSelection()) {
                    DateConditionControl.this.showDatePicker(DateConditionControl.this.fDatePickerPage.getSelectionProvider().getSelection());
                }
            }
        });
        this.fRelativeRadio = new Button(parent, 16);
        this.fRelativeRadio.setText(Messages.DateConditionControl_RELATIVE_DATE_LABEL);
        this.fRelativeRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DateConditionControl.this.fRelativeRadio.getSelection()) {
                    DateConditionControl.this.showRelativeDatePicker(DateConditionControl.this.fRelativeDatePickerPage.getSelectionProvider().getSelection());
                }
            }
        });
        this.showDefaultPage();
    }

    public void setFocus() {
        if (this.fCurrentPage != null) {
            this.fCurrentPage.setFocus();
        }
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.isEmpty()) {
                this.showDefaultPage();
            } else if (structuredSelection.getFirstElement() instanceof IAttributeVariable) {
                this.showRelativeDatePicker((ISelection)structuredSelection);
                this.fRelativeRadio.setSelection(true);
                this.fPickerRadio.setSelection(false);
            } else if (structuredSelection.getFirstElement() instanceof Timestamp) {
                this.showDatePicker((ISelection)structuredSelection);
                this.fPickerRadio.setSelection(true);
                this.fRelativeRadio.setSelection(false);
            }
        }
    }

    private void showDefaultPage() {
        this.showRelativeDatePicker((ISelection)StructuredSelection.EMPTY);
        this.fRelativeRadio.setSelection(true);
    }

    private void showRelativeDatePicker(ISelection initialSelection) {
        this.fDatePickerPage.getSelectionProvider().removeSelectionChangedListener(this.fDelegateSelectionChangedListener);
        this.fRelativeDatePickerPage.getSelectionProvider().addSelectionChangedListener(this.fDelegateSelectionChangedListener);
        this.fRelativeDatePickerPage.getSelectionProvider().setSelection(initialSelection);
        this.fPageBook.showPage((Control)this.fRelativeDatePickerPage.getPage());
        this.fCurrentPage = this.fRelativeDatePickerPage;
        this.fCurrentPage.setFocus();
        this.notifySelectionChanged(initialSelection);
    }

    private void showDatePicker(ISelection initialSelection) {
        this.fRelativeDatePickerPage.getSelectionProvider().removeSelectionChangedListener(this.fDelegateSelectionChangedListener);
        this.fDatePickerPage.getSelectionProvider().addSelectionChangedListener(this.fDelegateSelectionChangedListener);
        this.fDatePickerPage.getSelectionProvider().setSelection(initialSelection);
        this.fPageBook.showPage((Control)this.fDatePickerPage.getPage());
        this.fCurrentPage = this.fDatePickerPage;
        this.fCurrentPage.setFocus();
        this.notifySelectionChanged(initialSelection);
    }

    protected void inputChanged(Object input) {
    }

    private static abstract class DatePage {
        private DatePage() {
        }

        public abstract Composite getPage();

        public abstract ISelectionProvider getSelectionProvider();

        public abstract void setFocus();
    }

    private class DatePickerPage
    extends DatePage {
        private Composite fPage;
        private DatePickerControl fDatePicker;

        public DatePickerPage(PageBook parent, FormToolkit toolkit) {
            this.fPage = toolkit.createComposite((Composite)parent);
            this.fPage.setBackground(null);
            GridLayoutFactory.fillDefaults().applyTo(this.fPage);
            this.fDatePicker = new DatePickerControl(this.fPage, 2);
            this.fDatePicker.adapt(toolkit);
        }

        public Composite getPage() {
            return this.fPage;
        }

        public ISelectionProvider getSelectionProvider() {
            return this.fDatePicker;
        }

        public void setFocus() {
            this.fDatePicker.setFocus();
        }
    }

    private class RelativeDatePickerPage
    extends DatePage {
        private Composite fPage;
        private RelativeDatePickerControl fDatePicker;

        public RelativeDatePickerPage(PageBook parent, FormToolkit toolkit) {
            this.fPage = toolkit.createComposite((Composite)parent);
            this.fPage.setBackground(null);
            GridLayoutFactory.fillDefaults().applyTo(this.fPage);
            this.fDatePicker = new RelativeDatePickerControl(this.fPage);
            this.fDatePicker.adapt(toolkit);
        }

        public Composite getPage() {
            return this.fPage;
        }

        public ISelectionProvider getSelectionProvider() {
            return this.fDatePicker;
        }

        public void setFocus() {
            this.fDatePicker.setFocus();
        }

        public RelativeDatePickerControl getControl() {
            return this.fDatePicker;
        }
    }
}

