/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.control;

import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.AbstractSelectionProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.ConditionControlInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IConditionControlSite;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IInputProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IValueConverter;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.util.ConvertingValueSelectionProvider;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConditionControl
extends AbstractSelectionProvider
implements IConditionControl {
    private UIUpdaterJob fRefreshJob = new UIUpdaterJob(Messages.AbstractConditionControl_INITIALIZING_INPUT){
        private Object fResolvedInput;
        private IStatus fStatus;

        public IStatus runInBackground(IProgressMonitor monitor) {
            try {
                this.fResolvedInput = AbstractConditionControl.this.fInputProvider.createInput(AbstractConditionControl.this.fInput.getProjectArea(), AbstractConditionControl.this.fInput.getValues(), monitor);
                this.fStatus = Status.OK_STATUS;
                return this.fStatus;
            }
            catch (TeamRepositoryException e) {
                this.fStatus = new Status(4, "com.ibm.team.workitem.ide.ui", Messages.AbstractConditionControl_LOADING_INPUT_ERROR, (Throwable)e);
                WorkItemIDEUIPlugin.getDefault().log(this.fStatus);
                return Status.OK_STATUS;
            }
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            if (!AbstractConditionControl.this.fSite.isDisposed()) {
                if (this.fStatus.isOK()) {
                    AbstractConditionControl.this.fSite.showStatusText("");
                    AbstractConditionControl.this.inputChanged(this.fResolvedInput);
                    if (AbstractConditionControl.this.fSelectionProvider != null) {
                        AbstractConditionControl.this.restoreLastSelection(AbstractConditionControl.this.fSelectionProvider.getLastSelection(true));
                    }
                } else {
                    AbstractConditionControl.this.fSite.showStatusText(this.fStatus.getMessage());
                }
            }
            return super.runInUI(monitor);
        }
    };
    private ConvertingValueSelectionProvider fSelectionProvider;
    private IInputProvider fInputProvider;
    private IValueConverter fConverter;
    private ConditionControlInput fInput;
    private IConditionControlSite fSite;

    @Override
    public void init(IConditionControlSite site) {
        this.fSite = site;
    }

    public void setInputProvider(IInputProvider provider) {
        this.fInputProvider = provider;
    }

    public void setConverter(IValueConverter converter) {
        this.fConverter = converter;
        if (this.fSelectionProvider != null) {
            this.fSelectionProvider.setValueConverter(converter);
        }
    }

    @Override
    public void setInput(ConditionControlInput input) {
        this.fInput = input;
        if (this.fInputProvider != null) {
            this.refreshInput();
        } else {
            this.inputChanged(input);
        }
    }

    protected ConditionControlInput getInput() {
        return this.fInput;
    }

    private void refreshInput() {
        if (this.fInputProvider != null) {
            this.fSite.showStatusText(Messages.AbstractConditionControl_LOADING_INPUT_MESSAGE);
            this.fRefreshJob.schedule();
        }
    }

    protected boolean hasInputProvider() {
        return this.fInputProvider != null;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        if (this.fSelectionProvider == null) {
            this.fSelectionProvider = new ConvertingValueSelectionProvider(this);
            this.fSelectionProvider.setValueConverter(this.fConverter);
        }
        return this.fSelectionProvider;
    }

    protected IConditionControlSite getSite() {
        return this.fSite;
    }

    protected void restoreLastSelection(ISelection selection) {
        this.setSelection(selection);
    }

    protected abstract void inputChanged(Object var1);

    @Override
    public AttributeOperation validateOperator(AttributeOperation currentOperator, Collection<Object> values) {
        return null;
    }
}

