/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions;

import com.ibm.team.ui.editor.TeamFormPage;
import com.ibm.team.workitem.common.internal.util.FactoryMap;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryConditionsPage;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryDetailsPage;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorLayoutFactories;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryResultLayoutPage;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.IQueryEditorLayoutFactory;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class QueryEditorPages {
    public static final String CONDITIONS = "com.ibm.team.workitem.query.editor.page.conditions";
    public static final String DETAILS = "com.ibm.team.workitem.query.editor.page.details";
    public static final String RESULT_LAYOUT = "com.ibm.team.workitem.query.editor.page.resultLayout";
    public static final int HORIZONTAL_GAP = 10;
    public static final int VERTICAL_GAP = 10;
    public static final int MARGIN_HEIGHT = 10;
    public static final int MARGIN_WIDTH = 10;
    private static final QueryEditorPages fgInstance = new QueryEditorPages();
    private FactoryMap<TeamFormPage> fPages = new FactoryMap();

    public static QueryEditorPages getInstance() {
        return fgInstance;
    }

    private QueryEditorPages() {
        this.fPages.put(CONDITIONS, QueryConditionsPage.class);
        this.fPages.put(DETAILS, QueryDetailsPage.class);
        this.fPages.put(RESULT_LAYOUT, QueryResultLayoutPage.class);
    }

    public IEditorPart createPage(String id) {
        return (IEditorPart)this.fPages.create(id);
    }

    public static IQueryEditorLayoutFactory getLayoutFactory(IEditorInput input) {
        if (input instanceof QueryEditorInput) {
            QueryEditorInput queryEditorInput = (QueryEditorInput)input;
            IQueryDescriptor descriptor = queryEditorInput.getWorkingCopy().getQueryDescriptor();
            return QueryEditorLayoutFactories.getInstance().getFactory(descriptor);
        }
        return null;
    }
}

