/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions;

import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.query.presentations.IControlPresentationDescriptor;
import com.ibm.team.workitem.common.internal.query.presentations.PresentationBindingRegistries;
import com.ibm.team.workitem.common.internal.query.presentations.QueryEditorPresentation;
import com.ibm.team.workitem.common.query.IQueryType;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.IDefaultQueryEditorControlFactory;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.IQueryEditorControlFactory;

public class ControlPresentationBindingRegistry {
    private static ControlPresentationBindingRegistry fgInstance = null;
    private final PresentationBindingRegistries.PresentationBindingRegistry fRegistry = PresentationBindingRegistries.createRegistry((String)"com.ibm.team.workitem.ide.ui");

    public static ControlPresentationBindingRegistry getInstance() {
        if (fgInstance == null) {
            fgInstance = new ControlPresentationBindingRegistry();
        }
        return fgInstance;
    }

    public void stop() {
        this.fRegistry.stop();
    }

    public boolean hasBinding(String presentationIdentifier) {
        return this.fRegistry.hasBinding(presentationIdentifier);
    }

    public IQueryEditorControlFactory getBinding(IQueryableAttribute attribute, QueryEditorPresentation presentation) {
        IQueryEditorControlFactory factory;
        IControlPresentationDescriptor descriptor = presentation.getControlPresentationDescriptor(attribute);
        if (descriptor.getPresentationIdentifier() != null && (factory = (IQueryEditorControlFactory)this.fRegistry.getBinding(descriptor.getPresentationIdentifier())) != null) {
            return factory;
        }
        factory = this.getDefaultFactory(presentation.getQueryType(), descriptor);
        return factory;
    }

    private IDefaultQueryEditorControlFactory getDefaultFactory(IQueryType type, IControlPresentationDescriptor descriptor) {
        IDefaultQueryEditorControlFactory factory = (IDefaultQueryEditorControlFactory)this.fRegistry.getDefaultBinding(type);
        if (factory != null && factory.supports(descriptor)) {
            return factory;
        }
        factory = (IDefaultQueryEditorControlFactory)this.fRegistry.getDefaultBinding(type.getQueryItemType());
        if (factory != null && factory.supports(descriptor)) {
            return factory;
        }
        factory = (IDefaultQueryEditorControlFactory)this.fRegistry.getDefaultBinding();
        if (factory != null && factory.supports(descriptor)) {
            return factory;
        }
        return null;
    }
}

