/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.actions;

import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.internal.expression.EditableTerm;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorConfiguration;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.actions.AddAttributeConditionAction;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.actions.Messages;
import com.ibm.team.workitem.rcp.ui.internal.queries.QueryableAttributeLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.queries.QueryableAttributeSelectionDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class SelectAttributeConditionAction
extends Action {
    private ISelectionStatusValidator fValidator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            ArrayList<IQueryableAttribute> unsupported = new ArrayList<IQueryableAttribute>();
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                IQueryableAttribute attribute;
                Object object = objectArray[n2];
                if (object instanceof IQueryableAttribute && !SelectAttributeConditionAction.this.isSupported(attribute = (IQueryableAttribute)object)) {
                    unsupported.add(attribute);
                }
                ++n2;
            }
            return this.createStatus(unsupported, selection.length);
        }

        private IStatus createStatus(List<IQueryableAttribute> unsupported, int selectionSize) {
            if (unsupported.isEmpty()) {
                return this.createStatus(0, "");
            }
            if (unsupported.size() == selectionSize) {
                return this.createStatus(4, Messages.SelectAttributeConditionAction_SUBATTRIBUTES_ONLY);
            }
            return this.createStatus(2, Messages.SelectAttributeConditionAction_PARTS_IGNORED);
        }

        private IStatus createStatus(int status, String message) {
            return new Status(status, "com.ibm.team.workitem.ide.ui", message, null);
        }
    };
    private ViewerFilter fFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IQueryableAttribute) {
                IQueryableAttribute attribute = (IQueryableAttribute)element;
                return SelectAttributeConditionAction.this.isSupported(attribute) || !attribute.getChildAttributes().isEmpty();
            }
            return true;
        }
    };
    private final Shell fShell;
    private final EditableTerm fTerm;
    private final EditableExpression fAfterExpression;
    private final QueryEditorConfiguration fConfiguration;

    public SelectAttributeConditionAction(Shell shell, EditableTerm term, EditableExpression after, QueryEditorConfiguration configuration) {
        this.fShell = shell;
        this.fTerm = term;
        this.fAfterExpression = after;
        this.fConfiguration = configuration;
        this.setText(Messages.SelectAttributeConditionAction_ADD_CONDITIONS_LABEL);
    }

    public void run() {
        QueryableAttributeSelectionDialog dialog = new QueryableAttributeSelectionDialog(this.fShell, (ILabelProvider)new CustomAttributeLabelProvider());
        dialog.setTitle(this.getText());
        dialog.setMessage(Messages.SelectAttributeConditionAction_CHOOSE_ATTRIBUTES);
        dialog.setInput(this.fConfiguration.getAttributes());
        dialog.setValidator(this.fValidator);
        dialog.addFilter(this.fFilter);
        dialog.setStatusLineAboveButtons(true);
        if (dialog.open() == 0) {
            ArrayList<IQueryableAttribute> filtered = new ArrayList<IQueryableAttribute>();
            for (IQueryableAttribute selected : dialog.getSelectedAttributes()) {
                if (!this.isSupported(selected)) continue;
                filtered.add(selected);
            }
            if (this.fAfterExpression != null) {
                Collections.reverse(filtered);
            }
            for (IQueryableAttribute attribute : filtered) {
                AddAttributeConditionAction action = new AddAttributeConditionAction(attribute, this.fTerm, this.fAfterExpression);
                action.run();
            }
        }
    }

    private boolean isSupported(IQueryableAttribute attribute) {
        return this.fConfiguration.supports(attribute);
    }

    private class CustomAttributeLabelProvider
    extends QueryableAttributeLabelProvider {
        private CustomAttributeLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            super.updateLabel(label, element);
            label.setForeground(this.getForeground(this.getQueryableAttribute(element)));
        }

        public Color getForeground(IQueryableAttribute attribute) {
            if (attribute != null && !SelectAttributeConditionAction.this.isSupported(attribute)) {
                return Display.getCurrent().getSystemColor(16);
            }
            return null;
        }
    }
}

