/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.ExpressionChangeEvent;
import com.ibm.team.workitem.common.expression.IExpressionListener;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.StatementChangeEvent;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.internal.expression.EditableAttributeExpression;
import com.ibm.team.workitem.common.internal.expression.EditableExpression;
import com.ibm.team.workitem.common.internal.expression.EditableStatement;
import com.ibm.team.workitem.common.internal.expression.EditableTerm;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorInput;
import org.eclipse.jface.internal.databinding.provisional.viewers.ViewerLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class QueryOutlinePage
extends ContentOutlinePage {
    private QueryEditorInput fInput;

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setContentProvider((IContentProvider)new ExpressionContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new ExpressionLabelProvider());
        this.getTreeViewer().setAutoExpandLevel(-1);
        this.doSetInput();
    }

    public void setInput(IEditorInput editorInput) {
        this.fInput = editorInput instanceof QueryEditorInput ? (QueryEditorInput)editorInput : null;
        this.doSetInput();
    }

    private void doSetInput() {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().setInput(this.fInput != null ? this.fInput.getWorkingCopy().getEditableStatement() : null);
        }
    }

    private static class ExpressionContentProvider
    implements ITreeContentProvider,
    IExpressionListener {
        private static final Object[] EMPTY = new Object[0];
        private TreeViewer fViewer;

        private ExpressionContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof EditableStatement) {
                EditableStatement statement = (EditableStatement)parentElement;
                return new Object[]{statement.getRoot()};
            }
            if (parentElement instanceof EditableTerm) {
                return ((EditableTerm)parentElement).getExpressions().toArray();
            }
            if (parentElement instanceof EditableAttributeExpression) {
                EditableAttributeExpression expression = (EditableAttributeExpression)parentElement;
                return expression.getValues().toArray();
            }
            return EMPTY;
        }

        public Object getParent(Object element) {
            if (element instanceof EditableExpression) {
                return ((EditableExpression)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof EditableAttributeExpression) {
                return ((EditableAttributeExpression)element).getValues().size() > 0;
            }
            if (element instanceof EditableTerm) {
                return !((EditableTerm)element).getExpressions().isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fViewer = (TreeViewer)viewer;
            if (oldInput instanceof EditableStatement) {
                this.removeListeners((EditableStatement)oldInput);
            }
            if (newInput instanceof EditableStatement) {
                this.installListeners((EditableStatement)newInput);
            }
        }

        private void installListeners(EditableStatement newInput) {
            newInput.addListener((IExpressionListener)this);
        }

        private void removeListeners(EditableStatement oldInput) {
            oldInput.removeListener((IExpressionListener)this);
        }

        public void expressionChanged(ExpressionChangeEvent event) {
            switch (event.getType()) {
                case CONDITION_VALUE_CHANGED: {
                    this.fViewer.refresh((Object)event.getSource());
                    this.fViewer.expandToLevel((Object)event.getSource(), -1);
                    break;
                }
                case CONDITION_ATTRIBUTE_CHANGED: 
                case CONDITION_OPERATOR_CHANGED: {
                    this.fViewer.update((Object)event.getSource(), null);
                    break;
                }
                case TERM_CLEARED: {
                    this.fViewer.refresh((Object)event.getSource());
                    break;
                }
                case TERM_CONDITION_ADDED: {
                    this.fViewer.add((Object)event.getSource(), (Object)event.getExpression());
                    this.fViewer.expandToLevel((Object)event.getSource(), -1);
                    break;
                }
                case TERM_CONDITION_REMOVED: {
                    this.fViewer.remove((Object)event.getExpression());
                    break;
                }
                case TERM_OPERATOR_CHANGED: {
                    this.fViewer.update((Object)event.getSource(), null);
                }
            }
        }

        public void statementChanged(StatementChangeEvent event) {
        }
    }

    private static class ExpressionLabelProvider
    extends ViewerLabelProvider {
        private ExpressionLabelProvider() {
        }

        public void updateLabel(ViewerLabel viewerLabel, Object element) {
            if (element == null) {
                viewerLabel.setText(Messages.QueryOutlinePage_UNASSIGNED_LABEL);
                return;
            }
            Label[] labelArray = Label.values();
            int n = labelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Label label = labelArray[n2];
                if (label.getElementClass().isAssignableFrom(element.getClass())) {
                    label.update(viewerLabel, element);
                    return;
                }
                ++n2;
            }
            super.updateLabel(viewerLabel, element);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Label {
            TERM_LABEL((Class)EditableTerm.class){

                void update(ViewerLabel label, Object element) {
                    EditableTerm term = (EditableTerm)element;
                    label.setText(term.getOperator().getLabel());
                }
            }
            ,
            ATTRIBUTE_LABEL((Class)IQueryableAttribute.class){

                void update(ViewerLabel label, Object element) {
                    IQueryableAttribute attribute = (IQueryableAttribute)element;
                    label.setText(attribute.getDisplayName());
                }
            }
            ,
            OPERATOR_LABEL((Class)AttributeOperation.class){

                void update(ViewerLabel label, Object element) {
                    AttributeOperation operator = (AttributeOperation)element;
                    label.setText(operator.getDisplayName());
                }
            }
            ,
            ATTRIBUTE_EXPRESSION_LABEL((Class)EditableAttributeExpression.class){

                void update(ViewerLabel label, Object element) {
                    EditableAttributeExpression expression = (EditableAttributeExpression)element;
                    label.setText(NLS.bind((String)Messages.QueryOutlinePage_ATTRIBUTE_LABEL_FORMAT, (Object)expression.getAttribute().getDisplayName(), (Object[])new Object[]{expression.getOperator().getDisplayName()}));
                }
            }
            ,
            VARIABLE_LABEL((Class)IAttributeVariable.class){

                void update(ViewerLabel label, Object element) {
                    IAttributeVariable variable = (IAttributeVariable)element;
                    label.setText(variable.getDisplayName());
                }
            };

            private Class<?> fElementClass;

            private Label(Class<?> elementClass) {
                this.fElementClass = elementClass;
            }

            Class<?> getElementClass() {
                return this.fElementClass;
            }

            abstract void update(ViewerLabel var1, Object var2);
        }
    }
}

