/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor;

import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.IQueryEditorLayoutFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IPluginContribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEditorLayoutFactories {
    public static final String QUERY_EDITOR_LAYOUT_EXTENSION_POINT = "queryEditorLayouts";
    private static QueryEditorLayoutFactories fgFactories;
    private List<FactoryProxy> fFactoryProxies;

    public static QueryEditorLayoutFactories getInstance() {
        if (fgFactories == null) {
            fgFactories = new QueryEditorLayoutFactories();
        }
        return fgFactories;
    }

    private QueryEditorLayoutFactories() {
    }

    public IQueryEditorLayoutFactory getFactory(IQueryDescriptor queryDescriptor) {
        List<FactoryProxy> proxies = this.getFactoryProxies();
        for (FactoryProxy factoryProxy : proxies) {
            if (!factoryProxy.handles(queryDescriptor)) continue;
            return factoryProxy.getFactory();
        }
        return null;
    }

    private List<FactoryProxy> getFactoryProxies() {
        if (this.fFactoryProxies == null) {
            this.fFactoryProxies = this.createFactoryProxies();
        }
        return this.fFactoryProxies;
    }

    private List<FactoryProxy> createFactoryProxies() {
        IConfigurationElement[] elements;
        ArrayList<FactoryProxy> factoryProxies = new ArrayList<FactoryProxy>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.ibm.team.workitem.ide.ui", QUERY_EDITOR_LAYOUT_EXTENSION_POINT);
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            factoryProxies.add(new FactoryProxy(configurationElement));
            ++n2;
        }
        return factoryProxies;
    }

    private static class FactoryProxy
    implements IPluginContribution {
        private static final String PROPERTY_CLASS = "class";
        private static final String PROPERTY_ID = "id";
        private final IConfigurationElement fConfigurationElement;
        private Expression fEnablementExpression;
        private IQueryEditorLayoutFactory fFactory;
        private String fId;

        public FactoryProxy(IConfigurationElement configurationElement) {
            Assert.isNotNull((Object)configurationElement);
            this.fConfigurationElement = configurationElement;
        }

        public boolean handles(IQueryDescriptor queryDescriptor) {
            try {
                EvaluationContext context = new EvaluationContext(null, (Object)queryDescriptor);
                EvaluationResult evaluationResult = this.getExpression().evaluate((IEvaluationContext)context);
                return evaluationResult != EvaluationResult.FALSE;
            }
            catch (CoreException e) {
                WorkItemIDEUIPlugin.getDefault().log(e.getStatus());
                return false;
            }
        }

        public IQueryEditorLayoutFactory getFactory() {
            if (this.fFactory == null) {
                this.fFactory = this.createFactory();
            }
            return this.fFactory;
        }

        private IQueryEditorLayoutFactory createFactory() {
            try {
                return (IQueryEditorLayoutFactory)this.fConfigurationElement.createExecutableExtension(PROPERTY_CLASS);
            }
            catch (CoreException e) {
                WorkItemIDEUIPlugin.getDefault().log(e.getStatus());
                return null;
            }
        }

        private Expression getExpression() throws CoreException {
            if (this.fEnablementExpression == null) {
                IConfigurationElement[] elements = this.fConfigurationElement.getChildren("enablement");
                this.fEnablementExpression = elements.length > 0 ? ExpressionConverter.getDefault().perform(elements[0]) : Expression.TRUE;
            }
            return this.fEnablementExpression;
        }

        public String getLocalId() {
            if (this.fId == null) {
                this.fId = this.fConfigurationElement.getAttribute(PROPERTY_ID);
            }
            return this.fId;
        }

        public String getPluginId() {
            return this.fConfigurationElement.getContributor().getName();
        }
    }
}

