/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.client.query.IQueryDescriptorWorkingCopy;
import com.ibm.team.workitem.client.query.IQueryDescriptorWorkingCopyManager;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.internal.expression.AbstractQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.EditableSortColumn;
import com.ibm.team.workitem.common.internal.query.QueryCommon;
import com.ibm.team.workitem.common.internal.query.presentations.QueryEditorPresentation;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.common.query.IQueryType;
import com.ibm.team.workitem.common.query.QueryTypeRegistry;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.AbstractItemEditorInputFuture;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorConfiguration;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorErrorInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorLayoutFactories;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.IQueryEditorLayoutFactory;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.internal.queries.QueriesManager;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryView;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryViewColumn;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeColumn;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeColumnFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.IEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEditorInputFuture
extends AbstractItemEditorInputFuture {
    IQueryDescriptorHandle fQueryDescriptorHandle;
    private int fOptions;

    public QueryEditorInputFuture(IQueryDescriptorHandle handle) {
        super((IItemHandle)handle);
        this.fQueryDescriptorHandle = handle;
        this.fOptions = 0;
    }

    @Override
    protected IEditorInput constructEditorInput(IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.QueryEditorInputFuture_RESOLVE_QUERY_JOB_NAME, 600);
            IQueryDescriptorWorkingCopyManager workingCopyManager = this.getClientLibrary(IQueryClient.class).getWorkingCopyManager();
            workingCopyManager.connect(this.fQueryDescriptorHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
            IQueryDescriptorWorkingCopy workingCopy = workingCopyManager.getWorkingCopy(this.fQueryDescriptorHandle);
            IQueryDescriptor queryDescriptor = workingCopy.getQueryDescriptor();
            if (queryDescriptor.isNewItem() && workingCopy.getEditableStatement().getRoot().getExpressions().isEmpty()) {
                IQueryEditorLayoutFactory factory = QueryEditorLayoutFactories.getInstance().getFactory(workingCopy.getQueryDescriptor());
                factory.initializeNewQuery(workingCopy, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            }
            List<IQueryableAttribute> attributes = this.findAttributes(queryDescriptor, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            List<IQueryableAttribute> columnAttributes = this.findColumnAttributes(queryDescriptor, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            Map<String, IQueryableAttribute> columnMap = this.createMap(columnAttributes);
            List<IQueryableAttribute> defaultColumns = this.findDefaultColumns(queryDescriptor, columnMap);
            List<EditableSortColumn> defaultSortColumns = this.findDefaultSortColumns(queryDescriptor, columnMap);
            QueryEditorPresentation presentation = this.findPresentation(queryDescriptor, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            QueryEditorConfiguration configuration = new QueryEditorConfiguration(presentation, attributes, columnAttributes, defaultColumns, defaultSortColumns, this.fOptions);
            QueryEditorInput queryEditorInput = new QueryEditorInput(workingCopy, configuration);
            return queryEditorInput;
        }
        catch (Exception e) {
            Status status = new Status(4, "com.ibm.team.workitem.ide.ui", Messages.QueryEditorInputFuture_RESOLVE_QUERY_ERROR, (Throwable)e);
            WorkItemIDEUIPlugin.getDefault().log((IStatus)status);
            QueryEditorErrorInput queryEditorErrorInput = new QueryEditorErrorInput((IItemHandle)this.fQueryDescriptorHandle, (IStatus)status);
            return queryEditorErrorInput;
        }
        finally {
            monitor.done();
        }
    }

    private Map<String, IQueryableAttribute> createMap(List<IQueryableAttribute> attributes) {
        HashMap<String, IQueryableAttribute> map = new HashMap<String, IQueryableAttribute>();
        for (IQueryableAttribute attribute : attributes) {
            map.put(attribute.getIdentifier(), attribute);
        }
        return map;
    }

    private QueryEditorPresentation findPresentation(IQueryDescriptor queryDescriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryType queryType = this.getQueryType(queryDescriptor);
        IQueryClient queryClient = (IQueryClient)ClientUtils.getClientLibrary((IItemHandle)queryDescriptor, IQueryClient.class);
        return ((QueryCommon)queryClient).findConfiguration(queryDescriptor.getProjectArea(), queryType, monitor);
    }

    private List<IQueryableAttribute> findAttributes(IQueryDescriptor queryDescriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryType queryType = this.getQueryType(queryDescriptor);
        List attributes = Collections.emptyList();
        IQueryableAttributeFactory factory = QueryableAttributes.getFactory((IItemType)queryType.getQueryItemType());
        if (factory != null) {
            IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)queryDescriptor, IAuditableClient.class);
            attributes = factory.findAllAttributes(queryDescriptor.getProjectArea(), (IAuditableCommon)auditableClient, monitor);
            Collections.sort(attributes, QueryableAttributes.createComparator());
            IWorkItemClient workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)queryDescriptor, IWorkItemClient.class);
            List workItemTypes = workItemClient.findWorkItemTypes(queryDescriptor.getProjectArea(), monitor);
            ItemHandleAwareHashSet configuredCustomAttributes = new ItemHandleAwareHashSet();
            for (IWorkItemType t : workItemTypes) {
                configuredCustomAttributes.addAll((Collection)t.getCustomAttributes());
            }
            List resolvedAttributes = auditableClient.resolveAuditables(configuredCustomAttributes.toList(), IAttribute.SMALL_PROFILE, monitor);
            HashSet<String> configuredAttributeIdentifiers = new HashSet<String>();
            configuredAttributeIdentifiers.add("com.ibm.team.apt.estimate.minimal");
            configuredAttributeIdentifiers.add("com.ibm.team.apt.estimate.maximal");
            for (IAttribute r : resolvedAttributes) {
                configuredAttributeIdentifiers.add(r.getIdentifier());
            }
            for (IQueryableAttribute attribute : attributes) {
                if (!attribute.isStateExtension() || configuredAttributeIdentifiers.contains(attribute.getIdentifier())) continue;
                ((AbstractQueryableAttribute)attribute).setArchived(true);
            }
        }
        return attributes;
    }

    private List<IQueryableAttribute> findColumnAttributes(IQueryDescriptor queryDescriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)queryDescriptor.getOrigin();
        AttributeColumnFactory columnFactory = AttributeColumnFactory.getInstance((ITeamRepository)repository, (IProjectAreaHandle)queryDescriptor.getProjectArea(), (IProgressMonitor)monitor);
        AttributeColumn[] columns = columnFactory.getColumns();
        ArrayList<IQueryableAttribute> columnAttributes = new ArrayList<IQueryableAttribute>(columns.length);
        AttributeColumn[] attributeColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeColumn attributeColumn = attributeColumnArray[n2];
            columnAttributes.add(attributeColumn.getAttribute());
            ++n2;
        }
        return columnAttributes;
    }

    private List<EditableSortColumn> findDefaultSortColumns(IQueryDescriptor queryDescriptor, Map<String, IQueryableAttribute> columnMap) {
        ArrayList<EditableSortColumn> defaultSortOrder = new ArrayList<EditableSortColumn>(1);
        ITeamRepository repository = (ITeamRepository)queryDescriptor.getOrigin();
        QueryView view = ClientModel.getQueriesManager().getView(repository, QueriesManager.DEFAULT_VIEW_ID);
        SortCriteria[] sortCriteriaArray = view.getSortCriteria();
        int n = sortCriteriaArray.length;
        int n2 = 0;
        while (n2 < n) {
            SortCriteria sc = sortCriteriaArray[n2];
            IQueryableAttribute columnAttribute = columnMap.get(sc.getAttributeIdentifier());
            if (columnAttribute != null) {
                EditableSortColumn column = new EditableSortColumn(columnAttribute, sc.isAscending() ? EditableSortColumn.Direction.ASCENDING : EditableSortColumn.Direction.DESCENDING);
                defaultSortOrder.add(column);
            }
            ++n2;
        }
        return defaultSortOrder;
    }

    private List<IQueryableAttribute> findDefaultColumns(IQueryDescriptor queryDescriptor, Map<String, IQueryableAttribute> columnMap) {
        ArrayList<IQueryableAttribute> defaultColumns = new ArrayList<IQueryableAttribute>();
        ITeamRepository repository = (ITeamRepository)queryDescriptor.getOrigin();
        QueryView view = ClientModel.getQueriesManager().getView(repository, QueriesManager.DEFAULT_VIEW_ID);
        QueryViewColumn[] queryViewColumnArray = view.getColumns();
        int n = queryViewColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            QueryViewColumn column = queryViewColumnArray[n2];
            IQueryableAttribute columnAttribute = columnMap.get(column.getAttributeIdentifier());
            if (columnAttribute != null) {
                defaultColumns.add(columnAttribute);
            }
            ++n2;
        }
        return defaultColumns;
    }

    private IQueryType getQueryType(IQueryDescriptor queryDescriptor) throws TeamRepositoryException {
        IQueryType queryType = QueryTypeRegistry.getQueryType((String)queryDescriptor.getQueryType());
        if (queryType == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.QueryEditorInputFuture_UNKNOWN_QUERY_TYPE, (Object)queryDescriptor.getQueryType(), (Object[])new Object[0]));
        }
        return queryType;
    }

    @Override
    public String getName() {
        return Messages.QueryEditorInputFuture_LOADING_MESSAGE;
    }

    @Override
    public String getTitle() {
        return Messages.QueryEditorInputFuture_DEFAULT_QUERY_NAME;
    }

    @Override
    protected boolean isEquivalentInputClass(Class<? extends Object> theClass) {
        return ((Object)((Object)this)).getClass().equals(theClass) || QueryEditorInput.class.equals(theClass);
    }

    private <T> T getClientLibrary(Class<T> clazz) {
        return (T)this.getRepository().getClientLibrary(clazz);
    }

    private ITeamRepository getRepository() {
        return (ITeamRepository)this.getItemHandle().getOrigin();
    }

    public void setOption(int option) {
        this.fOptions |= option;
    }
}

