/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.query.IQueryDescriptorWorkingCopy;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.common.query.IQueryType;
import com.ibm.team.workitem.common.query.QueryTypeRegistry;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.AbstractItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorConfiguration;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.QueryEditorInputFuture;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEditorInput
extends AbstractItemEditorInput {
    private final IQueryDescriptorWorkingCopy fWorkingCopy;
    private final QueryEditorConfiguration fConfiguration;

    public QueryEditorInput(IQueryDescriptorWorkingCopy workingCopy, QueryEditorConfiguration configuration) {
        super(workingCopy.getQueryDescriptor().getItemHandle());
        this.fWorkingCopy = workingCopy;
        this.fConfiguration = configuration;
    }

    public IQueryDescriptorWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        IQueryType queryType = QueryTypeRegistry.getQueryType((String)this.fWorkingCopy.getQueryDescriptor().getQueryType());
        return queryType != null ? WorkItemUI.getImageDescriptor((URL)queryType.getIconURL()) : ImagePool.UNKNOWN;
    }

    public String getName() {
        String name = this.fWorkingCopy.getQueryDescriptor().getName();
        if (name.length() == 0) {
            name = Messages.QueryEditorInput_UNTITLED_LABEL;
        }
        return name;
    }

    @Override
    public String getTitle() {
        IQueryType queryType = QueryTypeRegistry.getQueryType((String)this.fWorkingCopy.getQueryDescriptor().getQueryType());
        return queryType != null ? queryType.getDisplayName() : Messages.QueryEditorInput_DEFAULT_QUERY_NAME;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public QueryEditorConfiguration getConfiguration() {
        return this.fConfiguration;
    }

    public void release() {
        ITeamRepository repository = (ITeamRepository)this.fWorkingCopy.getQueryDescriptor().getOrigin();
        IQueryClient queryClient = (IQueryClient)repository.getClientLibrary(IQueryClient.class);
        queryClient.getWorkingCopyManager().disconnect((IQueryDescriptorHandle)this.fWorkingCopy.getQueryDescriptor());
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    protected boolean isEquivalentInputClass(Class<? extends Object> theClass) {
        return ((Object)((Object)this)).getClass().equals(theClass) || QueryEditorInputFuture.class.equals(theClass);
    }
}

