/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.processparticipants;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.runtime.IOperationParticipant;
import com.ibm.team.process.common.advice.runtime.IParticipantInfoCollector;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.processparticipants.Messages;
import com.ibm.team.workitem.rcp.core.queries.Query;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class QueryWorkItemsParticipant
implements IOperationParticipant {
    public void run(AdvisableOperation operation, IProcessConfigurationElement participantConfig, IParticipantInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.QueryWorkItemsParticipant_RUNNING_QUERY, 1000);
        try {
            IProcessArea area;
            ITeamRepository repo;
            IContributor contributor;
            Object data = operation.getOperationData();
            if (data instanceof IProcessArea && (contributor = (repo = (ITeamRepository)(area = (IProcessArea)data).getOrigin()).loggedInContributor()) != null) {
                IWorkItemClient client = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
                IAuditableClient auditableClient = (IAuditableClient)repo.getClientLibrary(IAuditableClient.class);
                IAttribute contributorAttribute = client.findAttribute(area.getProjectArea(), IWorkItem.OWNER_PROPERTY, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                IAttribute projectAreaAttribute = client.findAttribute(area.getProjectArea(), IWorkItem.PROJECT_AREA_PROPERTY, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                AttributeExpression contributorExpression = new AttributeExpression((IAuditableCommon)auditableClient, contributorAttribute, AttributeOperation.EQUALS, (Object)contributor);
                AttributeExpression projectAreaExpression = new AttributeExpression((IAuditableCommon)auditableClient, projectAreaAttribute, AttributeOperation.EQUALS, (Object)area.getProjectArea());
                Term expression = new Term(0, new Expression[]{contributorExpression, projectAreaExpression});
                final Query query = new Query(repo, Messages.QueryWorkItemsParticipant_ASSIGNED, (Expression)expression);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null) {
                            QueriesUI.showQueryResults((IWorkbenchWindow)window, (Query)query);
                        }
                    }
                });
            }
        }
        finally {
            monitor.done();
        }
    }
}

