/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.CollectionAwareAttributeMarkupPart;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.Messages;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkItemAttributeMarkupPart
extends CollectionAwareAttributeMarkupPart {
    protected void fillValueContent(Object value, MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        if (value instanceof IWorkItemHandle) {
            IWorkItemHandle handle = (IWorkItemHandle)value;
            IWorkItem workItem = (IWorkItem)this.getAuditableClient().resolveAuditable((IAuditableHandle)handle, IWorkItem.SMALL_PROFILE, monitor);
            URI uri = this.toURI((IItemHandle)workItem);
            String label = WorkItemTextUtilities.getWorkItemText((IWorkItem)workItem, (int)70);
            URL iconURL = this.getImageURL(workItem, monitor);
            if (iconURL != null) {
                builder.image(iconURL.toString(), label);
                builder.imageLink(iconURL.toString(), label);
            } else {
                builder.link(uri.toString(), label);
            }
        } else if (value != null) {
            builder.plain(value.toString());
        }
    }

    private URL getImageURL(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemType type = this.getWorkItemCommon().findWorkItemType(workItem.getProjectArea(), workItem.getWorkItemType(), monitor);
        if (type != null) {
            try {
                return JazzResources.createImageURL((URL)type.getIconURL());
            }
            catch (IOException e) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.EnumerationAttributeMarkupPart_ERROR_SAVING_TMP_IMG, e);
            }
        }
        return null;
    }
}

