/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.PresentationMarkupPart;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;

public class TeamAreaPresentationMarkupPart
extends PresentationMarkupPart {
    public void fillPartName(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessAreaHandle processArea;
        block4: {
            IWorkItemClient workItemClient = this.getWorkItemClient();
            processArea = null;
            try {
                processArea = workItemClient.findProcessArea((IWorkItemHandle)this.getItem(), monitor);
            }
            catch (TeamRepositoryException e) {
                if (e instanceof ItemNotFoundException || e instanceof PermissionDeniedException) break block4;
                throw e;
            }
        }
        if (processArea instanceof ITeamAreaHandle) {
            builder.plain(Messages.TeamAreaPresentationMarkupPart_TEAM_AREA);
        } else {
            builder.plain(Messages.TeamAreaPresentationMarkupPart_PROJECT_AREA);
        }
    }

    public void fillPartContent(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            this.internalFillPartContent(builder, monitor);
        }
        catch (TeamRepositoryException e) {
            this.handleException(builder, e);
        }
    }

    private void internalFillPartContent(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableClient auditableClient = this.getAuditableClient();
        IWorkItemClient workItemClient = this.getWorkItemClient();
        IProcessAreaHandle processArea = workItemClient.findProcessArea((IWorkItemHandle)this.getItem(), monitor);
        MarkupBuilder teamAreaBuilder = new MarkupBuilder();
        if (processArea instanceof ITeamAreaHandle) {
            ITeamArea teamArea = (ITeamArea)auditableClient.resolveAuditable((IAuditableHandle)processArea, ItemProfile.TEAM_AREA_DEFAULT, monitor);
            URI uri = this.toURI((IItemHandle)teamArea);
            teamAreaBuilder.link(uri.toString(), teamArea.getName());
        }
        MarkupBuilder projectAreaBuilder = new MarkupBuilder();
        IProjectAreaHandle projectAreaHandle = this.getItem().getProjectArea();
        IProjectArea projectArea = (IProjectArea)this.getAuditableCommon().resolveAuditable((IAuditableHandle)projectAreaHandle, ItemProfile.PROJECT_AREA_DEFAULT, monitor);
        String projectAreaName = projectArea.getName();
        if (projectAreaName != null) {
            URI uri = this.toURI((IItemHandle)projectAreaHandle);
            projectAreaBuilder.link(uri.toString(), projectAreaName);
        } else {
            projectAreaBuilder.plain(UNASSIGNED);
        }
        if (teamAreaBuilder.length() > 0) {
            builder.xml(NLS.bind((String)Messages.TeamAreaPresentationMarkupPart_TEAM_AREA_PROJECT_AREA_DIVIDER, (Object)((Object)teamAreaBuilder), (Object[])new Object[]{projectAreaBuilder}));
        } else {
            builder.xml(projectAreaBuilder.toString());
        }
    }
}

