/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.PresentationMarkupPart;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;

public class ResolutionAttributeMarkupPart
extends PresentationMarkupPart {
    public void fillPartName(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        builder.plain(Messages.ResolutionAttributeMarkupPart_RESOLUTION);
    }

    public void fillPartContent(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            this.internalFillPartContent(builder, monitor);
        }
        catch (TeamRepositoryException e) {
            this.handleException(builder, e);
        }
    }

    private void internalFillPartContent(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient workItemClient = this.getWorkItemClient();
        IWorkflowInfo workflow = workItemClient.findWorkflowInfo(this.getItem(), monitor);
        Identifier state = this.getItem().getState2();
        if (workflow != null) {
            boolean showResolution;
            Identifier[] stateResolutions = workflow.getStateResolutionIds(state);
            boolean bl = showResolution = stateResolutions.length > 0;
            if (showResolution) {
                URL url;
                Identifier resolution = this.getItem().getResolution2();
                String resolutionName = workflow.getResolutionName(resolution);
                if (resolutionName == null) {
                    resolutionName = resolution != null ? resolution.getStringIdentifier() : "";
                }
                if ((url = workflow.getResolutionIconName(resolution)) != null) {
                    builder.image(this.getLocalUrl(url), resolutionName);
                    builder.imageLabel(resolutionName);
                } else {
                    builder.plain(resolutionName);
                }
            }
        }
    }

    private String getLocalUrl(URL url) {
        ImageDescriptor imageDescriptor = WorkItemUI.getImageDescriptor((URL)url);
        URL url2 = JazzResources.createURL((ImageDescriptor)imageDescriptor);
        return JazzResources.getConformingURL((URL)url2);
    }
}

